/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-05-10 08:26:42 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `ethr_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=538 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2979 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1555 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_addonlibrary_addons` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `name` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `alias` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `addontype` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci,
  `ordering` int(11) NOT NULL,
  `templates` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `config` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `catid` int(11) DEFAULT NULL,
  `is_active` tinyint(4) DEFAULT NULL,
  `test_slot1` text COLLATE utf8mb4_unicode_520_ci,
  `test_slot2` text COLLATE utf8mb4_unicode_520_ci,
  `test_slot3` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_addonlibrary_categories` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ordering` int(11) NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` tinytext COLLATE utf8mb4_unicode_520_ci,
  `parent_id` int(9) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_aiowps_audit_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `network_id` bigint(20) NOT NULL DEFAULT '0',
  `site_id` bigint(20) NOT NULL DEFAULT '0',
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `event_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `details` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `stacktrace` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `ip` (`ip`),
  KEY `level` (`level`),
  KEY `event_type` (`event_type`)
) ENGINE=InnoDB AUTO_INCREMENT=144 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_aiowps_debug_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `network_id` bigint(20) NOT NULL DEFAULT '0',
  `site_id` bigint(20) NOT NULL DEFAULT '0',
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `logtime` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_aiowps_logged_in_users` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `site_id` bigint(20) NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  `expires` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_id` (`user_id`),
  KEY `created` (`created`),
  KEY `expires` (`expires`),
  KEY `user_id` (`user_id`),
  KEY `site_id` (`site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `is_lockout_email_sent` tinyint(1) NOT NULL DEFAULT '1',
  `backtrace_log` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ip_lookup_result` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` int(10) unsigned DEFAULT NULL,
  `released` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `failed_login_ip` (`failed_login_ip`),
  KEY `is_lockout_email_sent` (`is_lockout_email_sent`),
  KEY `unlock_key` (`unlock_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_aiowps_message_store` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `message_key` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  `created` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `blocked_ip` (`blocked_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_cartflows_ca_cart_abandonment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `checkout_id` int(11) NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `cart_contents` longtext COLLATE utf8mb4_unicode_520_ci,
  `cart_total` decimal(10,2) DEFAULT NULL,
  `session_id` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `other_fields` longtext COLLATE utf8mb4_unicode_520_ci,
  `order_status` enum('normal','abandoned','completed','lost') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'normal',
  `unsubscribed` tinyint(1) DEFAULT '0',
  `coupon_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`,`session_id`),
  UNIQUE KEY `session_id_UNIQUE` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_cartflows_ca_email_history` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `template_id` bigint(20) NOT NULL,
  `ca_session_id` varchar(60) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `coupon_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `scheduled_time` datetime DEFAULT NULL,
  `email_sent` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `template_id` (`template_id`),
  KEY `ca_session_id` (`ca_session_id`),
  CONSTRAINT `ethr_cartflows_ca_email_history_ibfk_1` FOREIGN KEY (`template_id`) REFERENCES `ethr_cartflows_ca_email_templates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ethr_cartflows_ca_email_history_ibfk_2` FOREIGN KEY (`ca_session_id`) REFERENCES `ethr_cartflows_ca_cart_abandonment` (`session_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_cartflows_ca_email_templates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `template_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email_subject` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email_body` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_activated` tinyint(1) NOT NULL DEFAULT '0',
  `frequency` int(11) NOT NULL,
  `frequency_unit` enum('MINUTE','HOUR','DAY') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'MINUTE',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_cartflows_ca_email_templates_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_template_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `email_template_id` (`email_template_id`),
  CONSTRAINT `ethr_cartflows_ca_email_templates_meta_ibfk_1` FOREIGN KEY (`email_template_id`) REFERENCES `ethr_cartflows_ca_email_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_gla_attribute_mapping_rules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_condition_type` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `categories` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_gla_budget_recommendations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `daily_budget` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_currency` (`country`,`currency`)
) ENGINE=InnoDB AUTO_INCREMENT=4231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_gla_merchant_issues` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `issue` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'warning',
  `product` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_url` varchar(1024) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `applicable_countries` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'mc',
  `type` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'product',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_gla_shipping_rates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate` double NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `country` (`country`),
  KEY `currency` (`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_gla_shipping_times` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_jetpack_sync_queue` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `queue_id` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `event_id` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `event_payload` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  KEY `event_id` (`event_id`),
  KEY `queue_id` (`queue_id`),
  KEY `queue_id_event_id` (`queue_id`,`event_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB AUTO_INCREMENT=675 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cache_tags` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=16465 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=6569 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=4790 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_taxjar_record_queue` (
  `queue_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `record_id` bigint(20) unsigned NOT NULL,
  `record_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `force_push` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'new',
  `batch_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `created_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `processed_datetime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `retry_count` smallint(4) NOT NULL DEFAULT '0',
  `last_error` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`queue_id`),
  KEY `record_id` (`record_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11258 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `ethr_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: ethr_actionscheduler_actions */
INSERT INTO `ethr_actionscheduler_actions` VALUES("19", "cartflows_send_report_summary_email", "failed", "2024-01-22 14:00:00", "2024-01-22 14:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1705932000;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1705932000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-01-22 17:27:54", "2024-01-22 17:27:54", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("21", "cartflows_update_knowledge_base_data", "failed", "2024-01-24 00:10:46", "2024-01-24 00:10:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1706055046;s:18:\"\0*\0first_timestamp\";i:1705450195;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1706055046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-01-24 03:02:12", "2024-01-24 03:02:12", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("22", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2024-01-17 00:11:18", "2024-01-17 00:11:18", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-01-17 00:11:49", "2024-01-17 00:11:49", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("43", "cartflows_send_report_summary_email", "failed", "2024-01-29 17:27:54", "2024-01-29 17:27:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1706549274;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1706549274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-01-30 05:21:39", "2024-01-30 05:21:39", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("48", "cartflows_update_knowledge_base_data", "failed", "2024-01-31 03:02:12", "2024-01-31 03:02:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1706670132;s:18:\"\0*\0first_timestamp\";i:1705450195;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1706670132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-01-31 06:51:03", "2024-01-31 06:51:03", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("60", "cartflows_update_knowledge_base_data", "failed", "2024-02-07 06:51:03", "2024-02-07 06:51:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1707288663;s:18:\"\0*\0first_timestamp\";i:1705450195;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1707288663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-02-07 09:45:09", "2024-02-07 09:45:09", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("170", "cartflows_update_knowledge_base_data", "failed", "2024-02-14 09:45:10", "2024-02-14 09:45:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1707903910;s:18:\"\0*\0first_timestamp\";i:1705450195;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1707903910;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-02-15 09:27:23", "2024-02-15 09:27:23", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("185", "cartflows_update_knowledge_base_data", "failed", "2024-02-22 09:27:23", "2024-02-22 09:27:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1708594043;s:18:\"\0*\0first_timestamp\";i:1705450195;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1708594043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-02-22 18:13:21", "2024-02-22 18:13:21", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("209", "cartflows_update_knowledge_base_data", "failed", "2024-03-08 01:49:39", "2024-03-08 01:49:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1709862579;s:18:\"\0*\0first_timestamp\";i:1709257770;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1709862579;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-03-10 07:43:52", "2024-03-10 07:43:52", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("229", "cartflows_update_knowledge_base_data", "failed", "2024-03-19 12:14:32", "2024-03-19 12:14:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1710850472;s:18:\"\0*\0first_timestamp\";i:1710245658;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1710850472;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-03-19 13:12:33", "2024-03-19 13:12:33", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("250", "cartflows_update_knowledge_base_data", "failed", "2024-03-21 15:29:35", "2024-03-21 15:29:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711034975;s:18:\"\0*\0first_timestamp\";i:1711034975;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711034975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-03-21 15:29:38", "2024-03-21 15:29:38", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("254", "cartflows_update_knowledge_base_data", "failed", "2024-03-22 01:05:20", "2024-03-22 01:05:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711069520;s:18:\"\0*\0first_timestamp\";i:1711069520;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711069520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-03-22 01:05:50", "2024-03-22 01:05:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("255", "cartflows_update_knowledge_base_data", "failed", "2024-03-22 01:06:43", "2024-03-22 01:06:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711069603;s:18:\"\0*\0first_timestamp\";i:1711069603;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711069603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-03-22 08:06:31", "2024-03-22 08:06:31", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("268", "cartflows_update_knowledge_base_data", "failed", "2024-04-02 11:01:38", "2024-04-02 11:01:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712055698;s:18:\"\0*\0first_timestamp\";i:1711450883;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712055698;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-02 12:26:24", "2024-04-02 12:26:24", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("311", "cartflows_delete_old_log_files", "complete", "2024-05-01 10:51:47", "2024-05-01 10:51:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714560707;s:18:\"\0*\0first_timestamp\";i:1706659200;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714560707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "2", "1", "2024-05-01 15:47:02", "2024-05-01 15:47:02", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("316", "cartflows_update_knowledge_base_data", "failed", "2024-04-09 23:46:59", "2024-04-09 23:46:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712706419;s:18:\"\0*\0first_timestamp\";i:1712101612;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712706419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-10 03:10:50", "2024-04-10 03:10:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("326", "action_scheduler/migration_hook", "failed", "2024-04-04 14:25:15", "2024-04-04 14:25:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1712240715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1712240715;}", "1", "1", "2024-04-04 14:26:23", "2024-04-04 14:26:23", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("336", "cartflows_send_report_summary_email", "complete", "2024-04-15 02:33:41", "2024-04-15 02:33:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713148421;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713148421;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-15 09:43:27", "2024-04-15 09:43:27", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("337", "cartflows_ca_send_report_summary_email", "complete", "2024-04-15 02:33:41", "2024-04-15 02:33:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713148421;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713148421;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-15 09:43:27", "2024-04-15 09:43:27", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("338", "woocommerce_cleanup_draft_orders", "complete", "2024-04-09 19:46:07", "2024-04-09 19:46:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712691967;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712691967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-10 03:10:50", "2024-04-10 03:10:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("339", "woocommerce_cleanup_draft_orders", "complete", "2024-04-09 19:46:07", "2024-04-09 19:46:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712691967;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712691967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-10 03:10:50", "2024-04-10 03:10:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("340", "wc_gla_cron_daily_notes", "complete", "2024-04-09 19:46:07", "2024-04-09 19:46:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712691967;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712691967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-10 03:10:50", "2024-04-10 03:10:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("341", "woocommerce_cleanup_draft_orders", "complete", "2024-04-11 03:10:50", "2024-04-11 03:10:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712805050;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712805050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-11 03:25:45", "2024-04-11 03:25:45", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("342", "woocommerce_cleanup_draft_orders", "complete", "2024-04-11 03:10:50", "2024-04-11 03:10:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712805050;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712805050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-11 03:25:45", "2024-04-11 03:25:45", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("343", "wc_gla_cron_daily_notes", "complete", "2024-04-11 03:10:50", "2024-04-11 03:10:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712805050;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712805050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-11 03:25:45", "2024-04-11 03:25:45", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("344", "cartflows_update_knowledge_base_data", "failed", "2024-04-10 04:50:20", "2024-04-10 04:50:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712724620;s:18:\"\0*\0first_timestamp\";i:1712724620;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712724620;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-10 04:50:22", "2024-04-10 04:50:22", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("345", "cartflows_update_knowledge_base_data", "complete", "2024-04-10 04:50:25", "2024-04-10 04:50:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712724625;s:18:\"\0*\0first_timestamp\";i:1712724625;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712724625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-10 04:50:25", "2024-04-10 04:50:25", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("346", "cartflows_update_knowledge_base_data", "failed", "2024-04-17 04:50:25", "2024-04-17 04:50:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713329425;s:18:\"\0*\0first_timestamp\";i:1712724625;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713329425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-17 22:25:23", "2024-04-17 22:25:23", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("347", "woocommerce_cleanup_draft_orders", "complete", "2024-04-12 03:25:45", "2024-04-12 03:25:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712892345;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712892345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-12 04:01:08", "2024-04-12 04:01:08", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("348", "woocommerce_cleanup_draft_orders", "complete", "2024-04-12 03:25:45", "2024-04-12 03:25:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712892345;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712892345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-12 04:01:08", "2024-04-12 04:01:08", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("349", "wc_gla_cron_daily_notes", "complete", "2024-04-12 03:25:45", "2024-04-12 03:25:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712892345;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712892345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-12 04:01:08", "2024-04-12 04:01:08", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("350", "woocommerce_cleanup_draft_orders", "complete", "2024-04-13 04:01:08", "2024-04-13 04:01:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712980868;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712980868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-13 11:39:58", "2024-04-13 11:39:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("351", "woocommerce_cleanup_draft_orders", "complete", "2024-04-13 04:01:08", "2024-04-13 04:01:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712980868;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712980868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-13 11:39:58", "2024-04-13 11:39:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("352", "wc_gla_cron_daily_notes", "complete", "2024-04-13 04:01:08", "2024-04-13 04:01:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1712980868;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1712980868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-13 11:39:58", "2024-04-13 11:39:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("353", "woocommerce_cleanup_draft_orders", "complete", "2024-04-14 11:39:58", "2024-04-14 11:39:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713094798;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713094798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-14 12:27:50", "2024-04-14 12:27:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("354", "woocommerce_cleanup_draft_orders", "complete", "2024-04-14 11:39:58", "2024-04-14 11:39:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713094798;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713094798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-14 12:27:50", "2024-04-14 12:27:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("355", "wc_gla_cron_daily_notes", "complete", "2024-04-14 11:39:58", "2024-04-14 11:39:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713094798;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713094798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-14 12:27:50", "2024-04-14 12:27:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("356", "woocommerce_update_marketplace_suggestions", "complete", "2024-04-13 11:58:21", "2024-04-13 11:58:21", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1713009501;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1713009501;}", "2", "1", "2024-04-13 11:58:49", "2024-04-13 11:58:49", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("357", "woocommerce_cleanup_draft_orders", "complete", "2024-04-15 12:27:50", "2024-04-15 12:27:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713184070;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713184070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-15 12:56:58", "2024-04-15 12:56:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("358", "woocommerce_cleanup_draft_orders", "complete", "2024-04-15 12:27:50", "2024-04-15 12:27:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713184070;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713184070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-15 12:56:58", "2024-04-15 12:56:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("359", "wc_gla_cron_daily_notes", "complete", "2024-04-15 12:27:50", "2024-04-15 12:27:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713184070;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713184070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-15 12:56:58", "2024-04-15 12:56:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("360", "cartflows_send_report_summary_email", "complete", "2024-04-22 09:43:27", "2024-04-22 09:43:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713779007;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713779007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-22 11:13:55", "2024-04-22 11:13:55", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("361", "cartflows_ca_send_report_summary_email", "complete", "2024-04-22 09:43:27", "2024-04-22 09:43:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713779007;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713779007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-22 11:13:55", "2024-04-22 11:13:55", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("362", "woocommerce_cleanup_draft_orders", "complete", "2024-04-16 12:56:58", "2024-04-16 12:56:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713272218;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713272218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-16 15:15:44", "2024-04-16 15:15:44", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("363", "woocommerce_cleanup_draft_orders", "complete", "2024-04-16 12:56:58", "2024-04-16 12:56:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713272218;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713272218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-16 15:15:44", "2024-04-16 15:15:44", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("364", "wc_gla_cron_daily_notes", "complete", "2024-04-16 12:56:58", "2024-04-16 12:56:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713272218;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713272218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-16 15:15:44", "2024-04-16 15:15:44", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("365", "woocommerce_cleanup_draft_orders", "complete", "2024-04-17 15:15:44", "2024-04-17 15:15:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713366944;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713366944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-17 22:25:23", "2024-04-17 22:25:23", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("366", "woocommerce_cleanup_draft_orders", "complete", "2024-04-17 15:15:44", "2024-04-17 15:15:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713366944;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713366944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-17 22:25:23", "2024-04-17 22:25:23", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("367", "wc_gla_cron_daily_notes", "complete", "2024-04-17 15:15:44", "2024-04-17 15:15:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713366944;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713366944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-17 22:25:23", "2024-04-17 22:25:23", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("368", "woocommerce_cleanup_draft_orders", "complete", "2024-04-18 22:25:23", "2024-04-18 22:25:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713479123;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713479123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-19 09:55:01", "2024-04-19 09:55:01", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("369", "woocommerce_cleanup_draft_orders", "complete", "2024-04-18 22:25:23", "2024-04-18 22:25:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713479123;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713479123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-19 09:55:02", "2024-04-19 09:55:02", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("370", "wc_gla_cron_daily_notes", "complete", "2024-04-18 22:25:23", "2024-04-18 22:25:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713479123;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713479123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-19 09:55:02", "2024-04-19 09:55:02", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("371", "cartflows_update_knowledge_base_data", "complete", "2024-04-17 22:25:29", "2024-04-17 22:25:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713392729;s:18:\"\0*\0first_timestamp\";i:1713392729;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713392729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-17 22:25:36", "2024-04-17 22:25:36", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("372", "cartflows_update_knowledge_base_data", "failed", "2024-04-24 22:25:36", "2024-04-24 22:25:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713997536;s:18:\"\0*\0first_timestamp\";i:1713392729;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713997536;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-24 22:26:06", "2024-04-24 22:26:06", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("373", "woocommerce_cleanup_draft_orders", "complete", "2024-04-20 09:55:01", "2024-04-20 09:55:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713606901;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713606901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-20 20:23:25", "2024-04-20 20:23:25", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("374", "woocommerce_cleanup_draft_orders", "complete", "2024-04-20 09:55:02", "2024-04-20 09:55:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713606902;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713606902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-20 20:23:25", "2024-04-20 20:23:25", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("375", "wc_gla_cron_daily_notes", "complete", "2024-04-20 09:55:02", "2024-04-20 09:55:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713606902;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713606902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-20 20:23:25", "2024-04-20 20:23:25", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("376", "woocommerce_cleanup_draft_orders", "complete", "2024-04-21 20:23:25", "2024-04-21 20:23:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713731005;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713731005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-21 23:51:54", "2024-04-21 23:51:54", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("377", "woocommerce_cleanup_draft_orders", "complete", "2024-04-21 20:23:25", "2024-04-21 20:23:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713731005;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713731005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-21 23:51:55", "2024-04-21 23:51:55", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("378", "wc_gla_cron_daily_notes", "complete", "2024-04-21 20:23:25", "2024-04-21 20:23:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713731005;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713731005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-21 23:51:55", "2024-04-21 23:51:55", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("379", "woocommerce_cleanup_draft_orders", "complete", "2024-04-22 23:51:55", "2024-04-22 23:51:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713829915;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713829915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-23 00:26:10", "2024-04-23 00:26:10", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("380", "woocommerce_cleanup_draft_orders", "complete", "2024-04-22 23:51:55", "2024-04-22 23:51:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713829915;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713829915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-23 00:26:10", "2024-04-23 00:26:10", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("381", "wc_gla_cron_daily_notes", "complete", "2024-04-22 23:51:55", "2024-04-22 23:51:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713829915;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713829915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-23 00:26:10", "2024-04-23 00:26:10", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("382", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-04-22 00:27:45", "2024-04-22 00:27:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1713745665;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1713745665;}", "5", "1", "2024-04-22 00:28:04", "2024-04-22 00:28:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("383", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-04-22 00:27:44", "2024-04-22 00:27:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1713745664;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1713745664;}", "6", "1", "2024-04-22 00:28:04", "2024-04-22 00:28:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("384", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-22 00:27:55", "2024-04-22 00:27:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713745675;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713745675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-22 00:28:05", "2024-04-22 00:28:05", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("385", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-04-22 00:28:05", "2024-04-22 00:28:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1713745685;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1713745685;}", "5", "1", "2024-04-22 00:28:05", "2024-04-22 00:28:05", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("386", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-22 12:28:05", "2024-04-22 12:28:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713788885;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713788885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-22 12:31:38", "2024-04-22 12:31:38", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("387", "cartflows_send_report_summary_email", "complete", "2024-04-29 14:00:00", "2024-04-29 14:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714399200;s:18:\"\0*\0first_timestamp\";i:1714399200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714399200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-30 05:27:04", "2024-04-30 05:27:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("388", "cartflows_send_report_summary_email", "complete", "2024-04-29 11:13:55", "2024-04-29 11:13:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714389235;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714389235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-30 05:27:04", "2024-04-30 05:27:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("389", "cartflows_ca_send_report_summary_email", "complete", "2024-04-29 14:00:00", "2024-04-29 14:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714399200;s:18:\"\0*\0first_timestamp\";i:1714399200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714399200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-30 05:27:04", "2024-04-30 05:27:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("390", "cartflows_ca_send_report_summary_email", "complete", "2024-04-29 11:13:55", "2024-04-29 11:13:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714389235;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714389235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-30 05:27:04", "2024-04-30 05:27:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("391", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-23 00:31:38", "2024-04-23 00:31:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713832298;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713832298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-23 00:33:24", "2024-04-23 00:33:24", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("392", "woocommerce_cleanup_draft_orders", "complete", "2024-04-24 00:26:10", "2024-04-24 00:26:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713918370;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713918370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-24 00:34:03", "2024-04-24 00:34:03", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("393", "woocommerce_cleanup_draft_orders", "complete", "2024-04-24 00:26:10", "2024-04-24 00:26:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713918370;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713918370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-24 00:34:03", "2024-04-24 00:34:03", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("394", "wc_gla_cron_daily_notes", "complete", "2024-04-24 00:26:10", "2024-04-24 00:26:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713918370;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713918370;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-24 00:34:03", "2024-04-24 00:34:03", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("395", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-23 12:33:24", "2024-04-23 12:33:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713875604;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713875604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-23 12:58:59", "2024-04-23 12:58:59", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("396", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-24 00:58:59", "2024-04-24 00:58:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713920339;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713920339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-24 01:08:48", "2024-04-24 01:08:48", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("397", "woocommerce_update_marketplace_suggestions", "complete", "2024-04-23 13:12:38", "2024-04-23 13:12:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1713877958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1713877958;}", "2", "1", "2024-04-23 13:12:58", "2024-04-23 13:12:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("398", "woocommerce_cleanup_draft_orders", "complete", "2024-04-25 00:34:03", "2024-04-25 00:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714005243;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714005243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-25 00:34:41", "2024-04-25 00:34:41", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("399", "woocommerce_cleanup_draft_orders", "complete", "2024-04-25 00:34:03", "2024-04-25 00:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714005243;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714005243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-25 00:34:41", "2024-04-25 00:34:41", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("400", "wc_gla_cron_daily_notes", "complete", "2024-04-25 00:34:03", "2024-04-25 00:34:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714005243;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714005243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-25 00:34:41", "2024-04-25 00:34:41", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("401", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-24 13:08:48", "2024-04-24 13:08:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713964128;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713964128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-24 13:55:28", "2024-04-24 13:55:28", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("402", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-25 01:55:28", "2024-04-25 01:55:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714010128;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714010128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-25 02:18:58", "2024-04-25 02:18:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("403", "cartflows_update_knowledge_base_data", "complete", "2024-04-24 22:26:06", "2024-04-24 22:26:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1713997566;s:18:\"\0*\0first_timestamp\";i:1713997566;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1713997566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-04-24 22:26:06", "2024-04-24 22:26:06", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("404", "cartflows_update_knowledge_base_data", "failed", "2024-05-01 22:26:06", "2024-05-01 22:26:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714602366;s:18:\"\0*\0first_timestamp\";i:1713997566;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714602366;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-05-01 23:20:58", "2024-05-01 23:20:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("405", "woocommerce_cleanup_draft_orders", "complete", "2024-04-26 00:34:41", "2024-04-26 00:34:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714091681;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714091681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-26 00:35:01", "2024-04-26 00:35:01", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("406", "woocommerce_cleanup_draft_orders", "complete", "2024-04-26 00:34:41", "2024-04-26 00:34:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714091681;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714091681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-26 00:35:01", "2024-04-26 00:35:01", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("407", "wc_gla_cron_daily_notes", "complete", "2024-04-26 00:34:41", "2024-04-26 00:34:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714091681;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714091681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-26 00:35:01", "2024-04-26 00:35:01", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("408", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-25 14:18:58", "2024-04-25 14:18:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714054738;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714054738;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-25 16:05:57", "2024-04-25 16:05:57", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("409", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-26 04:05:57", "2024-04-26 04:05:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714104357;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714104357;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-26 04:31:41", "2024-04-26 04:31:41", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("410", "woocommerce_cleanup_draft_orders", "complete", "2024-04-27 00:35:01", "2024-04-27 00:35:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714178101;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714178101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-28 13:46:19", "2024-04-28 13:46:19", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("411", "woocommerce_cleanup_draft_orders", "complete", "2024-04-27 00:35:01", "2024-04-27 00:35:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714178101;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714178101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-28 13:46:19", "2024-04-28 13:46:19", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("412", "wc_gla_cron_daily_notes", "complete", "2024-04-27 00:35:01", "2024-04-27 00:35:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714178101;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714178101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-28 13:46:19", "2024-04-28 13:46:19", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("413", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-26 16:31:41", "2024-04-26 16:31:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714149101;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714149101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-28 13:46:19", "2024-04-28 13:46:19", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("414", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-29 01:46:19", "2024-04-29 01:46:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714355179;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714355179;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-29 05:22:29", "2024-04-29 05:22:29", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("415", "woocommerce_cleanup_draft_orders", "complete", "2024-04-29 13:46:19", "2024-04-29 13:46:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714398379;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714398379;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-30 05:27:04", "2024-04-30 05:27:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("416", "woocommerce_cleanup_draft_orders", "complete", "2024-04-29 13:46:19", "2024-04-29 13:46:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714398379;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714398379;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-04-30 05:27:04", "2024-04-30 05:27:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("417", "wc_gla_cron_daily_notes", "complete", "2024-04-29 13:46:19", "2024-04-29 13:46:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714398379;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714398379;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-04-30 05:27:04", "2024-04-30 05:27:04", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("418", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-29 17:22:29", "2024-04-29 17:22:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714411349;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714411349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-30 05:27:05", "2024-04-30 05:27:05", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("419", "cartflows_send_report_summary_email", "complete", "2024-05-07 05:27:04", "2024-05-07 05:27:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715059624;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715059624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-05-07 12:09:49", "2024-05-07 12:09:49", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("420", "cartflows_ca_send_report_summary_email", "complete", "2024-05-07 05:27:04", "2024-05-07 05:27:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715059624;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715059624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-05-07 12:09:49", "2024-05-07 12:09:49", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("421", "woocommerce_cleanup_draft_orders", "complete", "2024-05-01 05:27:04", "2024-05-01 05:27:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714541224;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714541224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-01 15:47:01", "2024-05-01 15:47:01", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("422", "woocommerce_cleanup_draft_orders", "complete", "2024-05-01 05:27:04", "2024-05-01 05:27:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714541224;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714541224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-01 15:47:01", "2024-05-01 15:47:01", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("423", "wc_gla_cron_daily_notes", "complete", "2024-05-01 05:27:04", "2024-05-01 05:27:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714541224;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714541224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-05-01 15:47:01", "2024-05-01 15:47:01", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("424", "cartflows_send_report_summary_email", "complete", "2024-05-07 05:27:04", "2024-05-07 05:27:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715059624;s:18:\"\0*\0first_timestamp\";i:1714399200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715059624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-05-07 12:09:49", "2024-05-07 12:09:49", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("425", "cartflows_ca_send_report_summary_email", "complete", "2024-05-07 05:27:04", "2024-05-07 05:27:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715059624;s:18:\"\0*\0first_timestamp\";i:1714399200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715059624;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-05-07 12:09:49", "2024-05-07 12:09:49", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("426", "woocommerce_marketplace_fetch_promotions", "complete", "2024-04-30 17:27:05", "2024-04-30 17:27:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714498025;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714498025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-04-30 18:16:51", "2024-04-30 18:16:51", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("427", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-01 06:16:51", "2024-05-01 06:16:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714544211;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714544211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-01 15:47:02", "2024-05-01 15:47:02", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("428", "woocommerce_cleanup_draft_orders", "complete", "2024-05-02 15:47:01", "2024-05-02 15:47:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714664821;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714664821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-02 16:10:47", "2024-05-02 16:10:47", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("429", "woocommerce_cleanup_draft_orders", "complete", "2024-05-02 15:47:01", "2024-05-02 15:47:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714664821;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714664821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-02 16:10:47", "2024-05-02 16:10:47", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("430", "wc_gla_cron_daily_notes", "complete", "2024-05-02 15:47:01", "2024-05-02 15:47:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714664821;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714664821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-05-02 16:10:47", "2024-05-02 16:10:47", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("431", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-02 03:47:02", "2024-05-02 03:47:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714621622;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714621622;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-02 06:47:08", "2024-05-02 06:47:08", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("432", "cartflows_delete_old_log_files", "pending", "2024-05-31 15:47:02", "2024-05-31 15:47:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1717170422;s:18:\"\0*\0first_timestamp\";i:1706659200;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1717170422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("433", "woocommerce_update_marketplace_suggestions", "complete", "2024-05-01 15:54:35", "2024-05-01 15:54:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714578875;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714578875;}", "2", "1", "2024-05-01 15:54:54", "2024-05-01 15:54:54", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("434", "cartflows_update_knowledge_base_data", "complete", "2024-05-01 23:23:26", "2024-05-01 23:23:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714605806;s:18:\"\0*\0first_timestamp\";i:1714605806;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714605806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-05-01 23:23:30", "2024-05-01 23:23:30", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("435", "cartflows_update_knowledge_base_data", "failed", "2024-05-08 23:23:30", "2024-05-08 23:23:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715210610;s:18:\"\0*\0first_timestamp\";i:1714605806;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715210610;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-05-08 23:49:29", "2024-05-08 23:49:29", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("436", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-05-01 23:26:03", "2024-05-01 23:26:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714605963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714605963;}", "5", "1", "2024-05-01 23:28:28", "2024-05-01 23:28:28", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("437", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-05-01 23:26:02", "2024-05-01 23:26:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714605962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714605962;}", "6", "1", "2024-05-01 23:28:28", "2024-05-01 23:28:28", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("438", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2024-05-01 23:28:29", "2024-05-01 23:28:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714606109;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714606109;}", "5", "1", "2024-05-01 23:29:30", "2024-05-01 23:29:30", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("439", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-02 18:47:08", "2024-05-02 18:47:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714675628;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714675628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-02 19:08:05", "2024-05-02 19:08:05", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("440", "woocommerce_cleanup_draft_orders", "complete", "2024-05-03 16:10:47", "2024-05-03 16:10:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714752647;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714752647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-03 21:45:06", "2024-05-03 21:45:06", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("441", "woocommerce_cleanup_draft_orders", "complete", "2024-05-03 16:10:47", "2024-05-03 16:10:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714752647;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714752647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-03 21:45:06", "2024-05-03 21:45:06", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("442", "wc_gla_cron_daily_notes", "complete", "2024-05-03 16:10:47", "2024-05-03 16:10:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714752647;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714752647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-05-03 21:45:06", "2024-05-03 21:45:06", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("443", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-03 07:08:05", "2024-05-03 07:08:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714720085;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714720085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-03 12:06:56", "2024-05-03 12:06:56", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("444", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-04 00:06:56", "2024-05-04 00:06:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714781216;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714781216;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-04 00:06:58", "2024-05-04 00:06:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("445", "woocommerce_cleanup_draft_orders", "complete", "2024-05-04 21:45:06", "2024-05-04 21:45:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714859106;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714859106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-05 06:31:57", "2024-05-05 06:31:57", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("446", "woocommerce_cleanup_draft_orders", "complete", "2024-05-04 21:45:06", "2024-05-04 21:45:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714859106;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714859106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-05 06:31:57", "2024-05-05 06:31:57", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("447", "wc_gla_cron_daily_notes", "complete", "2024-05-04 21:45:06", "2024-05-04 21:45:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714859106;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714859106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-05-05 06:31:57", "2024-05-05 06:31:57", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("448", "action_scheduler/migration_hook", "complete", "2024-05-03 22:21:50", "2024-05-03 22:21:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714774910;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714774910;}", "1", "1", "2024-05-03 22:23:03", "2024-05-03 22:23:03", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("449", "action_scheduler/migration_hook", "failed", "2024-05-03 22:24:06", "2024-05-03 22:24:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714775046;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714775046;}", "1", "1", "2024-05-03 22:25:08", "2024-05-03 22:25:08", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("450", "action_scheduler/migration_hook", "complete", "2024-05-03 23:34:17", "2024-05-03 23:34:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714779257;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714779257;}", "1", "1", "2024-05-03 23:34:23", "2024-05-03 23:34:23", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("451", "action_scheduler/migration_hook", "failed", "2024-05-03 23:35:24", "2024-05-03 23:35:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1714779324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1714779324;}", "1", "1", "2024-05-03 23:35:50", "2024-05-03 23:35:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("452", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-04 12:06:58", "2024-05-04 12:06:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714824418;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714824418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-04 16:51:29", "2024-05-04 16:51:29", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("453", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-05 04:51:29", "2024-05-05 04:51:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714884689;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714884689;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-05 06:31:58", "2024-05-05 06:31:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("454", "woocommerce_cleanup_draft_orders", "complete", "2024-05-06 06:31:57", "2024-05-06 06:31:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714977117;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714977117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-06 13:39:07", "2024-05-06 13:39:07", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("455", "woocommerce_cleanup_draft_orders", "complete", "2024-05-06 06:31:57", "2024-05-06 06:31:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714977117;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714977117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-06 13:39:07", "2024-05-06 13:39:07", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("456", "wc_gla_cron_daily_notes", "complete", "2024-05-06 06:31:57", "2024-05-06 06:31:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714977117;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714977117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-05-06 13:39:07", "2024-05-06 13:39:07", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("457", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-05 18:31:58", "2024-05-05 18:31:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714933918;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714933918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-06 00:00:59", "2024-05-06 00:00:59", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("458", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-06 12:00:59", "2024-05-06 12:00:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1714996859;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1714996859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-06 13:39:07", "2024-05-06 13:39:07", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("459", "woocommerce_cleanup_draft_orders", "complete", "2024-05-07 13:39:07", "2024-05-07 13:39:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715089147;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715089147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-07 14:03:31", "2024-05-07 14:03:31", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("460", "woocommerce_cleanup_draft_orders", "complete", "2024-05-07 13:39:07", "2024-05-07 13:39:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715089147;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715089147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-07 14:03:31", "2024-05-07 14:03:31", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("461", "wc_gla_cron_daily_notes", "complete", "2024-05-07 13:39:07", "2024-05-07 13:39:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715089147;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715089147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-05-07 14:03:31", "2024-05-07 14:03:31", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("462", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-07 01:39:07", "2024-05-07 01:39:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715045947;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715045947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-07 01:57:23", "2024-05-07 01:57:23", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("463", "action_scheduler/migration_hook", "complete", "2024-05-06 19:22:34", "2024-05-06 19:22:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715023354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715023354;}", "1", "1", "2024-05-06 19:22:50", "2024-05-06 19:22:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("464", "action_scheduler/migration_hook", "complete", "2024-05-06 19:26:41", "2024-05-06 19:26:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715023601;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715023601;}", "1", "1", "2024-05-06 19:26:50", "2024-05-06 19:26:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("465", "action_scheduler/migration_hook", "complete", "2024-05-06 19:43:13", "2024-05-06 19:43:13", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715024593;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715024593;}", "1", "1", "2024-05-06 19:44:17", "2024-05-06 19:44:17", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("466", "action_scheduler/migration_hook", "failed", "2024-05-06 19:45:26", "2024-05-06 19:45:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715024726;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715024726;}", "1", "1", "2024-05-06 19:45:57", "2024-05-06 19:45:57", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("467", "action_scheduler/migration_hook", "complete", "2024-05-06 20:22:33", "2024-05-06 20:22:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715026953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715026953;}", "1", "1", "2024-05-06 20:22:57", "2024-05-06 20:22:57", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("468", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-05-06 21:24:02", "2024-05-06 21:24:02", "10", "[4603,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715030642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715030642;}", "5", "1", "2024-05-06 21:24:12", "2024-05-06 21:24:12", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("469", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-07 13:57:23", "2024-05-07 13:57:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715090243;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715090243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-07 14:03:32", "2024-05-07 14:03:32", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("470", "cartflows_send_report_summary_email", "pending", "2024-05-14 12:09:49", "2024-05-14 12:09:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715688589;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715688589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("471", "cartflows_ca_send_report_summary_email", "pending", "2024-05-14 12:09:49", "2024-05-14 12:09:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715688589;s:18:\"\0*\0first_timestamp\";i:1705932000;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715688589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("472", "cartflows_send_report_summary_email", "pending", "2024-05-14 12:09:49", "2024-05-14 12:09:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715688589;s:18:\"\0*\0first_timestamp\";i:1714399200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715688589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("473", "cartflows_ca_send_report_summary_email", "pending", "2024-05-14 12:09:49", "2024-05-14 12:09:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715688589;s:18:\"\0*\0first_timestamp\";i:1714399200;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715688589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("474", "woocommerce_cleanup_draft_orders", "complete", "2024-05-08 14:03:31", "2024-05-08 14:03:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715177011;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715177011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-08 14:05:33", "2024-05-08 14:05:33", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("475", "woocommerce_cleanup_draft_orders", "complete", "2024-05-08 14:03:31", "2024-05-08 14:03:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715177011;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715177011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-08 14:05:33", "2024-05-08 14:05:33", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("476", "wc_gla_cron_daily_notes", "complete", "2024-05-08 14:03:31", "2024-05-08 14:03:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715177011;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715177011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-05-08 14:05:33", "2024-05-08 14:05:33", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("477", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-08 02:03:32", "2024-05-08 02:03:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715133812;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715133812;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-08 12:45:35", "2024-05-08 12:45:35", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("478", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-09 00:45:35", "2024-05-09 00:45:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715215535;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715215535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-09 10:13:51", "2024-05-09 10:13:51", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("479", "woocommerce_cleanup_draft_orders", "complete", "2024-05-09 14:05:33", "2024-05-09 14:05:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715263533;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715263533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-09 14:06:58", "2024-05-09 14:06:58", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("480", "woocommerce_cleanup_draft_orders", "complete", "2024-05-09 14:05:33", "2024-05-09 14:05:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715263533;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715263533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-05-09 14:07:15", "2024-05-09 14:07:15", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("481", "wc_gla_cron_daily_notes", "complete", "2024-05-09 14:05:33", "2024-05-09 14:05:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715263533;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715263533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2024-05-09 14:07:41", "2024-05-09 14:07:41", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("482", "wc-admin_import_orders", "complete", "2024-05-08 14:14:36", "2024-05-08 14:14:36", "10", "[4785]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177676;}", "9", "1", "2024-05-08 14:14:50", "2024-05-08 14:14:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("484", "wcpay_add_fee_breakdown_to_order_notes", "complete", "2024-05-08 14:14:34", "2024-05-08 14:14:34", "10", "{\"order_id\":4785,\"intent_id\":\"pi_3PEBGOFvO9wzZIIA0AULtoau\",\"is_test_mode\":false}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177674;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177674;}", "8", "1", "2024-05-08 14:14:49", "2024-05-08 14:14:49", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("487", "wc-admin_import_orders", "complete", "2024-05-08 14:14:54", "2024-05-08 14:14:54", "10", "[4785]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177694;}", "9", "1", "2024-05-08 14:15:18", "2024-05-08 14:15:18", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("488", "wcpay_track_new_order", "complete", "2024-05-08 14:14:54", "2024-05-08 14:14:54", "10", "{\"order_id\":4785}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177694;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177694;}", "8", "1", "2024-05-08 14:15:19", "2024-05-08 14:15:19", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("489", "wc-admin_import_orders", "complete", "2024-05-08 14:15:24", "2024-05-08 14:15:24", "10", "[4785]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177724;}", "9", "1", "2024-05-08 14:15:29", "2024-05-08 14:15:29", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("490", "wcpay_track_update_order", "complete", "2024-05-08 14:15:24", "2024-05-08 14:15:24", "10", "{\"order_id\":4785}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177724;}", "8", "1", "2024-05-08 14:15:30", "2024-05-08 14:15:30", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("491", "wc-admin_import_orders", "complete", "2024-05-08 14:15:45", "2024-05-08 14:15:45", "10", "[4786]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177745;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177745;}", "9", "1", "2024-05-08 14:17:07", "2024-05-08 14:17:07", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("494", "wcpay_add_fee_breakdown_to_order_notes", "complete", "2024-05-08 14:15:44", "2024-05-08 14:15:44", "10", "{\"order_id\":4786,\"intent_id\":\"pi_3PEBHWFvO9wzZIIA1exbZokw\",\"is_test_mode\":false}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177744;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177744;}", "8", "1", "2024-05-08 14:16:52", "2024-05-08 14:16:52", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("496", "wcpay_track_new_order", "canceled", "2024-05-08 14:15:55", "2024-05-08 14:15:55", "10", "{\"order_id\":4786}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177755;}", "8", "0", "2024-05-08 14:16:48", "2024-05-08 14:16:48", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("497", "wc-admin_import_orders", "complete", "2024-05-08 14:16:56", "2024-05-08 14:16:56", "10", "[4786]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177816;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177816;}", "9", "1", "2024-05-08 14:17:15", "2024-05-08 14:17:15", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("498", "wcpay_track_new_order", "complete", "2024-05-08 14:16:56", "2024-05-08 14:16:56", "10", "{\"order_id\":4786}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177816;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177816;}", "8", "1", "2024-05-08 14:17:16", "2024-05-08 14:17:16", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("499", "wc-admin_import_orders", "complete", "2024-05-08 14:17:21", "2024-05-08 14:17:21", "10", "[4786]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177841;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177841;}", "9", "1", "2024-05-08 14:17:29", "2024-05-08 14:17:29", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("500", "wcpay_track_update_order", "complete", "2024-05-08 14:17:21", "2024-05-08 14:17:21", "10", "{\"order_id\":4786}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177841;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177841;}", "8", "1", "2024-05-08 14:17:30", "2024-05-08 14:17:30", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("501", "wc-admin_import_orders", "complete", "2024-05-08 14:17:51", "2024-05-08 14:17:51", "10", "[4787]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177871;}", "9", "1", "2024-05-08 16:07:36", "2024-05-08 16:07:36", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("504", "wcpay_add_fee_breakdown_to_order_notes", "complete", "2024-05-08 14:17:51", "2024-05-08 14:17:51", "10", "{\"order_id\":4787,\"intent_id\":\"pi_3PEBJZFvO9wzZIIA02rsqZRN\",\"is_test_mode\":false}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177871;}", "8", "1", "2024-05-08 16:07:38", "2024-05-08 16:07:38", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("506", "wcpay_track_new_order", "canceled", "2024-05-08 14:18:05", "2024-05-08 14:18:05", "10", "{\"order_id\":4787}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715177885;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715177885;}", "8", "0", "2024-05-08 16:07:36", "2024-05-08 16:07:36", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("507", "wc-admin_import_orders", "complete", "2024-05-08 16:07:43", "2024-05-08 16:07:43", "10", "[4787]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715184463;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715184463;}", "9", "1", "2024-05-08 16:18:13", "2024-05-08 16:18:13", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("508", "wcpay_track_new_order", "complete", "2024-05-08 16:07:43", "2024-05-08 16:07:43", "10", "{\"order_id\":4787}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715184463;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715184463;}", "8", "1", "2024-05-08 16:18:51", "2024-05-08 16:18:51", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("509", "wc-admin_import_orders", "complete", "2024-05-08 16:18:55", "2024-05-08 16:18:55", "10", "[4787]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715185135;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715185135;}", "9", "1", "2024-05-08 16:19:12", "2024-05-08 16:19:12", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("510", "wcpay_track_update_order", "complete", "2024-05-08 16:18:55", "2024-05-08 16:18:55", "10", "{\"order_id\":4787}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715185135;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715185135;}", "8", "1", "2024-05-08 16:19:25", "2024-05-08 16:19:25", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("511", "woocommerce_update_marketplace_suggestions", "complete", "2024-05-08 16:24:36", "2024-05-08 16:24:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715185476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715185476;}", "2", "1", "2024-05-08 16:26:02", "2024-05-08 16:26:02", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("512", "wc-admin_import_orders", "complete", "2024-05-08 16:35:00", "2024-05-08 16:35:00", "10", "[4788]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715186100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715186100;}", "9", "1", "2024-05-08 16:35:50", "2024-05-08 16:35:50", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("518", "wcpay_add_fee_breakdown_to_order_notes", "complete", "2024-05-08 16:35:46", "2024-05-08 16:35:46", "10", "{\"order_id\":4788,\"intent_id\":\"pi_3PEDSJFvO9wzZIIA1x0rLrir\",\"is_test_mode\":false}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715186146;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715186146;}", "8", "1", "2024-05-08 16:35:52", "2024-05-08 16:35:52", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("524", "wc-admin_import_orders", "complete", "2024-05-08 16:35:57", "2024-05-08 16:35:57", "10", "[4788]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715186157;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715186157;}", "9", "1", "2024-05-08 16:36:01", "2024-05-08 16:36:01", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("525", "wcpay_track_new_order", "complete", "2024-05-08 16:35:57", "2024-05-08 16:35:57", "10", "{\"order_id\":4788}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715186157;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715186157;}", "8", "1", "2024-05-08 16:36:22", "2024-05-08 16:36:22", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("526", "wc-admin_import_orders", "complete", "2024-05-08 16:36:27", "2024-05-08 16:36:27", "10", "[4788]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715186187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715186187;}", "9", "1", "2024-05-08 16:36:32", "2024-05-08 16:36:32", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("527", "wcpay_track_update_order", "complete", "2024-05-08 16:36:27", "2024-05-08 16:36:27", "10", "{\"order_id\":4788}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715186187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715186187;}", "8", "1", "2024-05-08 16:36:33", "2024-05-08 16:36:33", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("528", "wcpay_webhook_fetch_events", "complete", "2024-05-08 17:35:23", "2024-05-08 17:35:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715189723;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715189723;}", "8", "1", "2024-05-08 17:36:07", "2024-05-08 17:36:07", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("529", "wc-admin_import_orders", "complete", "2024-05-08 17:36:00", "2024-05-08 17:36:00", "10", "[4788]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715189760;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715189760;}", "9", "1", "2024-05-08 17:36:07", "2024-05-08 17:36:07", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("530", "wcpay_track_update_order", "complete", "2024-05-08 17:36:00", "2024-05-08 17:36:00", "10", "{\"order_id\":4788}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1715189760;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1715189760;}", "8", "1", "2024-05-08 17:36:08", "2024-05-08 17:36:08", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("531", "cartflows_update_knowledge_base_data", "complete", "2024-05-09 10:13:47", "2024-05-09 10:13:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715249627;s:18:\"\0*\0first_timestamp\";i:1715249627;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715249627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2024-05-09 10:13:51", "2024-05-09 10:13:51", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("532", "woocommerce_marketplace_fetch_promotions", "complete", "2024-05-09 22:13:51", "2024-05-09 22:13:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715292831;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715292831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "1", "2024-05-09 23:14:39", "2024-05-09 23:14:39", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("533", "cartflows_update_knowledge_base_data", "pending", "2024-05-16 10:13:51", "2024-05-16 10:13:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715854431;s:18:\"\0*\0first_timestamp\";i:1715249627;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715854431;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("534", "woocommerce_cleanup_draft_orders", "pending", "2024-05-10 14:06:59", "2024-05-10 14:06:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715350019;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715350019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("535", "woocommerce_cleanup_draft_orders", "pending", "2024-05-10 14:07:15", "2024-05-10 14:07:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715350035;s:18:\"\0*\0first_timestamp\";i:1705450183;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715350035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("536", "wc_gla_cron_daily_notes", "pending", "2024-05-10 14:07:41", "2024-05-10 14:07:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715350061;s:18:\"\0*\0first_timestamp\";i:1706817547;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715350061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `ethr_actionscheduler_actions` VALUES("537", "woocommerce_marketplace_fetch_promotions", "pending", "2024-05-10 11:14:39", "2024-05-10 11:14:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1715339679;s:18:\"\0*\0first_timestamp\";i:1713745675;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1715339679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: ethr_actionscheduler_groups */
INSERT INTO `ethr_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `ethr_actionscheduler_groups` VALUES("2", "");
INSERT INTO `ethr_actionscheduler_groups` VALUES("3", "");
INSERT INTO `ethr_actionscheduler_groups` VALUES("4", "wc_update_product_lookup_tables");
INSERT INTO `ethr_actionscheduler_groups` VALUES("5", "woocommerce-db-updates");
INSERT INTO `ethr_actionscheduler_groups` VALUES("6", "woocommerce-remote-inbox-engine");
INSERT INTO `ethr_actionscheduler_groups` VALUES("7", "gla");
INSERT INTO `ethr_actionscheduler_groups` VALUES("8", "woocommerce_payments");
INSERT INTO `ethr_actionscheduler_groups` VALUES("9", "wc-admin-data");

/* INSERT TABLE DATA: ethr_actionscheduler_logs */
INSERT INTO `ethr_actionscheduler_logs` VALUES("13", "19", "action created", "2024-01-17 00:09:55", "2024-01-17 00:09:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("17", "21", "action created", "2024-01-17 00:10:46", "2024-01-17 00:10:46");
INSERT INTO `ethr_actionscheduler_logs` VALUES("22", "22", "action created", "2024-01-17 00:11:18", "2024-01-17 00:11:18");
INSERT INTO `ethr_actionscheduler_logs` VALUES("35", "22", "action started via Async Request", "2024-01-17 00:11:49", "2024-01-17 00:11:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("36", "22", "action failed via Async Request: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2024-01-17 00:11:49", "2024-01-17 00:11:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("85", "19", "action started via WP Cron", "2024-01-22 17:27:54", "2024-01-22 17:27:54");
INSERT INTO `ethr_actionscheduler_logs` VALUES("86", "19", "action failed via WP Cron: Call to undefined function PHPMailer\\PHPMailer\\mail()", "2024-01-22 17:27:54", "2024-01-22 17:27:54");
INSERT INTO `ethr_actionscheduler_logs` VALUES("87", "43", "action created", "2024-01-22 17:27:54", "2024-01-22 17:27:54");
INSERT INTO `ethr_actionscheduler_logs` VALUES("100", "21", "action started via WP Cron", "2024-01-24 03:02:12", "2024-01-24 03:02:12");
INSERT INTO `ethr_actionscheduler_logs` VALUES("101", "21", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-01-24 03:02:12", "2024-01-24 03:02:12");
INSERT INTO `ethr_actionscheduler_logs` VALUES("102", "48", "action created", "2024-01-24 03:02:12", "2024-01-24 03:02:12");
INSERT INTO `ethr_actionscheduler_logs` VALUES("121", "43", "action started via WP Cron", "2024-01-30 05:21:39", "2024-01-30 05:21:39");
INSERT INTO `ethr_actionscheduler_logs` VALUES("122", "43", "action failed via WP Cron: Call to undefined function PHPMailer\\PHPMailer\\mail()", "2024-01-30 05:21:40", "2024-01-30 05:21:40");
INSERT INTO `ethr_actionscheduler_logs` VALUES("136", "48", "action started via WP Cron", "2024-01-31 06:51:03", "2024-01-31 06:51:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("137", "48", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-01-31 06:51:03", "2024-01-31 06:51:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("138", "60", "action created", "2024-01-31 06:51:03", "2024-01-31 06:51:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("464", "60", "action started via WP Cron", "2024-02-07 09:45:09", "2024-02-07 09:45:09");
INSERT INTO `ethr_actionscheduler_logs` VALUES("465", "60", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-02-07 09:45:09", "2024-02-07 09:45:09");
INSERT INTO `ethr_actionscheduler_logs` VALUES("466", "170", "action created", "2024-02-07 09:45:10", "2024-02-07 09:45:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("509", "170", "action started via WP Cron", "2024-02-15 09:27:23", "2024-02-15 09:27:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("510", "170", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-02-15 09:27:23", "2024-02-15 09:27:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("511", "185", "action created", "2024-02-15 09:27:23", "2024-02-15 09:27:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("554", "185", "action started via WP Cron", "2024-02-22 18:13:21", "2024-02-22 18:13:21");
INSERT INTO `ethr_actionscheduler_logs` VALUES("555", "185", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-02-22 18:13:21", "2024-02-22 18:13:21");
INSERT INTO `ethr_actionscheduler_logs` VALUES("556", "185", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-02-22 18:13:21", "2024-02-22 18:13:21");
INSERT INTO `ethr_actionscheduler_logs` VALUES("584", "209", "action created", "2024-03-01 01:49:39", "2024-03-01 01:49:39");
INSERT INTO `ethr_actionscheduler_logs` VALUES("630", "209", "action started via WP Cron", "2024-03-10 07:43:52", "2024-03-10 07:43:52");
INSERT INTO `ethr_actionscheduler_logs` VALUES("631", "209", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-03-10 07:43:52", "2024-03-10 07:43:52");
INSERT INTO `ethr_actionscheduler_logs` VALUES("632", "209", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-03-10 07:43:52", "2024-03-10 07:43:52");
INSERT INTO `ethr_actionscheduler_logs` VALUES("645", "229", "action created", "2024-03-12 12:14:32", "2024-03-12 12:14:32");
INSERT INTO `ethr_actionscheduler_logs` VALUES("697", "229", "action started via WP Cron", "2024-03-19 13:12:33", "2024-03-19 13:12:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("698", "229", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-03-19 13:12:33", "2024-03-19 13:12:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("699", "229", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-03-19 13:12:33", "2024-03-19 13:12:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("709", "250", "action created", "2024-03-21 15:29:35", "2024-03-21 15:29:35");
INSERT INTO `ethr_actionscheduler_logs` VALUES("719", "250", "action started via WP Cron", "2024-03-21 15:29:38", "2024-03-21 15:29:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("720", "250", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-03-21 15:29:38", "2024-03-21 15:29:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("721", "250", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-03-21 15:29:38", "2024-03-21 15:29:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("722", "254", "action created", "2024-03-22 01:05:20", "2024-03-22 01:05:20");
INSERT INTO `ethr_actionscheduler_logs` VALUES("723", "254", "action started via WP Cron", "2024-03-22 01:05:50", "2024-03-22 01:05:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("724", "254", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-03-22 01:05:50", "2024-03-22 01:05:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("725", "254", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-03-22 01:05:50", "2024-03-22 01:05:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("726", "255", "action created", "2024-03-22 01:06:43", "2024-03-22 01:06:43");
INSERT INTO `ethr_actionscheduler_logs` VALUES("727", "255", "action started via WP Cron", "2024-03-22 08:06:31", "2024-03-22 08:06:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("728", "255", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-03-22 08:06:31", "2024-03-22 08:06:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("729", "255", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-03-22 08:06:31", "2024-03-22 08:06:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("766", "268", "action created", "2024-03-26 11:01:38", "2024-03-26 11:01:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("895", "311", "action created", "2024-04-01 10:51:47", "2024-04-01 10:51:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("905", "268", "action started via WP Cron", "2024-04-02 12:26:24", "2024-04-02 12:26:24");
INSERT INTO `ethr_actionscheduler_logs` VALUES("906", "268", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-04-02 12:26:24", "2024-04-02 12:26:24");
INSERT INTO `ethr_actionscheduler_logs` VALUES("907", "268", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-04-02 12:26:24", "2024-04-02 12:26:24");
INSERT INTO `ethr_actionscheduler_logs` VALUES("911", "316", "action created", "2024-04-02 23:46:59", "2024-04-02 23:46:59");
INSERT INTO `ethr_actionscheduler_logs` VALUES("939", "326", "action created", "2024-04-04 14:24:15", "2024-04-04 14:24:15");
INSERT INTO `ethr_actionscheduler_logs` VALUES("940", "326", "action started via WP Cron", "2024-04-04 14:26:23", "2024-04-04 14:26:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("941", "326", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-04-04 14:26:23", "2024-04-04 14:26:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("971", "336", "action created", "2024-04-08 02:33:41", "2024-04-08 02:33:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("974", "337", "action created", "2024-04-08 02:33:41", "2024-04-08 02:33:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("977", "338", "action created", "2024-04-08 19:46:07", "2024-04-08 19:46:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("980", "339", "action created", "2024-04-08 19:46:07", "2024-04-08 19:46:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("983", "340", "action created", "2024-04-08 19:46:07", "2024-04-08 19:46:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("984", "338", "action started via WP Cron", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("985", "338", "action complete via WP Cron", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("986", "341", "action created", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("987", "339", "action started via WP Cron", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("988", "339", "action complete via WP Cron", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("989", "342", "action created", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("990", "340", "action started via WP Cron", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("991", "340", "action complete via WP Cron", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("992", "343", "action created", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("993", "316", "action started via WP Cron", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("994", "316", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("995", "316", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-04-10 03:10:50", "2024-04-10 03:10:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("996", "344", "action created", "2024-04-10 04:50:20", "2024-04-10 04:50:20");
INSERT INTO `ethr_actionscheduler_logs` VALUES("997", "344", "action started via WP Cron", "2024-04-10 04:50:22", "2024-04-10 04:50:22");
INSERT INTO `ethr_actionscheduler_logs` VALUES("998", "344", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-04-10 04:50:22", "2024-04-10 04:50:22");
INSERT INTO `ethr_actionscheduler_logs` VALUES("999", "344", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-04-10 04:50:22", "2024-04-10 04:50:22");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1000", "345", "action created", "2024-04-10 04:50:25", "2024-04-10 04:50:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1001", "345", "action started via Async Request", "2024-04-10 04:50:25", "2024-04-10 04:50:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1002", "345", "action complete via Async Request", "2024-04-10 04:50:25", "2024-04-10 04:50:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1003", "346", "action created", "2024-04-10 04:50:25", "2024-04-10 04:50:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1004", "341", "action started via WP Cron", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1005", "341", "action complete via WP Cron", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1006", "347", "action created", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1007", "342", "action started via WP Cron", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1008", "342", "action complete via WP Cron", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1009", "348", "action created", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1010", "343", "action started via WP Cron", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1011", "343", "action complete via WP Cron", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1012", "349", "action created", "2024-04-11 03:25:45", "2024-04-11 03:25:45");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1013", "347", "action started via WP Cron", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1014", "347", "action complete via WP Cron", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1015", "350", "action created", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1016", "348", "action started via WP Cron", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1017", "348", "action complete via WP Cron", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1018", "351", "action created", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1019", "349", "action started via WP Cron", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1020", "349", "action complete via WP Cron", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1021", "352", "action created", "2024-04-12 04:01:08", "2024-04-12 04:01:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1022", "350", "action started via WP Cron", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1023", "350", "action complete via WP Cron", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1024", "353", "action created", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1025", "351", "action started via WP Cron", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1026", "351", "action complete via WP Cron", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1027", "354", "action created", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1028", "352", "action started via WP Cron", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1029", "352", "action complete via WP Cron", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1030", "355", "action created", "2024-04-13 11:39:58", "2024-04-13 11:39:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1031", "356", "action created", "2024-04-13 11:58:21", "2024-04-13 11:58:21");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1032", "356", "action started via WP Cron", "2024-04-13 11:58:49", "2024-04-13 11:58:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1033", "356", "action complete via WP Cron", "2024-04-13 11:58:49", "2024-04-13 11:58:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1034", "353", "action started via WP Cron", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1035", "353", "action complete via WP Cron", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1036", "357", "action created", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1037", "354", "action started via WP Cron", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1038", "354", "action complete via WP Cron", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1039", "358", "action created", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1040", "355", "action started via WP Cron", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1041", "355", "action complete via WP Cron", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1042", "359", "action created", "2024-04-14 12:27:50", "2024-04-14 12:27:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1043", "336", "action started via WP Cron", "2024-04-15 09:43:27", "2024-04-15 09:43:27");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1044", "336", "action complete via WP Cron", "2024-04-15 09:43:27", "2024-04-15 09:43:27");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1045", "360", "action created", "2024-04-15 09:43:27", "2024-04-15 09:43:27");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1046", "337", "action started via WP Cron", "2024-04-15 09:43:27", "2024-04-15 09:43:27");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1047", "337", "action complete via WP Cron", "2024-04-15 09:43:27", "2024-04-15 09:43:27");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1048", "361", "action created", "2024-04-15 09:43:27", "2024-04-15 09:43:27");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1049", "357", "action started via WP Cron", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1050", "357", "action complete via WP Cron", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1051", "362", "action created", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1052", "358", "action started via WP Cron", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1053", "358", "action complete via WP Cron", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1054", "363", "action created", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1055", "359", "action started via WP Cron", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1056", "359", "action complete via WP Cron", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1057", "364", "action created", "2024-04-15 12:56:58", "2024-04-15 12:56:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1058", "362", "action started via WP Cron", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1059", "362", "action complete via WP Cron", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1060", "365", "action created", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1061", "363", "action started via WP Cron", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1062", "363", "action complete via WP Cron", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1063", "366", "action created", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1064", "364", "action started via WP Cron", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1065", "364", "action complete via WP Cron", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1066", "367", "action created", "2024-04-16 15:15:44", "2024-04-16 15:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1067", "346", "action started via WP Cron", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1068", "346", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1069", "346", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1070", "365", "action started via WP Cron", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1071", "365", "action complete via WP Cron", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1072", "368", "action created", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1073", "366", "action started via WP Cron", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1074", "366", "action complete via WP Cron", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1075", "369", "action created", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1076", "367", "action started via WP Cron", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1077", "367", "action complete via WP Cron", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1078", "370", "action created", "2024-04-17 22:25:23", "2024-04-17 22:25:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1079", "371", "action created", "2024-04-17 22:25:29", "2024-04-17 22:25:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1080", "371", "action started via Async Request", "2024-04-17 22:25:36", "2024-04-17 22:25:36");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1081", "371", "action complete via Async Request", "2024-04-17 22:25:36", "2024-04-17 22:25:36");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1082", "372", "action created", "2024-04-17 22:25:36", "2024-04-17 22:25:36");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1083", "368", "action started via WP Cron", "2024-04-19 09:55:01", "2024-04-19 09:55:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1084", "368", "action complete via WP Cron", "2024-04-19 09:55:01", "2024-04-19 09:55:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1085", "373", "action created", "2024-04-19 09:55:01", "2024-04-19 09:55:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1086", "369", "action started via WP Cron", "2024-04-19 09:55:02", "2024-04-19 09:55:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1087", "369", "action complete via WP Cron", "2024-04-19 09:55:02", "2024-04-19 09:55:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1088", "374", "action created", "2024-04-19 09:55:02", "2024-04-19 09:55:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1089", "370", "action started via WP Cron", "2024-04-19 09:55:02", "2024-04-19 09:55:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1090", "370", "action complete via WP Cron", "2024-04-19 09:55:02", "2024-04-19 09:55:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1091", "375", "action created", "2024-04-19 09:55:02", "2024-04-19 09:55:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1092", "373", "action started via WP Cron", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1093", "373", "action complete via WP Cron", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1094", "376", "action created", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1095", "374", "action started via WP Cron", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1096", "374", "action complete via WP Cron", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1097", "377", "action created", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1098", "375", "action started via WP Cron", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1099", "375", "action complete via WP Cron", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1100", "378", "action created", "2024-04-20 20:23:25", "2024-04-20 20:23:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1101", "376", "action started via WP Cron", "2024-04-21 23:51:54", "2024-04-21 23:51:54");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1102", "376", "action complete via WP Cron", "2024-04-21 23:51:54", "2024-04-21 23:51:54");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1103", "379", "action created", "2024-04-21 23:51:55", "2024-04-21 23:51:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1104", "377", "action started via WP Cron", "2024-04-21 23:51:55", "2024-04-21 23:51:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1105", "377", "action complete via WP Cron", "2024-04-21 23:51:55", "2024-04-21 23:51:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1106", "380", "action created", "2024-04-21 23:51:55", "2024-04-21 23:51:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1107", "378", "action started via WP Cron", "2024-04-21 23:51:55", "2024-04-21 23:51:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1108", "378", "action complete via WP Cron", "2024-04-21 23:51:55", "2024-04-21 23:51:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1109", "381", "action created", "2024-04-21 23:51:55", "2024-04-21 23:51:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1110", "382", "action created", "2024-04-22 00:27:44", "2024-04-22 00:27:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1111", "383", "action created", "2024-04-22 00:27:44", "2024-04-22 00:27:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1112", "384", "action created", "2024-04-22 00:27:55", "2024-04-22 00:27:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1113", "383", "action started via WP Cron", "2024-04-22 00:28:03", "2024-04-22 00:28:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1114", "383", "action complete via WP Cron", "2024-04-22 00:28:04", "2024-04-22 00:28:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1115", "382", "action started via WP Cron", "2024-04-22 00:28:04", "2024-04-22 00:28:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1116", "385", "action created", "2024-04-22 00:28:04", "2024-04-22 00:28:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1117", "382", "action complete via WP Cron", "2024-04-22 00:28:04", "2024-04-22 00:28:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1118", "384", "action started via WP Cron", "2024-04-22 00:28:04", "2024-04-22 00:28:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1119", "384", "action complete via WP Cron", "2024-04-22 00:28:05", "2024-04-22 00:28:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1120", "386", "action created", "2024-04-22 00:28:05", "2024-04-22 00:28:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1121", "385", "action started via WP Cron", "2024-04-22 00:28:05", "2024-04-22 00:28:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1122", "385", "action complete via WP Cron", "2024-04-22 00:28:05", "2024-04-22 00:28:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1123", "360", "action started via WP Cron", "2024-04-22 11:13:55", "2024-04-22 11:13:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1124", "360", "action complete via WP Cron", "2024-04-22 11:13:55", "2024-04-22 11:13:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1125", "387", "action created", "2024-04-22 11:13:55", "2024-04-22 11:13:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1126", "388", "action created", "2024-04-22 11:13:55", "2024-04-22 11:13:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1127", "361", "action started via WP Cron", "2024-04-22 11:13:55", "2024-04-22 11:13:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1128", "361", "action complete via WP Cron", "2024-04-22 11:13:55", "2024-04-22 11:13:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1129", "389", "action created", "2024-04-22 11:13:55", "2024-04-22 11:13:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1130", "390", "action created", "2024-04-22 11:13:55", "2024-04-22 11:13:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1131", "386", "action started via WP Cron", "2024-04-22 12:31:37", "2024-04-22 12:31:37");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1132", "386", "action complete via WP Cron", "2024-04-22 12:31:38", "2024-04-22 12:31:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1133", "391", "action created", "2024-04-22 12:31:38", "2024-04-22 12:31:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1134", "379", "action started via WP Cron", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1135", "379", "action complete via WP Cron", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1136", "392", "action created", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1137", "380", "action started via WP Cron", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1138", "380", "action complete via WP Cron", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1139", "393", "action created", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1140", "381", "action started via WP Cron", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1141", "381", "action complete via WP Cron", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1142", "394", "action created", "2024-04-23 00:26:10", "2024-04-23 00:26:10");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1143", "391", "action started via WP Cron", "2024-04-23 00:33:23", "2024-04-23 00:33:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1144", "391", "action complete via WP Cron", "2024-04-23 00:33:24", "2024-04-23 00:33:24");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1145", "395", "action created", "2024-04-23 00:33:24", "2024-04-23 00:33:24");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1146", "395", "action started via WP Cron", "2024-04-23 12:58:58", "2024-04-23 12:58:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1147", "395", "action complete via WP Cron", "2024-04-23 12:58:59", "2024-04-23 12:58:59");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1148", "396", "action created", "2024-04-23 12:58:59", "2024-04-23 12:58:59");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1149", "397", "action created", "2024-04-23 13:12:38", "2024-04-23 13:12:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1150", "397", "action started via WP Cron", "2024-04-23 13:12:58", "2024-04-23 13:12:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1151", "397", "action complete via WP Cron", "2024-04-23 13:12:58", "2024-04-23 13:12:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1152", "392", "action started via WP Cron", "2024-04-24 00:34:02", "2024-04-24 00:34:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1153", "392", "action complete via WP Cron", "2024-04-24 00:34:03", "2024-04-24 00:34:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1154", "398", "action created", "2024-04-24 00:34:03", "2024-04-24 00:34:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1155", "393", "action started via WP Cron", "2024-04-24 00:34:03", "2024-04-24 00:34:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1156", "393", "action complete via WP Cron", "2024-04-24 00:34:03", "2024-04-24 00:34:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1157", "399", "action created", "2024-04-24 00:34:03", "2024-04-24 00:34:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1158", "394", "action started via WP Cron", "2024-04-24 00:34:03", "2024-04-24 00:34:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1159", "394", "action complete via WP Cron", "2024-04-24 00:34:03", "2024-04-24 00:34:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1160", "400", "action created", "2024-04-24 00:34:03", "2024-04-24 00:34:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1161", "396", "action started via WP Cron", "2024-04-24 01:08:48", "2024-04-24 01:08:48");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1162", "396", "action complete via WP Cron", "2024-04-24 01:08:48", "2024-04-24 01:08:48");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1163", "401", "action created", "2024-04-24 01:08:48", "2024-04-24 01:08:48");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1164", "401", "action started via WP Cron", "2024-04-24 13:55:27", "2024-04-24 13:55:27");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1165", "401", "action complete via WP Cron", "2024-04-24 13:55:28", "2024-04-24 13:55:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1166", "402", "action created", "2024-04-24 13:55:28", "2024-04-24 13:55:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1167", "372", "action started via WP Cron", "2024-04-24 22:26:06", "2024-04-24 22:26:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1168", "372", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-04-24 22:26:06", "2024-04-24 22:26:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1169", "372", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-04-24 22:26:06", "2024-04-24 22:26:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1170", "403", "action created", "2024-04-24 22:26:06", "2024-04-24 22:26:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1171", "403", "action started via Async Request", "2024-04-24 22:26:06", "2024-04-24 22:26:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1172", "403", "action complete via Async Request", "2024-04-24 22:26:06", "2024-04-24 22:26:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1173", "404", "action created", "2024-04-24 22:26:06", "2024-04-24 22:26:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1174", "398", "action started via WP Cron", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1175", "398", "action complete via WP Cron", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1176", "405", "action created", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1177", "399", "action started via WP Cron", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1178", "399", "action complete via WP Cron", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1179", "406", "action created", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1180", "400", "action started via WP Cron", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1181", "400", "action complete via WP Cron", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1182", "407", "action created", "2024-04-25 00:34:41", "2024-04-25 00:34:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1183", "402", "action started via WP Cron", "2024-04-25 02:18:57", "2024-04-25 02:18:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1184", "402", "action complete via WP Cron", "2024-04-25 02:18:58", "2024-04-25 02:18:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1185", "408", "action created", "2024-04-25 02:18:58", "2024-04-25 02:18:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1186", "408", "action started via WP Cron", "2024-04-25 16:05:56", "2024-04-25 16:05:56");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1187", "408", "action complete via WP Cron", "2024-04-25 16:05:57", "2024-04-25 16:05:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1188", "409", "action created", "2024-04-25 16:05:57", "2024-04-25 16:05:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1189", "405", "action started via WP Cron", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1190", "405", "action complete via WP Cron", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1191", "410", "action created", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1192", "406", "action started via WP Cron", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1193", "406", "action complete via WP Cron", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1194", "411", "action created", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1195", "407", "action started via WP Cron", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1196", "407", "action complete via WP Cron", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1197", "412", "action created", "2024-04-26 00:35:01", "2024-04-26 00:35:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1198", "409", "action started via WP Cron", "2024-04-26 04:31:40", "2024-04-26 04:31:40");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1199", "409", "action complete via WP Cron", "2024-04-26 04:31:41", "2024-04-26 04:31:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1200", "413", "action created", "2024-04-26 04:31:41", "2024-04-26 04:31:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1201", "413", "action started via WP Cron", "2024-04-28 13:46:18", "2024-04-28 13:46:18");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1202", "413", "action complete via WP Cron", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1203", "414", "action created", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1204", "410", "action started via WP Cron", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1205", "410", "action complete via WP Cron", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1206", "415", "action created", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1207", "411", "action started via WP Cron", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1208", "411", "action complete via WP Cron", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1209", "416", "action created", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1210", "412", "action started via WP Cron", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1211", "412", "action complete via WP Cron", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1212", "417", "action created", "2024-04-28 13:46:19", "2024-04-28 13:46:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1213", "414", "action started via WP Cron", "2024-04-29 05:22:28", "2024-04-29 05:22:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1214", "414", "action complete via WP Cron", "2024-04-29 05:22:29", "2024-04-29 05:22:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1215", "418", "action created", "2024-04-29 05:22:29", "2024-04-29 05:22:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1216", "388", "action started via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1217", "388", "action complete via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1218", "419", "action created", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1219", "390", "action started via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1220", "390", "action complete via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1221", "420", "action created", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1222", "415", "action started via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1223", "415", "action complete via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1224", "421", "action created", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1225", "416", "action started via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1226", "416", "action complete via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1227", "422", "action created", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1228", "417", "action started via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1229", "417", "action complete via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1230", "423", "action created", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1231", "387", "action started via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1232", "387", "action complete via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1233", "424", "action created", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1234", "389", "action started via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1235", "389", "action complete via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1236", "425", "action created", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1237", "418", "action started via WP Cron", "2024-04-30 05:27:04", "2024-04-30 05:27:04");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1238", "418", "action complete via WP Cron", "2024-04-30 05:27:05", "2024-04-30 05:27:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1239", "426", "action created", "2024-04-30 05:27:05", "2024-04-30 05:27:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1240", "426", "action started via WP Cron", "2024-04-30 18:16:50", "2024-04-30 18:16:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1241", "426", "action complete via WP Cron", "2024-04-30 18:16:51", "2024-04-30 18:16:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1242", "427", "action created", "2024-04-30 18:16:51", "2024-04-30 18:16:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1243", "421", "action started via WP Cron", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1244", "421", "action complete via WP Cron", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1245", "428", "action created", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1246", "422", "action started via WP Cron", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1247", "422", "action complete via WP Cron", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1248", "429", "action created", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1249", "423", "action started via WP Cron", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1250", "423", "action complete via WP Cron", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1251", "430", "action created", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1252", "427", "action started via WP Cron", "2024-05-01 15:47:01", "2024-05-01 15:47:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1253", "427", "action complete via WP Cron", "2024-05-01 15:47:02", "2024-05-01 15:47:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1254", "431", "action created", "2024-05-01 15:47:02", "2024-05-01 15:47:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1255", "311", "action started via WP Cron", "2024-05-01 15:47:02", "2024-05-01 15:47:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1256", "311", "action complete via WP Cron", "2024-05-01 15:47:02", "2024-05-01 15:47:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1257", "432", "action created", "2024-05-01 15:47:02", "2024-05-01 15:47:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1258", "433", "action created", "2024-05-01 15:54:35", "2024-05-01 15:54:35");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1259", "433", "action started via Async Request", "2024-05-01 15:54:54", "2024-05-01 15:54:54");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1260", "433", "action complete via Async Request", "2024-05-01 15:54:54", "2024-05-01 15:54:54");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1261", "404", "action started via WP Cron", "2024-05-01 23:20:58", "2024-05-01 23:20:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1262", "404", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-05-01 23:20:58", "2024-05-01 23:20:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1263", "404", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-05-01 23:20:58", "2024-05-01 23:20:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1264", "434", "action created", "2024-05-01 23:23:26", "2024-05-01 23:23:26");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1265", "434", "action started via Async Request", "2024-05-01 23:23:29", "2024-05-01 23:23:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1266", "434", "action complete via Async Request", "2024-05-01 23:23:30", "2024-05-01 23:23:30");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1267", "435", "action created", "2024-05-01 23:23:30", "2024-05-01 23:23:30");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1268", "436", "action created", "2024-05-01 23:26:02", "2024-05-01 23:26:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1269", "437", "action created", "2024-05-01 23:26:02", "2024-05-01 23:26:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1270", "437", "action started via Async Request", "2024-05-01 23:28:28", "2024-05-01 23:28:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1271", "437", "action complete via Async Request", "2024-05-01 23:28:28", "2024-05-01 23:28:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1272", "436", "action started via Async Request", "2024-05-01 23:28:28", "2024-05-01 23:28:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1273", "438", "action created", "2024-05-01 23:28:28", "2024-05-01 23:28:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1274", "436", "action complete via Async Request", "2024-05-01 23:28:28", "2024-05-01 23:28:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1275", "438", "action started via WP Cron", "2024-05-01 23:29:30", "2024-05-01 23:29:30");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1276", "438", "action complete via WP Cron", "2024-05-01 23:29:30", "2024-05-01 23:29:30");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1277", "431", "action started via WP Cron", "2024-05-02 06:47:07", "2024-05-02 06:47:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1278", "431", "action complete via WP Cron", "2024-05-02 06:47:08", "2024-05-02 06:47:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1279", "439", "action created", "2024-05-02 06:47:08", "2024-05-02 06:47:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1280", "428", "action started via WP Cron", "2024-05-02 16:10:46", "2024-05-02 16:10:46");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1281", "428", "action complete via WP Cron", "2024-05-02 16:10:46", "2024-05-02 16:10:46");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1282", "440", "action created", "2024-05-02 16:10:47", "2024-05-02 16:10:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1283", "429", "action started via WP Cron", "2024-05-02 16:10:47", "2024-05-02 16:10:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1284", "429", "action complete via WP Cron", "2024-05-02 16:10:47", "2024-05-02 16:10:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1285", "441", "action created", "2024-05-02 16:10:47", "2024-05-02 16:10:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1286", "430", "action started via WP Cron", "2024-05-02 16:10:47", "2024-05-02 16:10:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1287", "430", "action complete via WP Cron", "2024-05-02 16:10:47", "2024-05-02 16:10:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1288", "442", "action created", "2024-05-02 16:10:47", "2024-05-02 16:10:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1289", "439", "action started via WP Cron", "2024-05-02 19:08:05", "2024-05-02 19:08:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1290", "439", "action complete via WP Cron", "2024-05-02 19:08:05", "2024-05-02 19:08:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1291", "443", "action created", "2024-05-02 19:08:05", "2024-05-02 19:08:05");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1292", "443", "action started via WP Cron", "2024-05-03 12:06:55", "2024-05-03 12:06:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1293", "443", "action complete via WP Cron", "2024-05-03 12:06:56", "2024-05-03 12:06:56");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1294", "444", "action created", "2024-05-03 12:06:56", "2024-05-03 12:06:56");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1295", "440", "action started via WP Cron", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1296", "440", "action complete via WP Cron", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1297", "445", "action created", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1298", "441", "action started via WP Cron", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1299", "441", "action complete via WP Cron", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1300", "446", "action created", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1301", "442", "action started via WP Cron", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1302", "442", "action complete via WP Cron", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1303", "447", "action created", "2024-05-03 21:45:06", "2024-05-03 21:45:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1304", "448", "action created", "2024-05-03 22:20:50", "2024-05-03 22:20:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1305", "448", "action started via WP Cron", "2024-05-03 22:23:03", "2024-05-03 22:23:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1306", "448", "action complete via WP Cron", "2024-05-03 22:23:03", "2024-05-03 22:23:03");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1307", "449", "action created", "2024-05-03 22:23:06", "2024-05-03 22:23:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1308", "449", "action started via WP Cron", "2024-05-03 22:25:08", "2024-05-03 22:25:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1309", "449", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-05-03 22:25:08", "2024-05-03 22:25:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1310", "450", "action created", "2024-05-03 23:33:17", "2024-05-03 23:33:17");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1311", "450", "action started via WP Cron", "2024-05-03 23:34:23", "2024-05-03 23:34:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1312", "450", "action complete via WP Cron", "2024-05-03 23:34:23", "2024-05-03 23:34:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1313", "451", "action created", "2024-05-03 23:34:24", "2024-05-03 23:34:24");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1314", "451", "action started via WP Cron", "2024-05-03 23:35:50", "2024-05-03 23:35:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1315", "451", "action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-05-03 23:35:50", "2024-05-03 23:35:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1316", "444", "action started via WP Cron", "2024-05-04 00:06:57", "2024-05-04 00:06:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1317", "444", "action complete via WP Cron", "2024-05-04 00:06:58", "2024-05-04 00:06:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1318", "452", "action created", "2024-05-04 00:06:58", "2024-05-04 00:06:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1319", "452", "action started via WP Cron", "2024-05-04 16:51:28", "2024-05-04 16:51:28");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1320", "452", "action complete via WP Cron", "2024-05-04 16:51:29", "2024-05-04 16:51:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1321", "453", "action created", "2024-05-04 16:51:29", "2024-05-04 16:51:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1322", "445", "action started via WP Cron", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1323", "445", "action complete via WP Cron", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1324", "454", "action created", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1325", "446", "action started via WP Cron", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1326", "446", "action complete via WP Cron", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1327", "455", "action created", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1328", "447", "action started via WP Cron", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1329", "447", "action complete via WP Cron", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1330", "456", "action created", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1331", "453", "action started via WP Cron", "2024-05-05 06:31:57", "2024-05-05 06:31:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1332", "453", "action complete via WP Cron", "2024-05-05 06:31:58", "2024-05-05 06:31:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1333", "457", "action created", "2024-05-05 06:31:58", "2024-05-05 06:31:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1334", "457", "action started via WP Cron", "2024-05-06 00:00:58", "2024-05-06 00:00:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1335", "457", "action complete via WP Cron", "2024-05-06 00:00:59", "2024-05-06 00:00:59");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1336", "458", "action created", "2024-05-06 00:00:59", "2024-05-06 00:00:59");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1337", "454", "action started via WP Cron", "2024-05-06 13:39:06", "2024-05-06 13:39:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1338", "454", "action complete via WP Cron", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1339", "459", "action created", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1340", "455", "action started via WP Cron", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1341", "455", "action complete via WP Cron", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1342", "460", "action created", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1343", "456", "action started via WP Cron", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1344", "456", "action complete via WP Cron", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1345", "461", "action created", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1346", "458", "action started via WP Cron", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1347", "458", "action complete via WP Cron", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1348", "462", "action created", "2024-05-06 13:39:07", "2024-05-06 13:39:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1349", "463", "action created", "2024-05-06 19:21:34", "2024-05-06 19:21:34");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1350", "463", "action started via WP Cron", "2024-05-06 19:22:50", "2024-05-06 19:22:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1351", "463", "action complete via WP Cron", "2024-05-06 19:22:50", "2024-05-06 19:22:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1352", "464", "action created", "2024-05-06 19:25:41", "2024-05-06 19:25:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1353", "464", "action started via WP Cron", "2024-05-06 19:26:50", "2024-05-06 19:26:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1354", "464", "action complete via WP Cron", "2024-05-06 19:26:50", "2024-05-06 19:26:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1355", "465", "action created", "2024-05-06 19:42:13", "2024-05-06 19:42:13");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1356", "465", "action started via WP Cron", "2024-05-06 19:44:16", "2024-05-06 19:44:16");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1357", "465", "action complete via WP Cron", "2024-05-06 19:44:17", "2024-05-06 19:44:17");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1358", "466", "action created", "2024-05-06 19:44:26", "2024-05-06 19:44:26");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1359", "466", "action started via Async Request", "2024-05-06 19:45:57", "2024-05-06 19:45:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1360", "466", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-05-06 19:45:57", "2024-05-06 19:45:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1361", "467", "action created", "2024-05-06 20:21:33", "2024-05-06 20:21:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1362", "467", "action started via WP Cron", "2024-05-06 20:22:57", "2024-05-06 20:22:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1363", "467", "action complete via WP Cron", "2024-05-06 20:22:57", "2024-05-06 20:22:57");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1364", "468", "action created", "2024-05-06 21:24:01", "2024-05-06 21:24:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1365", "468", "action started via Async Request", "2024-05-06 21:24:12", "2024-05-06 21:24:12");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1366", "468", "action complete via Async Request", "2024-05-06 21:24:12", "2024-05-06 21:24:12");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1367", "462", "action started via WP Cron", "2024-05-07 01:57:22", "2024-05-07 01:57:22");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1368", "462", "action complete via WP Cron", "2024-05-07 01:57:23", "2024-05-07 01:57:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1369", "469", "action created", "2024-05-07 01:57:23", "2024-05-07 01:57:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1370", "419", "action started via WP Cron", "2024-05-07 12:09:48", "2024-05-07 12:09:48");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1371", "419", "action complete via WP Cron", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1372", "470", "action created", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1373", "420", "action started via WP Cron", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1374", "420", "action complete via WP Cron", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1375", "471", "action created", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1376", "424", "action started via WP Cron", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1377", "424", "action complete via WP Cron", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1378", "472", "action created", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1379", "425", "action started via WP Cron", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1380", "425", "action complete via WP Cron", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1381", "473", "action created", "2024-05-07 12:09:49", "2024-05-07 12:09:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1382", "459", "action started via WP Cron", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1383", "459", "action complete via WP Cron", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1384", "474", "action created", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1385", "460", "action started via WP Cron", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1386", "460", "action complete via WP Cron", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1387", "475", "action created", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1388", "461", "action started via WP Cron", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1389", "461", "action complete via WP Cron", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1390", "476", "action created", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1391", "469", "action started via WP Cron", "2024-05-07 14:03:31", "2024-05-07 14:03:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1392", "469", "action complete via WP Cron", "2024-05-07 14:03:32", "2024-05-07 14:03:32");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1393", "477", "action created", "2024-05-07 14:03:32", "2024-05-07 14:03:32");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1394", "477", "action started via WP Cron", "2024-05-08 12:45:35", "2024-05-08 12:45:35");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1395", "477", "action complete via WP Cron", "2024-05-08 12:45:35", "2024-05-08 12:45:35");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1396", "478", "action created", "2024-05-08 12:45:35", "2024-05-08 12:45:35");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1397", "474", "action started via WP Cron", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1398", "474", "action complete via WP Cron", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1399", "479", "action created", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1400", "475", "action started via WP Cron", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1401", "475", "action complete via WP Cron", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1402", "480", "action created", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1403", "476", "action started via WP Cron", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1404", "476", "action complete via WP Cron", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1405", "481", "action created", "2024-05-08 14:05:33", "2024-05-08 14:05:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1406", "482", "action created", "2024-05-08 14:14:31", "2024-05-08 14:14:31");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1408", "484", "action created", "2024-05-08 14:14:34", "2024-05-08 14:14:34");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1413", "484", "action started via WP Cron", "2024-05-08 14:14:48", "2024-05-08 14:14:48");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1414", "487", "action created", "2024-05-08 14:14:49", "2024-05-08 14:14:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1416", "488", "action created", "2024-05-08 14:14:49", "2024-05-08 14:14:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1417", "484", "action complete via WP Cron", "2024-05-08 14:14:49", "2024-05-08 14:14:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1418", "482", "action started via WP Cron", "2024-05-08 14:14:49", "2024-05-08 14:14:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1419", "482", "action complete via WP Cron", "2024-05-08 14:14:50", "2024-05-08 14:14:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1420", "487", "action started via Async Request", "2024-05-08 14:15:18", "2024-05-08 14:15:18");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1421", "487", "action complete via Async Request", "2024-05-08 14:15:18", "2024-05-08 14:15:18");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1422", "488", "action started via Async Request", "2024-05-08 14:15:18", "2024-05-08 14:15:18");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1423", "489", "action created", "2024-05-08 14:15:19", "2024-05-08 14:15:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1424", "490", "action created", "2024-05-08 14:15:19", "2024-05-08 14:15:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1425", "488", "action complete via Async Request", "2024-05-08 14:15:19", "2024-05-08 14:15:19");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1426", "489", "action started via Async Request", "2024-05-08 14:15:29", "2024-05-08 14:15:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1427", "489", "action complete via Async Request", "2024-05-08 14:15:29", "2024-05-08 14:15:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1428", "490", "action started via Async Request", "2024-05-08 14:15:29", "2024-05-08 14:15:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1429", "490", "action complete via Async Request", "2024-05-08 14:15:30", "2024-05-08 14:15:30");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1430", "491", "action created", "2024-05-08 14:15:40", "2024-05-08 14:15:40");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1434", "494", "action created", "2024-05-08 14:15:44", "2024-05-08 14:15:44");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1438", "496", "action created", "2024-05-08 14:15:50", "2024-05-08 14:15:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1439", "494", "action started via WP Cron", "2024-05-08 14:16:49", "2024-05-08 14:16:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1440", "497", "action created", "2024-05-08 14:16:51", "2024-05-08 14:16:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1441", "496", "action canceled", "2024-05-08 14:16:51", "2024-05-08 14:16:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1442", "498", "action created", "2024-05-08 14:16:51", "2024-05-08 14:16:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1443", "494", "action complete via WP Cron", "2024-05-08 14:16:52", "2024-05-08 14:16:52");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1444", "491", "action started via Async Request", "2024-05-08 14:17:06", "2024-05-08 14:17:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1445", "491", "action complete via Async Request", "2024-05-08 14:17:07", "2024-05-08 14:17:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1446", "497", "action started via Async Request", "2024-05-08 14:17:15", "2024-05-08 14:17:15");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1447", "497", "action complete via Async Request", "2024-05-08 14:17:15", "2024-05-08 14:17:15");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1448", "498", "action started via Async Request", "2024-05-08 14:17:15", "2024-05-08 14:17:15");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1449", "499", "action created", "2024-05-08 14:17:16", "2024-05-08 14:17:16");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1450", "500", "action created", "2024-05-08 14:17:16", "2024-05-08 14:17:16");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1451", "498", "action complete via Async Request", "2024-05-08 14:17:16", "2024-05-08 14:17:16");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1452", "499", "action started via Async Request", "2024-05-08 14:17:29", "2024-05-08 14:17:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1453", "499", "action complete via Async Request", "2024-05-08 14:17:29", "2024-05-08 14:17:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1454", "500", "action started via Async Request", "2024-05-08 14:17:29", "2024-05-08 14:17:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1455", "500", "action complete via Async Request", "2024-05-08 14:17:30", "2024-05-08 14:17:30");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1456", "501", "action created", "2024-05-08 14:17:47", "2024-05-08 14:17:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1460", "504", "action created", "2024-05-08 14:17:51", "2024-05-08 14:17:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1464", "506", "action created", "2024-05-08 14:18:00", "2024-05-08 14:18:00");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1465", "501", "action started via WP Cron", "2024-05-08 16:07:36", "2024-05-08 16:07:36");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1466", "501", "action complete via WP Cron", "2024-05-08 16:07:36", "2024-05-08 16:07:36");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1467", "504", "action started via WP Cron", "2024-05-08 16:07:36", "2024-05-08 16:07:36");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1468", "507", "action created", "2024-05-08 16:07:38", "2024-05-08 16:07:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1469", "506", "action canceled", "2024-05-08 16:07:38", "2024-05-08 16:07:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1470", "508", "action created", "2024-05-08 16:07:38", "2024-05-08 16:07:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1471", "504", "action complete via WP Cron", "2024-05-08 16:07:38", "2024-05-08 16:07:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1472", "506", "action ignored via WP Cron", "2024-05-08 16:07:38", "2024-05-08 16:07:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1473", "507", "action started via WP Cron", "2024-05-08 16:18:13", "2024-05-08 16:18:13");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1474", "507", "action complete via WP Cron", "2024-05-08 16:18:13", "2024-05-08 16:18:13");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1475", "508", "action started via WP Cron", "2024-05-08 16:18:49", "2024-05-08 16:18:49");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1476", "509", "action created", "2024-05-08 16:18:50", "2024-05-08 16:18:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1477", "510", "action created", "2024-05-08 16:18:50", "2024-05-08 16:18:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1478", "508", "action complete via WP Cron", "2024-05-08 16:18:50", "2024-05-08 16:18:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1479", "509", "action started via Async Request", "2024-05-08 16:19:11", "2024-05-08 16:19:11");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1480", "509", "action complete via Async Request", "2024-05-08 16:19:12", "2024-05-08 16:19:12");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1481", "510", "action started via Async Request", "2024-05-08 16:19:24", "2024-05-08 16:19:24");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1482", "510", "action complete via Async Request", "2024-05-08 16:19:25", "2024-05-08 16:19:25");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1483", "511", "action created", "2024-05-08 16:24:36", "2024-05-08 16:24:36");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1484", "511", "action started via WP Cron", "2024-05-08 16:26:01", "2024-05-08 16:26:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1485", "511", "action complete via WP Cron", "2024-05-08 16:26:02", "2024-05-08 16:26:02");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1486", "512", "action created", "2024-05-08 16:34:55", "2024-05-08 16:34:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1496", "518", "action created", "2024-05-08 16:35:46", "2024-05-08 16:35:46");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1507", "512", "action started via WP Cron", "2024-05-08 16:35:50", "2024-05-08 16:35:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1508", "512", "action complete via WP Cron", "2024-05-08 16:35:50", "2024-05-08 16:35:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1509", "518", "action started via WP Cron", "2024-05-08 16:35:50", "2024-05-08 16:35:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1510", "524", "action created", "2024-05-08 16:35:52", "2024-05-08 16:35:52");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1512", "525", "action created", "2024-05-08 16:35:52", "2024-05-08 16:35:52");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1513", "518", "action complete via WP Cron", "2024-05-08 16:35:52", "2024-05-08 16:35:52");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1514", "524", "action started via Async Request", "2024-05-08 16:36:00", "2024-05-08 16:36:00");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1515", "524", "action complete via Async Request", "2024-05-08 16:36:01", "2024-05-08 16:36:01");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1516", "525", "action started via Async Request", "2024-05-08 16:36:20", "2024-05-08 16:36:20");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1517", "526", "action created", "2024-05-08 16:36:22", "2024-05-08 16:36:22");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1518", "527", "action created", "2024-05-08 16:36:22", "2024-05-08 16:36:22");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1519", "525", "action complete via Async Request", "2024-05-08 16:36:22", "2024-05-08 16:36:22");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1520", "526", "action started via Async Request", "2024-05-08 16:36:32", "2024-05-08 16:36:32");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1521", "526", "action complete via Async Request", "2024-05-08 16:36:32", "2024-05-08 16:36:32");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1522", "527", "action started via Async Request", "2024-05-08 16:36:32", "2024-05-08 16:36:32");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1523", "527", "action complete via Async Request", "2024-05-08 16:36:33", "2024-05-08 16:36:33");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1524", "528", "action created", "2024-05-08 17:35:23", "2024-05-08 17:35:23");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1525", "529", "action created", "2024-05-08 17:35:55", "2024-05-08 17:35:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1526", "530", "action created", "2024-05-08 17:35:55", "2024-05-08 17:35:55");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1527", "528", "action started via Async Request", "2024-05-08 17:36:06", "2024-05-08 17:36:06");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1528", "528", "action complete via Async Request", "2024-05-08 17:36:07", "2024-05-08 17:36:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1529", "529", "action started via Async Request", "2024-05-08 17:36:07", "2024-05-08 17:36:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1530", "529", "action complete via Async Request", "2024-05-08 17:36:07", "2024-05-08 17:36:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1531", "530", "action started via Async Request", "2024-05-08 17:36:07", "2024-05-08 17:36:07");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1532", "530", "action complete via Async Request", "2024-05-08 17:36:08", "2024-05-08 17:36:08");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1533", "435", "action started via WP Cron", "2024-05-08 23:49:29", "2024-05-08 23:49:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1534", "435", "action failed via WP Cron: Scheduled action for cartflows_update_knowledge_base_data will not be executed as no callbacks are registered.", "2024-05-08 23:49:29", "2024-05-08 23:49:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1535", "435", "This action appears to be consistently failing. A new instance will not be scheduled.", "2024-05-08 23:49:29", "2024-05-08 23:49:29");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1536", "531", "action created", "2024-05-09 10:13:47", "2024-05-09 10:13:47");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1537", "478", "action started via Async Request", "2024-05-09 10:13:50", "2024-05-09 10:13:50");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1538", "478", "action complete via Async Request", "2024-05-09 10:13:51", "2024-05-09 10:13:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1539", "532", "action created", "2024-05-09 10:13:51", "2024-05-09 10:13:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1540", "531", "action started via Async Request", "2024-05-09 10:13:51", "2024-05-09 10:13:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1541", "531", "action complete via Async Request", "2024-05-09 10:13:51", "2024-05-09 10:13:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1542", "533", "action created", "2024-05-09 10:13:51", "2024-05-09 10:13:51");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1543", "479", "action started via WP Cron", "2024-05-09 14:06:58", "2024-05-09 14:06:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1544", "479", "action complete via WP Cron", "2024-05-09 14:06:58", "2024-05-09 14:06:58");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1545", "534", "action created", "2024-05-09 14:06:59", "2024-05-09 14:06:59");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1546", "480", "action started via Async Request", "2024-05-09 14:07:13", "2024-05-09 14:07:13");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1547", "480", "action complete via Async Request", "2024-05-09 14:07:14", "2024-05-09 14:07:14");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1548", "535", "action created", "2024-05-09 14:07:15", "2024-05-09 14:07:15");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1549", "481", "action started via Async Request", "2024-05-09 14:07:41", "2024-05-09 14:07:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1550", "481", "action complete via Async Request", "2024-05-09 14:07:41", "2024-05-09 14:07:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1551", "536", "action created", "2024-05-09 14:07:41", "2024-05-09 14:07:41");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1552", "532", "action started via WP Cron", "2024-05-09 23:14:38", "2024-05-09 23:14:38");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1553", "532", "action complete via WP Cron", "2024-05-09 23:14:39", "2024-05-09 23:14:39");
INSERT INTO `ethr_actionscheduler_logs` VALUES("1554", "537", "action created", "2024-05-09 23:14:39", "2024-05-09 23:14:39");

/* INSERT TABLE DATA: ethr_addonlibrary_addons */
INSERT INTO `ethr_addonlibrary_addons` VALUES("1", "WooCommerce Product List", "woocommerce_product_list_elementor", "woocommerce_product_list", "elementor", "Showcase your WooCommerce products in an attractive list layout with many customization options. You can choose how many products to show per page, what information to display about each product, and much more.", "1", "{\"html\":\"<div id=\\\"{{uc_id}}\\\"  class=\\\"product-list-cont{{uc_filtering_addclass}}{{remote_parent.class}} {{uc_dynamic_popup_class}}\\\" {{uc_filtering_attributes|raw}} {{remote_parent.attributes|raw}} >\\n\\t<ul class=\\\"product-list uc-items-wrapper\\\">\\n\\n\\t\\t{{put_items()}}\\n\\n\\n\\t<\\/ul>\\n<\\/div>\\n\\n\\n{% if show_empty_message == \\\"true\\\" %}\\n\\n  <div id=\\\"{{uc_id}}_empty_message\\\" class=\\\"ue-no-posts-found\\\" {% if uc_num_items > 0 %} style=\\\"display:none\\\" {% endif %}>{{no_posts_found|raw}}<\\/div>\\n\\n{% endif %}\",\"html_item\":\"<li class=\\\"product-items\\\" style=\\\"overflow:hidden;\\\" id=\\\"{{item.item_id}}\\\"> \\n  \\n    {% if(before_shop_loop_item == \\\"true\\\") %} \\n  \\t\\t{{do_action(\\\"woocommerce_before_shop_loop_item\\\")}}\\n\\t{% endif %}  \\n\\n  \\t{% if(enable_third_party_integrations == \\\"true\\\")%}\\n    \\t{{do_action(\'ue_woocommerce_product_integrations\', item.product.id)}}\\n\\t{%endif%}\\n  \\n            {% if show_image == \\\"true\\\" %}\\n             \\t<div class=\\\"product-img\\\" href=\\\"{{item.product.link}}\\\">\\n                  \\n                  \\n                  {% if item.product.image is empty %}\\n                      <img src=\\\"{{empty_image_placeholder}}\\\" {{empty_image_placeholder_attributes|raw}}>\\n                  {% else %} \\n                      <img src=\\\"{{item.product.image}}\\\" {{item.product.image_attributes|raw}}>\\n                  {% endif %}\\t\\n                  \\n                   \\n                 \\n                   {% if badge == \\\"image\\\" %}\\n                   \\t{% if show_labels == \\\"true\\\" %}\\n                      {% if(item.product.woo_stock_status == \\\"outofstock\\\") %}\\n                        <div class=\\\"ue_woocommerce_product_label ue_woocommerce_product_grid_out_of_stock_label\\\">{{out_of_stock_text|raw}}<\\/div>\\n                      {% else %}\\n                        {% if item.product.woo_sale_price is empty %}\\n                        {% else %}\\n                           <div class=\\\"ue_woocommerce_product_label ue_woocommerce_product_list_badge\\\">\\n                             {{sale_label|raw}} \\n                             {% if show_sale_precent_in_label == \\\"true\\\" %}\\n                               {{item.product.woo_discount_percent}}%\\n                             {% endif %}\\n                             {{sale_label_end_text|raw}}\\n                           <\\/div>\\n                        {% endif %}\\n                      {% endif %}\\n                    {% endif %}\\n                   {% endif %} \\n                  \\n                  <div class=\\\"product-img-overlay\\\">\\n                    <div class=\\\"uc-buttons\\\">\\n                      {% if (show_product_button == \\\"true\\\") and (product_button_type == \\\"image_overlay\\\") %}\\n                      \\n                      \\t<a href=\\\"{{item.product.link}}\\\" {{item.product.dynamic_popup_link_attributes|raw}} class=\\\"product-text-btn {{item.product.dynamic_popup_link_class}}\\\" > {{product_page_button_text|raw}}<\\/a> \\n                      \\n                      {% endif %}\\n                      \\n                      {% if cart_button == \\\"image_overlay\\\" %} \\n                  \\n                      {% if(item.product.woo_type == \\\"variable\\\") %}\\n                          {% set buttonAddCartTextCombined = select_options_button_text %}        \\t\\n                      {% else %}\\n                          {% set buttonAddCartTextCombined = cart_button_text %}\\n                      {% endif %}\\n                                    \\n                          <a {{item.product.woo_addcart_ajax_attributes|raw}}>{{ buttonAddCartTextCombined|raw}}<\\/a>                  \\n                                    \\t\\n                  {% endif %}\\n                    <\\/div>   \\n                  <\\/div>\\n                <\\/div> \\n  \\n  \\t\\t\\t\\t <div class=\\\"uc-product-items-spacer\\\"><\\/div>\\n            {% endif %}\\t\\n\\t\\t\\t\\n           \\n\\n\\t\\t\\t<div class=\\\"product-text\\\"> \\n              \\n              {% if badge == \\\"content\\\" %}\\n               {% if show_labels == \\\"true\\\" %}\\n              \\t{% if(item.product.woo_stock_status == \\\"outofstock\\\") %}\\n                  <div class=\\\"ue_woocommerce_product_label ue_woocommerce_product_grid_out_of_stock_label\\\">{{out_of_stock_text|raw}}<\\/div>\\n                {% else %}\\n                  {% if item.product.woo_sale_price is empty %}\\n                  {% else %}\\n                     <div class=\\\"ue_woocommerce_product_label ue_woocommerce_product_list_badge\\\">\\n                       {{sale_label|raw}} \\n                       {% if show_sale_precent_in_label == \\\"true\\\" %}\\n                         {{item.product.woo_discount_percent}}%\\n                       {% endif %}\\n                       {{sale_label_end_text|raw}}\\n                     <\\/div>\\n                  {% endif %}\\n              \\t{% endif %}\\n               {% endif %}\\t\\n              {% endif %}\\n              \\n              {% if category == \\\"above\\\" %}\\n\\t\\t\\t\\t<div class=\\\"ue-product-category\\\"><a  href=\\\"{{item.product.category_link}}\\\">{{item.product.category_name}} <\\/a><\\/div>\\n              {% endif %}\\n              \\n              {% if(before_shop_loop_item_title == \\\"true\\\") %} \\n                  {{do_action(\\\"woocommerce_before_shop_loop_item_title\\\")}}\\n              {% endif %}\\n              \\n               {% if(show_label_from_custom_field_ == \\\"true\\\") %}          \\t\\t\\n       \\n                  {% set custom_field_value = ucfunc(\\\"get_post_custom_field\\\", item.products.id, custom_field_name) %} \\n\\n                  {% if custom_field_value is not empty %}\\n                          <div class=\\\"ue_woocommerce_product_label ue_woocommerce_product_label-custom-field\\\">{{custom_field_value|raw}}<\\/div>\\n                  {% endif %}\\n\\n              {% endif %}\\n              \\n              {% if show_title == \\\"true\\\" %}\\n\\t\\t\\t\\t<a class=\\\"product-text-name\\\" href=\\\"{{item.product.link}}\\\">{{item.product.title|raw}} <\\/a>\\n              {% endif %}\\t\\n              \\n              {% if(after_shop_loop_item_title == \\\"true\\\") %} \\n                  {{do_action(\\\"woocommerce_after_shop_loop_item_title\\\")}}\\n              {% endif %}\\n              \\n              {% if category == \\\"under\\\" %}\\n\\t\\t\\t\\t<div class=\\\"ue-product-category\\\"><a class=\\\"ue-product-category\\\" href=\\\"{{item.product.category_link}}\\\">{{item.product.category_name}} <\\/a><\\/div>\\n              {% endif %}\\n              \\n              {% if show_description == \\\"short\\\" %}\\n              <div class=\\\"product-short-description\\\">{{item.product.intro|raw}}<\\/div>\\n              {% endif %}\\n              \\n              {% if show_description == \\\"full\\\" %}\\n              <div class=\\\"product-short-description\\\">{{item.product.intro_full|truncate(10000)|raw}}<\\/div>\\n              {% endif %}\\n              \\n              {% if show_rating == \\\"true\\\" %}\\n              <div class=\\\"product-rating\\\">\\n                {%for staritem in item.product.woo_rating_stars %}                \\n                    <i class=\\\"{{staritem.class}}\\\"><\\/i>\\n                {% endfor %}\\n              <\\/div>\\n              {% endif %}\\n              \\n              <div class=\\\"product-text-wrapper uc-prices\\\">\\n         \\n                {% if show_regular_price == \\\"true\\\" and item.product.woo_sale_price is not empty %}  \\n\\t\\t\\t\\t\\t\\n                      {%if item.product.woo_type == \\\"variable\\\" %}\\n\\n                            {% if item.product.woo_regular_price_from == item.product.woo_regular_price_to %}\\n                                <span class=\\\"product-text-price uc_regular_price\\\">{{item.product.woo_regular_price|wc_price|raw}}<\\/span> <span class=\\\"uc_price_spacer\\\" style=\\\"display:inline-block;\\\"><\\/span> \\n                            {% else %}\\n                                <span class=\\\"product-text-price uc_regular_price\\\">{{item.product.woo_regular_price_from|wc_price(item.product.woo_regular_price_from_id)|raw}}<\\/span> - <span class=\\\"product-text-price uc_regular_price\\\">{{item.product.woo_regular_price_to|wc_price(item.product.woo_regular_price_to_id)|raw}}<\\/span><span class=\\\"uc_price_spacer\\\" style=\\\"display:inline-block;\\\"><\\/span> \\n                            {% endif %}\\n                      {%else%}\\n                            <span class=\\\"product-text-price uc_regular_price\\\">{{item.product.woo_regular_price|wc_price|raw}}<\\/span> <span class=\\\"uc_price_spacer\\\" style=\\\"display:inline-block;\\\"><\\/span> \\n                       {%endif%}\\n                    {% endif %}\\n                    \\n                 {% if show_sale_price == \\\"true\\\" %}\\n\\t\\t\\t\\t\\t{%if item.product.woo_type == \\\"variable\\\" %}\\n                          {% if item.product.woo_price_from == item.product.woo_price_to %}\\n\\t\\t\\t\\t\\t\\t\\t\\t<span class=\\\"product-text-price uc_sale_price\\\">{{item.product.woo_price|wc_price|raw}}<\\/span> \\n                          {% else %}\\n\\t\\t\\t\\t\\t\\t\\t\\t<span class=\\\"product-text-price uc_sale_price\\\">{{item.product.woo_price_from|wc_price(item.product.woo_price_from_id)|raw}}<\\/span> - <span class=\\\"product-text-price uc_sale_price\\\">{{item.product.woo_price_to|wc_price(item.product.woo_price_to_id)|raw}}<\\/span>\\n\\t\\t\\t\\t\\t\\t  {% endif %}\\n\\t\\t\\t\\t\\t{%else%}\\n\\t\\t\\t\\t\\t\\t<span class=\\\"product-text-price uc_sale_price\\\">{{item.product.woo_price|wc_price(item.product.id)|raw}}<\\/span> \\n\\t\\t\\t\\t    {%endif%}\\n\\t\\t\\t\\t{% endif %}\\n                \\n              <\\/div> \\n              \\n               \\n                <div class=\\\"product-text-wrapper uc-buttons\\\"> \\n                  \\n                  {% if (show_product_button == \\\"true\\\") and (product_button_type == \\\"content\\\") %} \\n                      \\n                      \\t<a {{item.product.dynamic_popup_link_attributes|raw}} class=\\\"product-text-btn {{item.product.dynamic_popup_link_class}}\\\" > {{product_page_button_text|raw}}<\\/a> <span class=\\\"uc_btn_spacer\\\" style=\\\"display:inline-block;\\\"><\\/span> \\n                  \\n                  {% endif %}\\n                  \\n                  {% if cart_button == \\\"content\\\" %} \\n                  \\n                      {% if(item.product.woo_type == \\\"variable\\\") %}\\n                          {% set buttonAddCartTextCombined = select_options_button_text %}        \\t\\n                      {% else %}\\n                          {% set buttonAddCartTextCombined = cart_button_text %}\\n                      {% endif %}\\n                                    \\n                          <a {{item.product.woo_addcart_ajax_attributes|raw}}>{{ buttonAddCartTextCombined|raw}}<\\/a>                  \\n                                    \\t\\n                  {% endif %}\\n                \\n              <\\/div>\\n                \\n{% if(enable_third_party_integrations == \\\"true\\\")%}\\n\\t{{do_action(\'ue_woocommerce_product_integrations_bottom\', item.product.id)}}\\n{%endif%}\\n              \\n              {% if(after_shop_loop_item == \\\"true\\\") %} \\n                    {{do_action(\\\"woocommerce_after_shop_loop_item\\\")}}\\n              {% endif %}  \\t\\n              \\n\\t\\t\\t<\\/div>\\n<\\/li>\",\"css\":\"#{{uc_id}}  *{\\n\\tbox-sizing:border-box;\\n}\\n\\n#{{uc_id}} ul\\n{\\n  padding:0px;\\n  margin:0px;\\n  display:grid;\\n}\\n#{{uc_id}} .product-img{\\n\\t\\n    flex-grow:0;\\n    flex-shrink:0;\\n    display:flex;\\n    align-items:center;\\n    justify-content:center;\\n    position:relative;\\n    overflow:hidden;\\n}\\n\\n#{{uc_id}} .product-img img\\n{\\n  display:block;\\n}\\n\\n \\n#{{uc_id}} .product-items{\\n\\tdisplay: flex;\\n\\talign-items:{{content_align}};\\n}\\n\\n\\n#{{uc_id}} .product-items:last-child{\\n    margin-bottom:0px;\\n}\\n\\n#{{uc_id}} .product-text{\\nflex-grow:1;\\n}\\n\\n.product-text-name\\n{\\n  font-size: 21px;\\n}\\n\\n#{{uc_id}} .product-text-name{\\n\\tdisplay: block;\\n\\ttext-decoration: none;\\n\\t\\n}\\n\\n#{{uc_id}} .uc-buttons a {\\n\\tcursor: pointer;\\n\\ttext-decoration: none;\\n    text-align:center;\\n    transition:0.3s;\\n}\\n\\n.uc-button-addcart.added\\n{\\n  display:none !important;\\n}\\n\\n#{{uc_id}} .ue_woocommerce_product_list_badge\\n{\\n  display:inline-flex;\\n  align-items:center;\\n  justify-content:center;\\n}\\n\\n.ue_woocommerce_product_grid_out_of_stock_label, .ue_woocommerce_product_list_badge\\n{\\n  font-size:12px;\\n}\\n\\n#{{uc_id}} .ue_woocommerce_product_grid_out_of_stock_label{\\n display:inline-flex;\\n align-items:center;\\n justify-content:center;\\n}\\n\\n#{{uc_id}} .product-img-overlay\\n{\\n  position:absolute;\\n  top:0;\\n  bottom:0;\\n  right:0;\\n  left:0;\\n  flex-direction:column;\\n  display:flex;\\n  align-items:center;\\n  transition:0.3s;\\n}\\n\\n#{{uc_id}} .product-img-overlay .uc-buttons\\n{\\n  text-align:center;\\n  width:100%;\\n}\\n\\n{% if badge == \\\"image\\\" %}\\n    #{{uc_id}} .ue_woocommerce_product_list_badge\\n\\t{\\n      position:absolute;\\n      {{vertical_snap}}:{{label_vertical_distance}}px;\\n      {{horizontal_snap}}:{{label_horizontal_distance}}px;\\n    }\\n\\t#{{uc_id}} .ue_woocommerce_product_grid_out_of_stock_label{\\n      position: absolute;\\n      {{horizontal_snap}}:{{label_horizontal_distance}}px;\\n      {{vertical_snap}}:{{label_vertical_distance}}px;\\n      z-index: 1;\\n\\t}\\n{% endif %}\\n\\n\\n{% if collapse_on_mobile == \\\"true\\\" %}\\n\\n@media only screen and (max-width: {{collapse_from_resolution}}px) {\\n  #{{uc_id}} .product-items{\\n    flex-wrap: wrap;\\n   }\\n}\\n\\n\\n{% endif %}\\n\\n#{{uc_id}} .jet-wishlist-button__container{\\n  \\tmargin-top:10px;\\n}\",\"css_item\":\"{% if item.product.woo_sale_price is empty %}\\n\\t#{{item.item_id}} .uc_sale_currency\\n    {\\n      display:none\\n    }\\n{% else %} \\n\\t#{{item.item_id}} .uc_regular_price\\n    {\\n      text-decoration:line-through !important;\\n    }\\n{% endif %}\",\"js\":\"jQuery(document).ready(function(){\\n    \\n  var objGrid = jQuery(\\\"#{{uc_id}}\\\");\\n    \\n  var objRemoteOptions = {\\n    \\tclass_items:\\\"product-items\\\",\\n    \\tclass_active:\\\"ue-active-item\\\",\\n      \\tadd_set_active_code:false\\n  };\\n  \\n  {{ucfunc(\\\"put_remote_parent_js\\\",\\\"objGrid\\\",\\\"objRemoteOptions\\\")}}  \\n \\n});\"}", "{\"options\":{\"items_section_title\":\"\",\"items_section_heading\":\"\",\"items_title_field\":\"\",\"path_assets\":\"woocommerce_product_list\",\"js_as_module\":false,\"addon_icon\":\"fas fa-shopping-basket\",\"dynamic_addon\":\"false\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"Showcase your WooCommerce products in an attractive list layout with many customization options. You can choose how many products to show per page, what information to display about each product, and much more.\",\"link_resource\":\"https:\\/\\/unlimited-elements.com\\/docs\\/woocommerce-product-list\\/\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/woocommerce-product-list-widget-for-elementor\\/\",\"show_small_icon\":\"true\",\"preview_size\":\"full\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"special\":\"\",\"special_data\":\"\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_posts_list\",\"title\":\"Product\",\"name\":\"product\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"use_custom_fields\":true,\"use_category\":true,\"default_max_posts\":\"\",\"for_woocommerce_products\":true,\"show_image_sizes\":true,\"enable_ajax\":true,\"font_editable\":false,\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_textfield\",\"title\":\"Product Page Button Text\",\"name\":\"product_page_button_text\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"Details\",\"font_editable\":false,\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Color\",\"name\":\"button_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".uc-buttons a\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Color\",\"name\":\"button_color_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"#ffffff\",\"selector\":\".product-img-overlay .uc-buttons a\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Color Hover\",\"name\":\"button_color_hover\",\"description\":\"\",\"default_value\":\"#6f6f6f\",\"selector\":\".uc-buttons a:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Color Hover\",\"name\":\"button_color_hover_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"\",\"selector\":\".product-img-overlay .uc-buttons a:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_slider\",\"title\":\"Image Width\",\"name\":\"image_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"150\",\"min\":\"50\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px_percent\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-img \",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_uj97soov\"},{\"type\":\"uc_slider\",\"title\":\"Image Height\",\"name\":\"image_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"150\",\"min\":\"50\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-img img\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_uj97soov\"},{\"type\":\"uc_slider\",\"title\":\"Image Radius\",\"name\":\"image_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"200\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-img\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_uj97soov\"},{\"type\":\"uc_dropdown\",\"title\":\"Content Vertical Align\",\"name\":\"content_vertical_align\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"layout_type\",\"condition_operator\":\"equal\",\"condition_value\":[\"flex\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"options\":{\"Start\":\"start\",\"Center\":\"center\",\"End\":\"end\"},\"default_value\":\"center\",\"selector\":\".product-text\",\"selector_value\":\"align-items: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_slider\",\"title\":\"Content Gutter\",\"name\":\"content_gutter\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"layout_type\",\"condition_operator\":\"equal\",\"condition_value\":[\"flex\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-text\",\"selector_value\":\"gap: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_dropdown\",\"title\":\"Item Direction\",\"name\":\"item_direction\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Normal\",\"options\":{\"Regular\":\"row\",\"Reverse\":\"row-reverse\"},\"default_value\":\"row\",\"selector\":\".product-items\",\"selector_value\":\"flex-direction:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_dropdown\",\"title\":\"Content Align\",\"name\":\"content_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Normal\",\"options\":{\"Top\":\"flex-start\",\"Bottom\":\"flex-end\",\"Center\":\"center\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Title\",\"name\":\"show_title\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_textfield\",\"title\":\"Select Options Button Text\",\"name\":\"select_options_button_text\",\"description\":\"This text appears on variable products instead of add to cart text\",\"enable_condition\":\"false\",\"condition_attribute\":\"default\",\"condition_operator\":\"equal\",\"condition_value\":\"default\",\"default_value\":\"Select Options\",\"font_editable\":\"false\",\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_dropdown\",\"title\":\"Category\",\"name\":\"category\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"options\":{\"Hide\":\"hide\",\"Above Title\":\"above\",\"Under Title\":\"under\"},\"default_value\":\"hide\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Show Description\",\"name\":\"show_description\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"None\":\"none\",\"Short\":\"short\",\"Full\":\"full\"},\"default_value\":\"none\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Regular Price\",\"name\":\"show_regular_price\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Sale Price\",\"name\":\"show_sale_price\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Image\",\"name\":\"show_image\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Price Spacing\",\"name\":\"price_spacing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc-prices\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_jzrqsfhj\"},{\"type\":\"uc_slider\",\"title\":\"Price Space Between\",\"name\":\"price_space_between\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_price_spacer\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_jzrqsfhj\"},{\"type\":\"uc_typography\",\"title\":\"Regular Price Typography\",\"name\":\"price_typography\",\"description\":\"\",\"selector1\":\".uc_regular_price\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_jzrqsfhj\"},{\"type\":\"uc_colorpicker\",\"title\":\"Regular Price Color\",\"name\":\"price_color\",\"description\":\"\",\"default_value\":\"#707070\",\"selector\":\".uc_regular_price\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_jzrqsfhj\"},{\"type\":\"uc_textfield\",\"title\":\"Cart Button Text\",\"name\":\"cart_button_text\",\"description\":\"\",\"default_value\":\"Add To Cart\",\"font_editable\":false,\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_slider\",\"title\":\"Image Spacing\",\"name\":\"image_spacing\",\"description\":\"\",\"default_value\":\"30\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc-product-items-spacer\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_uj97soov\"},{\"type\":\"uc_typography\",\"title\":\"Button Typography\",\"name\":\"button_typography\",\"description\":\"\",\"selector1\":\".uc-buttons a\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_typography\",\"title\":\"Button Typography\",\"name\":\"button_typography_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"selector1\":\".product-img-overlay .uc-buttons a\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_padding\",\"title\":\"Button Padding\",\"name\":\"button_padding\",\"description\":\"\",\"is_responsive\":true,\"desktop_top\":\"10\",\"desktop_right\":\"20\",\"desktop_bottom\":\"10\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc-buttons a\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_padding\",\"title\":\"Button Padding\",\"name\":\"button_padding_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"is_responsive\":true,\"desktop_top\":\"10\",\"desktop_right\":\"20\",\"desktop_bottom\":\"10\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".product-img-overlay .uc-buttons a\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_colorpicker\",\"title\":\"Item Background\",\"name\":\"item_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Normal\",\"default_value\":\"\",\"selector\":\".product-items\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_border\",\"title\":\"Item Border\",\"name\":\"item_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Normal\",\"border_type\":\"solid\",\"border_color\":\"#d9d9d9\",\"width_desktop_top\":\"0\",\"width_desktop_right\":\"0\",\"width_desktop_bottom\":\"1\",\"width_desktop_left\":\"0\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\"li.product-items\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_padding\",\"title\":\"Item Padding\",\"name\":\"item_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Normal\",\"is_responsive\":true,\"desktop_top\":\"20\",\"desktop_right\":\"0\",\"desktop_bottom\":\"20\",\"desktop_left\":\"0\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\"li.product-items\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_slider\",\"title\":\"Item Radius\",\"name\":\"item_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Normal\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"200\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"li.product-items\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Text Color\",\"name\":\"button_text_color\",\"description\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".uc-buttons a\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Text Color\",\"name\":\"button_text_color_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"#000000\",\"selector\":\".product-img-overlay .uc-buttons a\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Text Color Hover\",\"name\":\"button_text_color_hover\",\"description\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".uc-buttons a:hover\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Text Color Hover\",\"name\":\"button_text_color_hover_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"\",\"selector\":\".product-img-overlay .uc-buttons a:hover\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_border\",\"title\":\"Button Border\",\"name\":\"button_border\",\"description\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc-buttons a\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_border\",\"title\":\"Button Border\",\"name\":\"button_border_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".product-img-overlay .uc-buttons a\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_border\",\"title\":\"Button Border Hover\",\"name\":\"button_border_hover\",\"description\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc-buttons a:hover\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_border\",\"title\":\"Button Border Hover\",\"name\":\"button_border_hover_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".product-img-overlay .uc-buttons a:hover\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_slider\",\"title\":\"Button Radius\",\"name\":\"button_radius\",\"description\":\"\",\"default_value\":\"30\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc-buttons a\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_slider\",\"title\":\"Button Radius\",\"name\":\"button_radius_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"30\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-img-overlay .uc-buttons a\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_slider\",\"title\":\"Buttons Spacing\",\"name\":\"buttons_spacing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"10\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc-buttons\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_slider\",\"title\":\"Buttons Spacing\",\"name\":\"buttons_spacing_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-img-overlay .uc-buttons\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_typography\",\"title\":\"Sale Price Typography\",\"name\":\"sale_price_typography\",\"description\":\"\",\"selector1\":\".uc_sale_price\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_jzrqsfhj\"},{\"type\":\"uc_colorpicker\",\"title\":\"Sale Price Color\",\"name\":\"sale_price_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".uc_sale_price\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_jzrqsfhj\"},{\"type\":\"uc_typography\",\"title\":\"Title Typography\",\"name\":\"title_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"selector1\":\".product-text-name\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_hy0hdail\"},{\"type\":\"uc_colorpicker\",\"title\":\"Title Color\",\"name\":\"title_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".product-text-name\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_hy0hdail\"},{\"type\":\"uc_slider\",\"title\":\"Title Spacing\",\"name\":\"title_spacing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-text-name\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_hy0hdail\"},{\"type\":\"uc_slider\",\"title\":\"Button Space Between\",\"name\":\"button_space_between\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_btn_spacer\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Labels\",\"name\":\"show_labels\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_dlqpcwsz\"},{\"type\":\"uc_textfield\",\"title\":\"Sale Label Start Text\",\"name\":\"sale_label\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_labels\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"Sale\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_content_dlqpcwsz\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Sale Precent in Label\",\"name\":\"show_sale_precent_in_label\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_labels\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_dlqpcwsz\"},{\"type\":\"uc_textfield\",\"title\":\"Sale Label End Text\",\"name\":\"sale_label_end_text\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_labels\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"Off\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_content_dlqpcwsz\"},{\"type\":\"uc_colorpicker\",\"title\":\"Sale Label Background Color\",\"name\":\"sale_label_background_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#dcdcdc\",\"selector\":\".ue_woocommerce_product_list_badge\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_colorpicker\",\"title\":\"Out of Stock Label Background Color\",\"name\":\"out_of_stock_label_background_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#FF7276\",\"selector\":\".ue_woocommerce_product_grid_out_of_stock_label\",\"selector_value\":\"background-color: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_colorpicker\",\"title\":\"Labels Color\",\"name\":\"labels_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".ue_woocommerce_product_label\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_typography\",\"title\":\"Labels Typography\",\"name\":\"labels_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue_woocommerce_product_label\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_padding\",\"title\":\"Labels Padding\",\"name\":\"labels_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"5\",\"desktop_right\":\"5\",\"desktop_bottom\":\"5\",\"desktop_left\":\"5\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_woocommerce_product_label\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Labels Radius\",\"name\":\"labels_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":false,\"desktop_top\":\"5\",\"desktop_right\":\"5\",\"desktop_bottom\":\"5\",\"desktop_left\":\"5\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_woocommerce_product_label\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_border\",\"title\":\"Labels Border\",\"name\":\"labels_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue_woocommerce_product_label\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_slider\",\"title\":\"Labels Spacing\",\"name\":\"labels_spacing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_woocommerce_product_label\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_number\",\"title\":\"Grid Columns\",\"name\":\"grid_columns\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"1\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-list\",\"selector_value\":\"grid-template-columns: repeat({{VALUE}}, 1fr);\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_l0h526bc\"},{\"type\":\"uc_slider\",\"title\":\"Grid Gap\",\"name\":\"grid_gap\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-list\",\"selector_value\":\"grid-gap: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_content_l0h526bc\"},{\"type\":\"uc_dropdown\",\"title\":\"Image Fit\",\"name\":\"image_fit\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Cover\":\"cover\",\"Contain\":\"contain\"},\"default_value\":\"cover\",\"selector\":\".product-img img\",\"selector_value\":\"object-fit: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_uj97soov\"},{\"type\":\"uc_colorpicker\",\"title\":\"Overlay Color\",\"name\":\"overlay_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"rgba(0, 0, 0, 0.30)\",\"selector\":\".product-img-overlay\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_cnp47qg0\"},{\"type\":\"uc_slider\",\"title\":\"Overlay Opacity\",\"name\":\"overlay_opacity\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-img-overlay\",\"selector_value\":\"opacity: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_cnp47qg0\"},{\"type\":\"uc_slider\",\"title\":\"Overlay Opacity Hover\",\"name\":\"overlay_opacity_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"100\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-items:hover .product-img-overlay\",\"selector_value\":\"opacity: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_cnp47qg0\"},{\"type\":\"uc_boxshadow\",\"title\":\"Item Shadow\",\"name\":\"item_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Normal\",\"selector\":\"li.product-items\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_border\",\"title\":\"Image Border\",\"name\":\"image_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".product-img\",\"__attr_catid__\":\"cat_style_uj97soov\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Product Button\",\"name\":\"show_product_button\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_dropdown\",\"title\":\"Product Button Type\",\"name\":\"product_button_type\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_product_button\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"In Content\":\"content\",\"Image Overlay\":\"image_overlay\"},\"default_value\":\"image_overlay\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_special\",\"title\":\"Dynamic Popup Select\",\"name\":\"dynamic_popup_select\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_product_button\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"attribute_type\":\"dynamic_popup\",\"entrance_animation_item_class\":\"\",\"schema_title_name\":\"\",\"schema_content_name\":\"\",\"image_size_param_name\":\"\",\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_padding\",\"title\":\"Overlay Padding\",\"name\":\"overlay_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"is_responsive\":false,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".product-img-overlay\",\"__attr_catid__\":\"cat_style_cnp47qg0\"},{\"type\":\"uc_dropdown\",\"title\":\"Button Type\",\"name\":\"button_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Inline\":\"inline-block\",\"Block\":\"block\"},\"default_value\":\"inline-block\",\"selector\":\".uc-buttons a\",\"selector_value\":\"display:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_3ji66j2s\"},{\"type\":\"uc_dropdown\",\"title\":\"Button Type\",\"name\":\"button_type_copy\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Inline\":\"inline-block\",\"Block\":\"block\"},\"default_value\":\"inline-block\",\"selector\":\".product-img-overlay .uc-buttons a\",\"selector_value\":\"display:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_acfznylj\"},{\"type\":\"uc_dropdown\",\"title\":\"Vertical Alignment\",\"name\":\"vertical_alignment\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Top\":\"flex-start\",\"Middle\":\"center\",\"Bottom\":\"flex-end\"},\"default_value\":\"center\",\"selector\":\".product-img-overlay\",\"selector_value\":\"justify-content:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_cnp47qg0\"},{\"type\":\"uc_dropdown\",\"title\":\"Cart Button\",\"name\":\"cart_button\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Hide\":\"\",\"In Content\":\"content\",\"Image Overlay\":\"image_overlay\"},\"default_value\":\"content\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_icon_library\",\"title\":\"Product Icon\",\"name\":\"product_icon\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"fas fa-eye\",\"enable_svg\":true,\"put_svg_as\":\"svg\",\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_icon_library\",\"title\":\"Cart Icon\",\"name\":\"cart_icon\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"fas fa-shopping-cart\",\"enable_svg\":true,\"put_svg_as\":\"svg\",\"__attr_catid__\":\"cat_content_yvfwlhii\"},{\"type\":\"uc_dropdown\",\"title\":\"Labels\",\"name\":\"badge\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_labels\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"In Content\":\"content\",\"On Image\":\"image\"},\"default_value\":\"content\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_dlqpcwsz\"},{\"type\":\"uc_dropdown\",\"title\":\"Labels Vertical Snap\",\"name\":\"vertical_snap\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"badge\",\"condition_operator\":\"equal\",\"condition_value\":[\"image\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Bottom\":\"bottom\"},\"default_value\":\"top\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_number\",\"title\":\"Labels Vertical Distance\",\"name\":\"label_vertical_distance\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"badge\",\"condition_operator\":\"equal\",\"condition_value\":[\"image\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_dropdown\",\"title\":\"Labels Horizontal Snap\",\"name\":\"horizontal_snap\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"badge\",\"condition_operator\":\"equal\",\"condition_value\":[\"image\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"left\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_number\",\"title\":\"Labels Horizontal Distance\",\"name\":\"label_horizontal_distance\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"badge\",\"condition_operator\":\"equal\",\"condition_value\":[\"image\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_colorpicker\",\"title\":\"Rating Color\",\"name\":\"rating_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"#ffcb00\",\"selector\":\".product-rating\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_mu814zf3\"},{\"type\":\"uc_slider\",\"title\":\"Rating Size\",\"name\":\"rating_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"14\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-rating\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_mu814zf3\"},{\"type\":\"uc_slider\",\"title\":\"Rating Spacing\",\"name\":\"rating_spacing\",\"description\":\"Margin Top\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"5\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-rating\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_mu814zf3\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Rating\",\"name\":\"show_rating\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_hr\",\"title\":\"Hr before enable\",\"name\":\"br_before_enable\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Labels Min Width\",\"name\":\"labels_min_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"200\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_woocommerce_product_label\",\"selector_value\":\"min-width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_slider\",\"title\":\"Labels Min Height\",\"name\":\"labels_min_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"200\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_woocommerce_product_label\",\"selector_value\":\"min-height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_qy4byy0e\"},{\"type\":\"uc_colorpicker\",\"title\":\"Description Color\",\"name\":\"description_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#969696\",\"selector\":\".product-short-description\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_u1e041tg\"},{\"type\":\"uc_typography\",\"title\":\"Description Typography\",\"name\":\"description_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"selector1\":\".product-short-description\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_u1e041tg\"},{\"type\":\"uc_slider\",\"title\":\"Description Spacing\",\"name\":\"description_spacing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".product-short-description\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_u1e041tg\"},{\"type\":\"uc_hr\",\"title\":\"Hr after enable\",\"name\":\"br_after_enable\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Collapse On Mobile\",\"name\":\"collapse_on_mobile\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Collapse From Resolution\",\"name\":\"collapse_from_resolution\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"collapse_on_mobile\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"label_block\":false,\"default_value\":\"420\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_typography\",\"title\":\"Category Typography\",\"name\":\"category_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"selector1\":\".ue-product-category\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_3rupphtg\"},{\"type\":\"uc_colorpicker\",\"title\":\"Category Color \",\"name\":\"category_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#8c8c8c\",\"selector\":\".ue-product-category a\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_3rupphtg\"},{\"type\":\"uc_slider\",\"title\":\"Category Spacing\",\"name\":\"category_spacing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-product-category\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_3rupphtg\"},{\"type\":\"uc_dropdown\",\"title\":\"Text Align\",\"name\":\"text_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Normal\",\"options\":{\"Inherit\":\"inherit\",\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"inherit\",\"selector\":\".product-items\",\"selector_value\":\"text-align:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_typography\",\"title\":\"Message Typography\",\"name\":\"message_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue-no-posts-found\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_colorpicker\",\"title\":\"Message Color\",\"name\":\"message_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".ue-no-posts-found\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_colorpicker\",\"title\":\"Message Background\",\"name\":\"message_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#e8e8e8\",\"selector\":\".ue-no-posts-found\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Messsage Radius\",\"name\":\"messsage_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-no-posts-found\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_padding\",\"title\":\"Message Padding\",\"name\":\"message_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"20\",\"desktop_right\":\"20\",\"desktop_bottom\":\"20\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-no-posts-found\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_margins\",\"title\":\"Message Margin\",\"name\":\"message_margin\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-no-posts-found\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_border\",\"title\":\"Message Border\",\"name\":\"message_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"solid\",\"border_color\":\"#c4c4c4\",\"width_desktop_top\":\"1\",\"width_desktop_right\":\"1\",\"width_desktop_bottom\":\"1\",\"width_desktop_left\":\"1\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-no-posts-found\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Empty Message\",\"name\":\"show_empty_message\",\"description\":\"Show empty message when no products answer the query.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_textfield\",\"title\":\"Empty Message\",\"name\":\"no_posts_found\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_empty_message\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"No products found\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_image\",\"title\":\"Default Image\",\"name\":\"empty_image_placeholder\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"media_type\":\"image\",\"default_value\":\"[url_assets]\\/placeholder.jpeg\",\"add_image_sizes\":false,\"default_value_json\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_textfield\",\"title\":\"Out of Stock Text\",\"name\":\"out_of_stock_text\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_labels\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"Out of Stock\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_content_dlqpcwsz\"},{\"type\":\"uc_special\",\"title\":\"Sequence Entrance Animation\",\"name\":\"sequence_entrance_animation\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"attribute_type\":\"entrance_animation\",\"entrance_animation_item_class\":\"product-items\",\"schema_title_name\":\"\",\"schema_content_name\":\"\",\"image_size_param_name\":\"\",\"__attr_catid__\":\"cat_content_5ck08ujs\"},{\"type\":\"uc_listing\",\"title\":\"Remote Parent\",\"name\":\"remote_parent\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"remote\",\"gallery_enable_video\":false,\"enable_pagination\":false,\"enable_ajax\":false,\"multisource_included_attributes\":\"\",\"multisource_attributes_defaults\":\"\",\"remote_type\":\"parent\",\"controller_more_parents\":false,\"__attr_catid__\":\"cat_content_d6jwnyeu\"},{\"type\":\"uc_colorpicker\",\"title\":\"Item Background Active\",\"name\":\"item_background_active\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Active\",\"default_value\":\"\",\"selector\":\".product-items.ue-active-item\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_border\",\"title\":\"Item Border Active\",\"name\":\"item_border_active\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Active\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".product-items.ue-active-item\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_boxshadow\",\"title\":\"Item Shadow Active\",\"name\":\"item_shadow_active\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"Active\",\"selector\":\".product-items.ue-active-item\",\"__attr_catid__\":\"cat_style_lach220c\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Third Party Integrations\",\"name\":\"enable_third_party_integrations\",\"description\":\"Enable integrations for third party plugins. Example: Advanced Labels for WooCommerce\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable hook: before_shop_loop_item\",\"name\":\"before_shop_loop_item\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable hook: before_shop_loop_item_title\",\"name\":\"before_shop_loop_item_title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable hook: after_shop_loop_item_title\",\"name\":\"after_shop_loop_item_title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable hook: after_shop_loop_item\",\"name\":\"after_shop_loop_item\",\"description\":\"Enable hooks to show data from other plugins.\\nExample: Variation Swatches for WooCommerce.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Label From \\\"Custom Field\\\"\",\"name\":\"show_label_from_custom_field_\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_dlqpcwsz\"},{\"type\":\"uc_textfield\",\"title\":\"Custom Field Name\",\"name\":\"custom_field_name\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_label_from_custom_field_\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_content_dlqpcwsz\"},{\"type\":\"uc_dropdown\",\"title\":\"Custom Field Width Type\",\"name\":\"custom_field_width_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Auto Width\":\"inline-block\",\"Full Width\":\"block\"},\"default_value\":\"inline-block\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"selector_value\":\"display: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_slider\",\"title\":\"Custom Field Min Width\",\"name\":\"custom_field_min_width\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"100\",\"min\":\"0\",\"max\":\"500\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_dropdown\",\"title\":\"Custom Field Text Align\",\"name\":\"custom_field_text_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"selector_value\":\"text-align: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_colorpicker\",\"title\":\"Custom Field Label Background Color\",\"name\":\"custom_field_label_background_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"show_label_from_custom_field_\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"selector_value\":\"background-color: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_padding\",\"title\":\"Custom Field Label Padding\",\"name\":\"custom_field_label_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"show_label_from_custom_field_\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_slider\",\"title\":\"Custom Field Label Spacing\",\"name\":\"custom_field_label_spacing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_colorpicker\",\"title\":\"Custom Field Label Color\",\"name\":\"custom_field_label_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"show_label_from_custom_field_\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"selector_value\":\"color: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Custom Field Border Radius\",\"name\":\"custom_field_border_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_border\",\"title\":\"Custom Field Border\",\"name\":\"custom_field_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue_woocommerce_product_label-custom-field\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_typography\",\"title\":\"Custom Field Typography\",\"name\":\"custom_field_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue_woocommerce_product_label-custom-field\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_21ay21hr\"},{\"type\":\"uc_dropdown\",\"title\":\"Layout Type\",\"name\":\"layout_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Column\":\"block\",\"Row\":\"flex\"},\"default_value\":\"block\",\"selector\":\".product-text\",\"selector_value\":\"display: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Title\",\"name\":\"title\",\"description\":\"\",\"default_value\":\"\",\"limited_edit\":\"true\"}],\"includes\":{\"js\":[],\"jslib\":[\"jquery\",\"font-awsome\"],\"css\":[]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"id\":\"cat_content_l0h526bc\",\"title\":\"Grid\",\"tab\":\"content\"},{\"id\":\"cat_content_yvfwlhii\",\"title\":\"Buttons\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_dlqpcwsz\",\"title\":\"Labels\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_d6jwnyeu\",\"title\":\"Connected Widgets Settings\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_5ck08ujs\",\"title\":\"Sequence Entrance Animation\",\"tab\":\"content\"},{\"params\":[{\"type\":\"uc_radioboolean\",\"title\":\"Enable Third Party Integrations\",\"name\":\"enable_third_party_integrations\",\"description\":\"Enable integrations for third party plugins. Example: Advanced Labels for WooCommerce\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable hook: before_shop_loop_item\",\"name\":\"before_shop_loop_item\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable hook: before_shop_loop_item_title\",\"name\":\"before_shop_loop_item_title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable hook: after_shop_loop_item_title\",\"name\":\"after_shop_loop_item_title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable hook: after_shop_loop_item\",\"name\":\"after_shop_loop_item\",\"description\":\"Enable hooks to give access to other plugins.\\nExample: Variation Swatches for WooCommerce.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ipq4hmg2\"}],\"expire\":1695156393189,\"id\":\"cat_content_ipq4hmg2\",\"title\":\"Third Party Integrations\",\"tab\":\"content\"},{\"id\":\"cat_style_lach220c\",\"title\":\"Item\",\"tab\":\"style\"},{\"id\":\"cat_style_uj97soov\",\"title\":\"Image\",\"tab\":\"style\"},{\"id\":\"cat_style_cnp47qg0\",\"title\":\"Image Overlay\",\"tab\":\"style\"},{\"id\":\"cat_style_hy0hdail\",\"title\":\"Title\",\"tab\":\"style\"},{\"id\":\"cat_style_3rupphtg\",\"title\":\"Category\",\"tab\":\"style\"},{\"id\":\"cat_style_u1e041tg\",\"title\":\"Short Description\",\"tab\":\"style\"},{\"id\":\"cat_style_jzrqsfhj\",\"title\":\"Prices\",\"tab\":\"style\"},{\"id\":\"cat_style_3ji66j2s\",\"title\":\"Buttons\",\"tab\":\"style\"},{\"id\":\"cat_style_acfznylj\",\"title\":\"Overlay Buttons\",\"tab\":\"style\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_qy4byy0e\",\"title\":\"Labels\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"show_label_from_custom_field_\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_21ay21hr\",\"title\":\"Custom Field Label\",\"tab\":\"style\"},{\"id\":\"cat_style_mu814zf3\",\"title\":\"Rating\",\"tab\":\"style\"},{\"params\":[{\"type\":\"uc_typography\",\"title\":\"Message Typography\",\"name\":\"message_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue-no-posts-found\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_colorpicker\",\"title\":\"Message Color\",\"name\":\"message_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".ue-no-posts-found\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_colorpicker\",\"title\":\"Message Background\",\"name\":\"message_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#e8e8e8\",\"selector\":\".ue-no-posts-found\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Messsage Radius\",\"name\":\"messsage_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-no-posts-found\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_padding\",\"title\":\"Message Padding\",\"name\":\"message_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"20\",\"desktop_right\":\"20\",\"desktop_bottom\":\"20\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-no-posts-found\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_margins\",\"title\":\"Message Margin\",\"name\":\"message_margin\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-no-posts-found\",\"__attr_catid__\":\"cat_style_mue3jl0c\"},{\"type\":\"uc_border\",\"title\":\"Message Border\",\"name\":\"message_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"solid\",\"border_color\":\"#c4c4c4\",\"width_desktop_top\":\"1\",\"width_desktop_right\":\"1\",\"width_desktop_bottom\":\"1\",\"width_desktop_left\":\"1\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-no-posts-found\",\"__attr_catid__\":\"cat_style_mue3jl0c\"}],\"expire\":1649865906251,\"id\":\"cat_style_mue3jl0c\",\"title\":\"Empty Message\",\"tab\":\"style\"}]}", "1", "1", NULL, NULL, NULL);
INSERT INTO `ethr_addonlibrary_addons` VALUES("2", "Card Carousel", "card_carousel_elementor", "card_carousel", "elementor", "Use the card carousel widget to display two or more pieces of content in a carousel format. Create any kind of carousel you can think about.", "1", "{\"html\":\"<div class=\\\"uc_classic_carousel\\\" id=\\\"{{uc_id}}-wrapper\\\">\\n        <div class=\\\"uc_carousel owl-carousel uc-items-wrapper {{remote_parent.class}} {{uc_filtering_addclass}}\\\" id=\\\"{{uc_id}}\\\" {{remote_parent.attributes|raw}} {{uc_filtering_attributes|raw}}>\\n          \\t{{put_items()}}\\n      <\\/div>\\n<\\/div>\",\"html_item\":\"<div id=\\\"{{item.item_id}}\\\" class=\\\"uc_classic_carousel_container_holder ue-item {{item.item_repeater_class}}\\\" data-hide-item=\\\"{{item.hide_item}}\\\">\\n  <div class=\\\"ue-carousel-item\\\">\\n  {% if show_top_decoration == \\\"true\\\" %}<span class=\\\"uc_classic_carousel_border\\\" style=\\\"\\\"><\\/span>{% endif %}\\n  {% if show_image == \\\"true\\\" %}\\n  <div class=\\\"uc_classic_carousel_placeholder\\\">\\n    {% if image_link == \\\"true\\\" %}<a href=\\\"{{item.link}}\\\" title=\\\"{{item.btn_text}}\\\" {{item.link_html_attributes|raw}}>{% endif %}\\n      <img src=\\\"{{item.image}}\\\" {{item.image_attributes|raw}}>\\n    {% if image_link == \\\"true\\\" %}<\\/a>{% endif %}\\n    {% if enable_img_overlay == \\\"true\\\" %}<div class=\\\"ue_card_carousel_image_overlay\\\"><\\/div>{% endif %}\\n  <\\/div>\\n  {% endif %}\\n  <div class=\\\"uc_classic_carousel_content\\\" style=\\\"direction:{{direction}};\\\">\\n    \\n    \\n    {% if show_icon == \\\"true\\\" %}\\n      <div class=\\\"ue-item-icon-wrapper\\\">\\n         <div class=\\\"ue-item-icon\\\">{{item.icon_html|raw}}<\\/div>\\n      <\\/div>\\n    {% endif %}\\n    \\n    {% if show_title == \\\"above\\\" %}\\n      {% if title_link == \\\"true\\\" %}<a href=\\\"{{item.link}}\\\" {{item.link_html_attributes|raw}}>{% endif %}\\t\\n      <{{title_html_tag}}  class=\\\"card_carousel_title\\\">{{item.title|raw}}<\\/{{title_html_tag}}>\\n      {% if title_link == \\\"true\\\" %}<\\/a>{% endif %}\\n    {% endif %}\\t\\n    \\n      \\n    {% if show_text == \\\"true\\\" %}<p class=\\\"card_carousel_text\\\">{{item.content|raw}}<\\/p>{% endif %}\\n    \\n    \\n    {% if show_title == \\\"under\\\" %}\\n      {% if title_link == \\\"true\\\" %}<a href=\\\"{{item.link}}\\\" {{item.link_html_attributes|raw}}>{% endif %}\\t\\n      <{{title_html_tag}}  class=\\\"card_carousel_title\\\">{{item.title|raw}}<\\/{{title_html_tag}}>\\n      {% if title_link == \\\"true\\\" %}<\\/a>{% endif %}\\n    {% endif %}\\t\\n    \\n    \\n    {% if show_button == \\\"true\\\" %}\\n    \\t{% if item.btn_text|raw is empty %}\\n              <div class=\\\"ue_button\\\"><a class=\\\"uc_more_btn {{button_hover_animation}}\\\" href=\\\"{{item.link}}\\\" title=\\\"{{item.btn_text}}\\\" {{item.link_html_attributes|raw}}>{{button_text|raw}}<\\/a><\\/div>\\n        {% else %} \\n              <div class=\\\"ue_button\\\"><a class=\\\"uc_more_btn {{button_hover_animation}}\\\" href=\\\"{{item.link}}\\\" title=\\\"{{item.btn_text}}\\\" {{item.link_html_attributes|raw}}>{{item.btn_text|raw}}<\\/a><\\/div>\\n        {% endif %}\\t    \\n    {% endif %}\\t\\n  <\\/div>\\n  <\\/div>\\n<\\/div>\",\"css\":\"#{{uc_id}}-wrapper\\n{\\n  min-height:1px;\\n}\\n#{{uc_id}} *{\\n\\t-webkit-box-sizing: border-box;\\n\\t-moz-box-sizing: border-box;\\n\\tbox-sizing: border-box;\\n}\\n\\n#{{uc_id}} .ue-carousel-item\\n{\\n  overflow:hidden;\\n  transition:0.3s;\\n}\\n\\n#{{uc_id}} .uc_classic_carousel_container_holder\\n{\\n\\tdisplay:block;\\n\\tposition:relative;\\n\\twidth:100%;\\n    box-sizing: border-box;\\n}\\n#{{uc_id}} .uc_classic_carousel_placeholder{\\n   position:relative;\\n}\\n\\n{% if enable_img_overlay == \\\"true\\\" %}\\n#{{uc_id}} .ue_card_carousel_image_overlay\\n{\\n  position:absolute;\\n  top:0;\\n  bottom:0;\\n  left:0;\\n  right:0;\\n  transition:0.3s;\\n}\\n{% endif %}\\n#{{uc_id}} .uc_classic_carousel_placeholder img, #{{uc_id}} .ue_card_carousel_image_overlay\\n{\\n  transition: all 300ms;\\n}\\n\\n.card_carousel_title\\n{\\n\\tfont-size:21px;\\n}\\n\\n.uc_classic_carousel .uc_classic_carousel_border\\n{\\n\\tdisplay:block;\\n    margin:0 auto;\\n}\\n\\n.uc_classic_carousel  .uc_classic_carousel_placeholder img\\n{\\n\\twidth:100%;\\n    \\n    display:inline-flex;\\n}\\n.uc_classic_carousel .uc_classic_carousel_content\\n{\\n  display: flex;\\n flex-flow: column nowrap;\\n}\\n\\n.uc_classic_carousel .ue_button\\n{\\n  margin-top:auto;\\n\\n}\\n\\n.uc_classic_carousel .uc_classic_carousel_content .uc_more_btn {\\n\\tdisplay:inline-block;\\n\\ttext-decoration:none;\\n\\ttransition: all 0.5s ease;\\n}\\n\\n\\n#{{uc_id}} .owl-dots {\\noverflow:hidden;\\ntext-align:{{dot_alignment}};\\n}\\n\\n#{{uc_id}} .owl-dot {\\nborder-radius:50%;\\ndisplay:inline-block;\\n}\\n\\n#{{uc_id}} .owl-nav .owl-prev,\\n#{{uc_id}} .owl-nav .owl-next{\\n    position:absolute;\\n    display:flex;\\n  \\tjustify-content: center;\\n  \\talign-items: center;\\n    text-align:center;\\n}\\n\\n\\n#{{uc_id}} .owl-nav .disabled\\n{\\n    display: none;  \\n}\\n\\n\\n#{{uc_id}} .ue-item-icon\\n{\\n  line-height:1em;\\n  display:inline-flex;\\n  justify-content:center;\\n  align-items:center;\\n  \\n}\\n\\n#{{uc_id}} .ue-item-icon svg\\n{\\n  height:1em;\\n  width:1em;\\n}\\n\\n#{{uc_id}} .ue-item-icon-wrapper\\n{\\n  display:flex;\\n}\\n\\n#{{uc_id}} .uc_classic_carousel_container_holder {\\n\\t max-width: {{item_width}};\\n}\\n\\n\\n{% if transition_easing == \\\"false\\\" %}\\n\\t#{{uc_id}} .owl-stage\\n        {\\n            transition-timing-function: linear!important;\\n        }\\n{% endif %}\\n\\n@media screen and (max-width: 1024px) {\\n  #{{uc_id}} .uc_classic_carousel_container_holder {\\n\\t max-width: {{item_width_tablet}};\\n  }\\n}\\n\\n@media screen and (max-width: 767px) {\\n  #{{uc_id}} .uc_classic_carousel_container_holder {\\n    max-width: {{item_width_mobile}};\\n  }\\n}\",\"js\":\"jQuery(document).ready(function(){\\t\\n  function {{uc_id}}_start(){\\n      \\n    var objCarousel = jQuery(\'#{{uc_id}}\');\\n    \\n    function hideIndividualItems(){\\n    \\t\\n      var objItems = objCarousel.find(\\\".uc_classic_carousel_container_holder\\\");\\n      \\n      if(!objItems)\\n        return(false);\\n      \\n      objItems.each(function(){\\n      \\n      \\tvar objItem = jQuery(this);\\n        var dataHide = objItem.data(\\\"hide-item\\\");\\n        \\n        if(dataHide == true)          \\n        objItem.remove();\\n      \\n      });\\n    \\t\\n    \\n    }\\n    \\n    {# \\n    function fixSafariEconBug(){\\n  \\n         \\/\\/first parent needs to be display block\\n         var objEconParents = objCarousel.parents(\\\".e-con\\\");\\n  \\n         if(!objEconParents.length)\\n         return(false);\\n  \\n         objEconParents.each(function(index, item){\\n  \\n           var objEconParent = jQuery(this);\\n  \\n           \\/\\/only first parent\\n           if(index != 0)\\n           return(true);\\n  \\n           objEconParent.css(\'display\', \'block\');\\n  \\n         });\\n                  \\n    }\\n    #}\\n    \\n    function initCarousel(){\\n      \\n      {# fixSafariEconBug(); #}      \\n      \\n      \\/\\/hide individual items if needed \\n      hideIndividualItems(); \\n    \\n      objCarousel.owlCarousel({\\n                loop: {{loop}},\\n                rtl:{{rtl}},\\n                autoplay:{{autoplay}},\\n                paddingType: \\\"{{stage_padding_type}}\\\",    \\n                autoplayHoverPause:{{autoplayhoverpause}},\\n                navText : [\\\"{{left_arrow_html|raw}}\\\",\\\"{{right_arrow_html|raw}}\\\"],\\n                nav: {{show_arrows}},\\n                rewindNav : false,\\n                center:{{center}},\\n                mouseDrag:{{mouse_drag}},\\n                touchDrag:{{touch_drag}},                    \\n                setActiveClassOnMobile:{{active_on_mobile}},\\n                changeItemOnClick:{{scroll_on_click}},\\n                autoplayTimeout:{{autoplay_interval}},\\n                smartSpeed: {{transition_speed}},  \\n                dots:{{show_bullets}},\\n                shuffle:{{shuffle}},\\n                scrollToHead:{{scroll_to_head}},\\n                scrollToHeadOffset: {{scroll_to_head_offset}},\\n                autoWidth: {{auto_width}},\\n                mousewheelControl: {{enable_mouse_wheel_control}},\\n                \\n                {% if carousel_animation == \\\"fadeIn\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"fadeOut\\\",    \\t\\t \\n                {% endif %}\\n  \\n                {% if carousel_animation == \\\"fadeInLeft\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"fadeOutRight\\\",    \\t\\t \\n                {% endif %}\\n  \\n                {% if carousel_animation == \\\"fadeInRight\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"fadeOutLeft\\\",    \\t\\t \\n                {% endif %}\\t\\n  \\n                {% if carousel_animation == \\\"fadeInUp\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"fadeOutUp\\\",    \\t\\t \\n                {% endif %}\\n  \\n                {% if carousel_animation == \\\"fadeInDown\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"fadeOutDown\\\",    \\t\\t \\n                {% endif %}   \\n  \\n                {% if carousel_animation == \\\"slideInLeft\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"slideOutRight\\\",    \\t\\t \\n                {% endif %}\\n  \\n                {% if carousel_animation == \\\"slideInRight\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"slideOutLeft\\\",    \\t\\t \\n                {% endif %}\\n  \\n                {% if carousel_animation == \\\"slideInUp\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"slideOutUp\\\",    \\t\\t \\n                {% endif %}\\t  \\n  \\n                {% if carousel_animation == \\\"slideInDown\\\" %}\\n                animateIn: \\\"{{carousel_animation}}\\\",                    \\n                animateOut: \\\"slideOutDown\\\",    \\t\\t \\n                {% endif %}\\t               \\n                              \\n                responsive: {\\n  \\n                       0 : {\\n                            items:{{number_of_items_mobile}},\\n                            slideBy: {{slides_to_scroll_mobile}},\\n                            scrollToHeadForceOnMobile: {{scroll_to_head_forced_on_mobile}},        \\n                            margin:{{margin_between_slides_mobile}},\\n                            {% if center == \\\"false\\\" %}\\n                                dotsEach: {{show_dots_each_x_item_mobile}},\\n                            {% endif %}\\t\\n  \\n                            {% if stage_padding_type != \\\"none\\\" %}\\n                                 stagePadding: {{stage_padding_mobile}},\\n                            {% endif %}\\t        \\n                        },\\n                        768 : {\\n                            items:{{number_of_items_tablet}},\\n                            slideBy: {{slides_to_scroll_tablet}},\\n                            margin:{{margin_between_slides_tablet}},\\n                            {% if center == \\\"false\\\" %}\\n                                dotsEach: {{show_dots_each_x_item_tablet}},\\n                            {% endif %}\\t\\n  \\n                            {% if stage_padding_type != \\\"none\\\" %}\\n                                 stagePadding: {{stage_padding_tablet}},\\n                            {% endif %}\\t        \\n                        },\\n                        980 : {\\n                            items:{{number_of_items}},\\n                            slideBy: {{slides_to_scroll}},\\n                            margin:{{margin_between_slides}},\\n                            {% if center == \\\"false\\\" %} \\n                                dotsEach: {{show_dots_each_x_item}},\\n                            {% endif %}\\t\\n  \\n                            {% if stage_padding_type != \\\"none\\\" %}\\n                                 stagePadding: {{stage_padding}},\\n                            {% endif %}\\t        \\n                        }  \\n                }\\n      });\\n           \\n    }\\n    \\n    initCarousel();\\n    \\n    objCarousel.on(\\\"uc_ajax_refreshed\\\",function(){      \\n         objCarousel.trigger(\'destroy.owl.carousel\');      \\n          initCarousel();      \\n    });  \\n    \\n    {{ucfunc(\\\"put_remote_parent_js\\\",\\\"objCarousel\\\")}}  \\n    \\n}if(jQuery(\\\"#{{uc_id}}\\\").length) {{uc_id}}_start();\\n  jQuery( document ).on( \'elementor\\/popup\\/show\', (event, id, objPopup) => { \\n  if(objPopup.$element.has(jQuery(\\\"#{{uc_id}}\\\")).length) {{uc_id}}_start();});\\t\\n});\"}", "{\"options\":{\"enable_items\":\"true\",\"items_section_title\":\"\",\"items_section_heading\":\"\",\"items_title_field\":\"\",\"path_assets\":\"uc_classic_carousel\",\"js_as_module\":false,\"addon_icon\":\"fas fa-arrows-alt-h\",\"dynamic_addon\":\"false\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"Use the card carousel widget to display two or more pieces of content in a carousel format. Create any kind of carousel you can think about.\",\"link_resource\":\"https:\\/\\/youtu.be\\/hOkFaSpUHk0\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/card-carousel-widget-for-elementor\\/\",\"show_small_icon\":\"true\",\"preview_size\":\"full\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"special\":\"\",\"special_data\":\"\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_radioboolean\",\"title\":\"Loop\",\"name\":\"loop\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"true\"},{\"type\":\"uc_number\",\"title\":\"Number of items\",\"name\":\"number_of_items\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"auto_width\",\"condition_operator\":\"equal\",\"condition_value\":[\"\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"1\",\"max_value\":\"20\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"2\",\"default_value_mobile\":\"1\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Slides To Scroll\",\"name\":\"slides_to_scroll\",\"description\":\"Don\'t leave empty\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"1\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"1\",\"default_value_mobile\":\"1\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Transition Speed\",\"name\":\"transition_speed\",\"description\":\"\",\"default_value\":\"1000\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"1000\"},{\"type\":\"uc_number\",\"title\":\"Margin between slides\",\"name\":\"margin_between_slides\",\"description\":\"Do not keep this empty\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"30\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"20\",\"default_value_mobile\":\"20\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Stage Padding Type\",\"name\":\"stage_padding_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"None\":\"none\",\"Both\":\"both\",\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"none\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Stage Padding\",\"name\":\"stage_padding\",\"description\":\"To create offset on sides\",\"enable_condition\":true,\"condition_attribute\":\"stage_padding_type\",\"condition_operator\":\"not_equal\",\"condition_value\":[\"none\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"0\",\"default_value_mobile\":\"0\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Autoplay\",\"name\":\"autoplay\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"true\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Arrows \",\"name\":\"show_arrows\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\",\"value\":\"true\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Bullets\",\"name\":\"show_bullets\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_number\",\"title\":\"Autoplay Interval\",\"name\":\"autoplay_interval\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"autoplay\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3000\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Autoplay Hover Pause\",\"name\":\"autoplayhoverpause\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"autoplay\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Align\",\"name\":\"align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Center\":\"center\",\"Left\":\"left\",\"Right\":\"right\",\"Justify\":\"justify\"},\"default_value\":\"center\",\"selector\":\".ue-carousel-item\",\"selector_value\":\"text-align:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Title Spacing\",\"name\":\"title_spacing\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".card_carousel_title\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_aohl5oww\",\"value\":\"0\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Text Spacing\",\"name\":\"text_spacing\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".card_carousel_text\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_lhmeogkk\",\"value\":\"10\"},{\"type\":\"uc_typography\",\"title\":\"Button Typography\",\"name\":\"button_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"selector1\":\".uc_more_btn\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_hover_animations\",\"title\":\"Button Hover Animation\",\"name\":\"button_hover_animation\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_padding\",\"title\":\"Button Padding\",\"name\":\"button_padding\",\"description\":\"\",\"is_responsive\":false,\"desktop_top\":\"10\",\"desktop_right\":\"20\",\"desktop_bottom\":\"10\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc_more_btn\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":{\"top\":\"10\",\"right\":\"20\",\"bottom\":\"10\",\"left\":\"20\",\"unit\":\"px\"}},{\"type\":\"uc_slider\",\"title\":\"Button Radius\",\"name\":\"button_radius\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_more_btn\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"5\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Background Color\",\"name\":\"button_bg_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"#d3d3d3\",\"selector\":\".uc_more_btn\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Background Color Hover\",\"name\":\"button_background_color_hover\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".uc_more_btn:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"#000000\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Text Color\",\"name\":\"btn_txt_clr\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".uc_more_btn\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"#000000\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Text Color Hover\",\"name\":\"btn_txt_clr_hvr\",\"description\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".uc_more_btn:hover\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"#ffffff\"},{\"type\":\"uc_radioboolean\",\"title\":\"Text Direction\",\"name\":\"direction\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"ltr\",\"true_name\":\"ltr\",\"true_value\":\"ltr\",\"false_name\":\"rtl\",\"false_value\":\"rtl\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"ltr\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Image Radius\",\"name\":\"image_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc_classic_carousel_placeholder img\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_slider\",\"title\":\"Image Height\",\"name\":\"image_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"200\",\"min\":\"1\",\"max\":\"500\",\"step\":\"1\",\"units\":\"px_vh_percent\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_placeholder img\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_slider\",\"title\":\"Image Width\",\"name\":\"image_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"\",\"min\":\"0\",\"max\":\"500\",\"step\":\"1\",\"units\":\"px_percent\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_placeholder img\",\"selector_value\":\"width: {{SIZE}}{{UNIT}} !important;\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_slider\",\"title\":\"Nav Dots Size\",\"name\":\"nav_dots_size\",\"description\":\"\",\"default_value\":\"8\",\"min\":\"4\",\"max\":\"20\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-dot\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"8\"},{\"type\":\"uc_colorpicker\",\"title\":\"Dot Color\",\"name\":\"dot_color\",\"description\":\"\",\"default_value\":\"#c6c6c6\",\"selector\":\".owl-dot\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"#c6c6c6\"},{\"type\":\"uc_colorpicker\",\"title\":\"Dot Active Color\",\"name\":\"dot_active_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".owl-dot.active\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"#000000\"},{\"type\":\"uc_slider\",\"title\":\"Dot Spacing\",\"name\":\"dot_spacing\",\"description\":\"\",\"default_value\":\"20\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-dots\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"20\"},{\"type\":\"uc_slider\",\"title\":\"Dot Space Between\",\"name\":\"dot_space_between\",\"description\":\"\",\"default_value\":\"5\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-dot\",\"selector_value\":\"margin:0px {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"5\"},{\"type\":\"uc_dropdown\",\"title\":\"Dot Alignment\",\"name\":\"dot_alignment\",\"description\":\"\",\"options\":{\"Center\":\"center\",\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"center\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"center\"},{\"type\":\"uc_padding\",\"title\":\"Image Padding\",\"name\":\"image_padding\",\"description\":\"\",\"is_responsive\":true,\"desktop_top\":\"20\",\"desktop_right\":\"20\",\"desktop_bottom\":\"20\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc_classic_carousel_placeholder\",\"__attr_catid__\":\"cat_style_bx9jev04\",\"value\":{\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"}},{\"type\":\"uc_colorpicker\",\"title\":\"Top Decoration Color\",\"name\":\"top_decoration_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".uc_classic_carousel_border\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vtg2vocz\",\"value\":\"#000000\"},{\"type\":\"uc_radioboolean\",\"title\":\"Transition Easing\",\"name\":\"transition_easing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Center\",\"name\":\"center\",\"description\":\"\",\"enable_condition\":\"false\",\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":\"\",\"label_block\":\"false\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Top Decoration Width\",\"name\":\"top_decoration_width\",\"description\":\"\",\"default_value\":\"50\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_border\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vtg2vocz\",\"value\":\"50\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Top Decoration Height\",\"name\":\"top_decoration_height\",\"description\":\"\",\"default_value\":\"3\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_border\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vtg2vocz\",\"value\":\"3\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_padding\",\"title\":\"Content Padding\",\"name\":\"content_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"0\",\"desktop_right\":\"20\",\"desktop_bottom\":\"20\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc_classic_carousel_content\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_colorpicker\",\"title\":\"Title Color\",\"name\":\"title_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".card_carousel_title\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_aohl5oww\",\"value\":\"#000000\"},{\"type\":\"uc_typography\",\"title\":\"Title Typography\",\"name\":\"title_typography\",\"description\":\"\",\"selector1\":\".card_carousel_title\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_aohl5oww\",\"value\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Text Color\",\"name\":\"text_color\",\"description\":\"\",\"default_value\":\"#8a8a8a\",\"selector\":\".card_carousel_text\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_lhmeogkk\",\"value\":\"#8a8a8a\"},{\"type\":\"uc_typography\",\"title\":\"Text Typography\",\"name\":\"text_typography\",\"description\":\"\",\"selector1\":\".card_carousel_text\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_lhmeogkk\",\"value\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Button Spacing\",\"name\":\"button_spacing\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_more_btn\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"10\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Slide Radius\",\"name\":\"slide_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-carousel-item\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Spacing\",\"name\":\"nav_arrow_spacing\",\"description\":\"Horizontal Spacing\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-nav .owl-prev\",\"selector_value\":\"left: {{SIZE}}{{UNIT}}; right: auto;\",\"show_more_selectors\":true,\"selector2\":\".owl-nav .owl-next\",\"selector2_value\":\"right: {{SIZE}}{{UNIT}}; left: auto;\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Position\",\"name\":\"nav_arrow_position\",\"description\":\"Vertical Spacing\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"94\",\"min\":\"0\",\"max\":\"600\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Radius\",\"name\":\"nav_arrow_radius\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"0\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Background Size\",\"name\":\"nav_arrow_background_size\",\"description\":\"\",\"default_value\":\"62\",\"min\":\"20\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"42\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Icon Size\",\"name\":\"nav_arrow_icon_size\",\"description\":\"\",\"default_value\":\"24\",\"min\":\"20\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"24\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Nav Arrow Background\",\"name\":\"nav_arrow_background\",\"description\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"#ffffff\"},{\"type\":\"uc_colorpicker\",\"title\":\"Nav Arrow Background Hover\",\"name\":\"nav_arrow_background_hover\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".owl-carousel .owl-nav .owl-next:hover, .owl-carousel .owl-nav .owl-prev:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"#000000\"},{\"type\":\"uc_colorpicker\",\"title\":\"Nav Arrow Icon Color\",\"name\":\"nav_arrow_icon_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"#000000\"},{\"type\":\"uc_colorpicker\",\"title\":\"Nav Arrow Icon Color Hover\",\"name\":\"nav_arrow_icon_color_hover\",\"description\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".owl-carousel .owl-nav .owl-next:hover, .owl-carousel .owl-nav .owl-prev:hover\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"#ffffff\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Image\",\"name\":\"show_image\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Image Link\",\"name\":\"image_link\",\"description\":\"Makes image use link field\",\"enable_condition\":true,\"condition_attribute\":\"show_image\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Icon\",\"name\":\"show_icon\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_dropdown\",\"title\":\"Show Title\",\"name\":\"show_title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"options\":{\"Hide\":\"hide\",\"Above Content\":\"above\",\"Under Content\":\"under\"},\"default_value\":\"above\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_dropdown\",\"title\":\"Title HTML Tag\",\"name\":\"title_html_tag\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_title\",\"condition_operator\":\"not_equal\",\"condition_value\":\"hide\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"div\":\"div\",\"h1\":\"h1\",\"h2\":\"h2\",\"h3\":\"h3\",\"h4\":\"h4\",\"h5\":\"h5\",\"h6\":\"h6\"},\"default_value\":\"div\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Title Link\",\"name\":\"title_link\",\"description\":\"Makes the title linkable\",\"enable_condition\":true,\"condition_attribute\":\"show_title\",\"condition_operator\":\"not_equal\",\"condition_value\":\"hide\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Text\",\"name\":\"show_text\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Button\",\"name\":\"show_button\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\",\"value\":\"true\"},{\"type\":\"uc_slider\",\"title\":\"Content Minimum Height\",\"name\":\"content_minimum_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"min\":\"0\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_content\",\"selector_value\":\"min-height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_margins\",\"title\":\"Item Margin\",\"name\":\"item_margin\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-carousel-item\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color\",\"name\":\"background_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"#ffffff\",\"selector\":\".ue-carousel-item\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_textfield\",\"title\":\"Button Text\",\"name\":\"button_text\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_button\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"Learn More\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Top Decoration\",\"name\":\"show_top_decoration\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_slider\",\"title\":\"Item Scale\",\"name\":\"item_scale\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"1\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-carousel-item\",\"selector_value\":\"transform: scale({{SIZE}},{{SIZE}});\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_border\",\"title\":\"Button Border\",\"name\":\"button_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc_more_btn\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_border\",\"title\":\"Button Border Hover\",\"name\":\"button_border_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc_more_btn:hover\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_icon_library\",\"title\":\"Left Arrow\",\"name\":\"left_arrow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"fas fa-chevron-left\",\"enable_svg\":false,\"put_svg_as\":\"image\",\"__attr_catid__\":\"cat_content_esf09cqe\"},{\"type\":\"uc_icon_library\",\"title\":\"Right Arrow\",\"name\":\"right_arrow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"fas fa-chevron-right\",\"enable_svg\":false,\"put_svg_as\":\"svg\",\"__attr_catid__\":\"cat_content_esf09cqe\"},{\"type\":\"uc_listing\",\"title\":\"Remote Parent\",\"name\":\"remote_parent\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"remote\",\"gallery_enable_video\":false,\"enable_pagination\":false,\"remote_type\":\"parent\",\"remote_widget_name\":\"Icon Carousel\",\"__attr_catid__\":\"cat_content_vvdb29vi\"},{\"type\":\"uc_dropdown\",\"title\":\"Image Fit\",\"name\":\"image_fit\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Cover\":\"cover\",\"Contain\":\"contain\"},\"default_value\":\"cover\",\"selector\":\".uc_classic_carousel_placeholder img\",\"selector_value\":\"object-fit: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_css_filters\",\"title\":\"Item CSS Filter\",\"name\":\"item_css_filter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Item Opacity\",\"name\":\"item_opacity\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-carousel-item\",\"selector_value\":\"opacity: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_border\",\"title\":\"Item Border\",\"name\":\"item_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"border_type\":\"solid\",\"border_color\":\"#dfdfdf\",\"width_desktop_top\":\"1\",\"width_desktop_right\":\"1\",\"width_desktop_bottom\":\"1\",\"width_desktop_left\":\"1\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_boxshadow\",\"title\":\"Item Shadow\",\"name\":\"item_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color\",\"name\":\"active_slide_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"default_value\":\"\",\"selector\":\".uc-active-item .ue-carousel-item\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Item Scale\",\"name\":\"active_item_scale\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"default_value\":\"1\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc-active-item .ue-carousel-item\",\"selector_value\":\"transform: scale({{SIZE}},{{SIZE}});\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_css_filters\",\"title\":\"Slide CSS Filter\",\"name\":\"active_slide_css_filter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"selector\":\".uc-active-item .ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Item Opacity\",\"name\":\"item_opacity_active\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"default_value\":\"\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc-active-item .ue-carousel-item\",\"selector_value\":\"opacity: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_border\",\"title\":\"Item Border\",\"name\":\"active_item_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_boxshadow\",\"title\":\"Item Shadow\",\"name\":\"item_shadow_active\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"selector\":\".uc-active-item .ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_number\",\"title\":\"Show Dots Each X Item\",\"name\":\"show_dots_each_x_item\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"center\",\"condition_operator\":\"not_equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"1\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"1\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"1\",\"default_value_mobile\":\"1\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Set Active Mode On Mobile\",\"name\":\"active_on_mobile\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Change On Click\",\"name\":\"scroll_on_click\",\"description\":\"Change to the clicked item on item click.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Icon Size Outter\",\"name\":\"icon_size_outter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"60\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_slider\",\"title\":\"Icon Size\",\"name\":\"icon_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Color\",\"name\":\"icon_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#ffffff\",\"selector\":\".ue-item-icon\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":true,\"selector2\":\".ue-item-icon svg\",\"selector2_value\":\"fill:{{VALUE}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Background\",\"name\":\"icon_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#6e6e6e\",\"selector\":\".ue-item-icon\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Icon Radius\",\"name\":\"icon_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"is_responsive\":true,\"desktop_top\":\"100\",\"desktop_right\":\"100\",\"desktop_bottom\":\"100\",\"desktop_left\":\"100\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_boxshadow\",\"title\":\"Icon Shadow\",\"name\":\"icon_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_border\",\"title\":\"Icon Border\",\"name\":\"icon_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_slider\",\"title\":\"Icon Spacing\",\"name\":\"icon_spacing\",\"description\":\"Margin Top\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_dropdown\",\"title\":\"Icon Alignment\",\"name\":\"icon_alignment\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Start\":\"flex-start\",\"Center\":\"center\",\"End\":\"flex-end\"},\"default_value\":\"center\",\"selector\":\".ue-item-icon-wrapper\",\"selector_value\":\"justify-content:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_radioboolean\",\"title\":\"RTL\",\"name\":\"rtl\",\"description\":\"For right to left websites.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Random Order\",\"name\":\"shuffle\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Mouse Drag\",\"name\":\"mouse_drag\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Touch Drag\",\"name\":\"touch_drag\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Scroll To Head\",\"name\":\"scroll_to_head\",\"description\":\"scroll to head on item change if the carousel not visible\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Scroll To Head Forced On Mobile\",\"name\":\"scroll_to_head_forced_on_mobile\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"scroll_to_head\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Scroll To Head Offset\",\"name\":\"scroll_to_head_offset\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"scroll_to_head\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Mouse Wheel Control\",\"name\":\"enable_mouse_wheel_control\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_special\",\"title\":\"Item Image Size\",\"name\":\"item_image_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"attribute_type\":\"items_image_size\",\"entrance_animation_item_class\":\"\",\"schema_title_name\":\"\",\"schema_content_name\":\"\",\"image_size_param_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_listing\",\"title\":\"Source\",\"name\":\"multisource\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"items\",\"gallery_enable_video\":false,\"enable_pagination\":true,\"enable_ajax\":true,\"multisource_included_attributes\":\"content,image,link\",\"multisource_attributes_defaults\":\"\",\"remote_type\":\"parent\",\"controller_more_parents\":false,\"__attr_catid__\":\"cat_content_6l7hso6i\"},{\"type\":\"uc_radioboolean\",\"title\":\"Auto Width\",\"name\":\"auto_width\",\"description\":\"Sets Carousel Item width to match its maximum content width.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Item Width\",\"name\":\"item_width\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"auto_width\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"min\":\"0\",\"max\":\"500\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Overlay\",\"name\":\"enable_img_overlay\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_or92h9zn\"},{\"type\":\"uc_colorpicker\",\"title\":\"Image Overlay Color\",\"name\":\"image_overlay_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"enable_img_overlay\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".ue_card_carousel_image_overlay\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_or92h9zn\"},{\"type\":\"uc_slider\",\"title\":\"Image Overlay Opacity\",\"name\":\"image_overlay_opacity\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"enable_img_overlay\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_card_carousel_image_overlay\",\"selector_value\":\"opacity: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_or92h9zn\"},{\"type\":\"uc_slider\",\"title\":\"Image Overlay Opacity Hover\",\"name\":\"image_overlay_opacity_hover\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"enable_img_overlay\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-carousel-item:hover .ue_card_carousel_image_overlay\",\"selector_value\":\"opacity: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_or92h9zn\"},{\"type\":\"uc_css_filters\",\"title\":\"Image CSS Filter\",\"name\":\"image_css_filter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector\":\".uc_classic_carousel_placeholder img\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_css_filters\",\"title\":\"Image CSS Filter Active\",\"name\":\"image_css_filter_active\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector\":\".uc-active-item img\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_css_filters\",\"title\":\"Image CSS Filter Hover\",\"name\":\"image_css_filter_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector\":\".ue-carousel-item:hover img\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_dropdown\",\"title\":\"Animation\",\"name\":\"carousel_animation\",\"description\":\"Works if Number of Items option is equal to 1.\",\"enable_condition\":true,\"condition_attribute\":\"auto_width\",\"condition_operator\":\"not_equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"None\":\"none\",\"Fade In Out\":\"fadeIn\",\"Fade In Left Out Right\":\"fadeInLeft\",\"Fade In Right Out Left\":\"fadeInRight\",\"Fade In Out Up\":\"fadeInUp\",\"Fade In Out Down\":\"fadeInDown\",\"Slide In Left Out Right\":\"slideInLeft\",\"Slide In Right Out Left\":\"slideInRight\",\"Slide In Out Up\":\"slideInUp\",\"Slide In Out Down\":\"slideInDown\"},\"default_value\":\"none\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_border\",\"title\":\"Nav Arrows Border\",\"name\":\"nav_arrows_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".owl-carousel .owl-nav > button\",\"__attr_catid__\":\"cat_style_vp30mio9\"},{\"type\":\"uc_border\",\"title\":\"Nav Arrows Border Hover\",\"name\":\"nav_arrows_border_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".owl-carousel .owl-nav > button:hover\",\"__attr_catid__\":\"cat_style_vp30mio9\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Title\",\"name\":\"title\",\"description\":\"\",\"default_value\":\"Default Title\",\"font_editable\":false},{\"type\":\"uc_textarea\",\"title\":\"Content\",\"name\":\"content\",\"description\":\"\",\"default_value\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"font_editable\":false},{\"type\":\"uc_textfield\",\"title\":\"Button Text\",\"name\":\"btn_text\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false},{\"type\":\"uc_image\",\"title\":\"Image\",\"name\":\"image\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"media_type\":\"image\",\"default_value\":\"[url_assets]\\/uc_classic_carousel_img1.jpg\",\"add_image_sizes\":true,\"default_value_json\":\"\"},{\"type\":\"uc_link\",\"title\":\"Link\",\"name\":\"link\",\"description\":\"\",\"default_value\":\"#\"},{\"type\":\"uc_radioboolean\",\"title\":\"Override Colors\",\"name\":\"override_colors\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\"},{\"type\":\"uc_colorpicker\",\"title\":\"Override Background\",\"name\":\"override_background\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"override_colors\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"selector\":\"{{CURRENT_ITEM}} .ue-carousel-item\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"},{\"type\":\"uc_icon_library\",\"title\":\"Icon\",\"name\":\"icon\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"fas fa-rocket\",\"enable_svg\":true,\"put_svg_as\":\"svg\"},{\"type\":\"uc_radioboolean\",\"title\":\"Hide Item\",\"name\":\"hide_item\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\"}],\"includes\":{\"js\":[],\"jslib\":[\"jquery\",\"font-awsome\",\"owl-carousel-new\"],\"css\":[{\"url\":\"uc_classic_carousel\\/animate.css\",\"condition\":null,\"params\":null}]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_6l7hso6i\",\"title\":\"Source\",\"tab\":\"content\"},{\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"id\":\"cat_content_h40uqlsb\",\"title\":\"Layout\",\"tab\":\"content\"},{\"id\":\"cat_content_esf09cqe\",\"title\":\"Arrows\",\"tab\":\"content\"},{\"id\":\"cat_content_vvdb29vi\",\"title\":\"Connected Widgets Settings\",\"tab\":\"content\"},{\"id\":\"cat_style_fhe0kmn5\",\"title\":\"Slide\",\"tab\":\"style\"},{\"id\":\"cat_style_vtg2vocz\",\"title\":\"Top Decoration\",\"tab\":\"style\"},{\"id\":\"cat_style_bx9jev04\",\"title\":\"Image\",\"tab\":\"style\"},{\"params\":[{\"type\":\"uc_colorpicker\",\"title\":\"Image Overlay Color\",\"name\":\"image_overlay_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".ue_pos_carousel_image_overlay\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_or92h9zn\"},{\"type\":\"uc_slider\",\"title\":\"Image Overlay Opacity\",\"name\":\"image_overlay_opacity\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_pos_carousel_image_overlay\",\"selector_value\":\"opacity: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_or92h9zn\"},{\"type\":\"uc_slider\",\"title\":\"Image Overlay Opacity Hover\",\"name\":\"image_overlay_opacity_hover\",\"description\":\"\",\"default_value\":\"40\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_carousel_item:hover .ue_pos_carousel_image_overlay\",\"selector_value\":\"opacity: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_or92h9zn\"}],\"expire\":1691096992756,\"id\":\"cat_style_or92h9zn\",\"title\":\"Image Overlay\",\"tab\":\"style\"},{\"params\":[{\"type\":\"uc_slider\",\"title\":\"Icon Size Outter\",\"name\":\"icon_size_outter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"60\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_slider\",\"title\":\"Icon Size\",\"name\":\"icon_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Color\",\"name\":\"icon_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#ffffff\",\"selector\":\".ue-item-icon\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":true,\"selector2\":\".ue-item-icon svg\",\"selector2_value\":\"fill:{{VALUE}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Background\",\"name\":\"icon_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#6e6e6e\",\"selector\":\".ue-item-icon\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Icon Radius\",\"name\":\"icon_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"is_responsive\":true,\"desktop_top\":\"100\",\"desktop_right\":\"100\",\"desktop_bottom\":\"100\",\"desktop_left\":\"100\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_boxshadow\",\"title\":\"Icon Shadow\",\"name\":\"icon_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_border\",\"title\":\"Icon Border\",\"name\":\"icon_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_slider\",\"title\":\"Icon Spacing\",\"name\":\"icon_spacing\",\"description\":\"Margin Top\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"}],\"expire\":1643623349684,\"id\":\"cat_style_rgn3eqz4\",\"title\":\"Icon\",\"tab\":\"style\"},{\"id\":\"cat_style_aohl5oww\",\"title\":\"Title\",\"tab\":\"style\"},{\"id\":\"cat_style_lhmeogkk\",\"title\":\"Text\",\"tab\":\"style\"},{\"id\":\"cat_style_ubiljccp\",\"title\":\"Button\",\"tab\":\"style\"},{\"id\":\"cat_style_vp30mio9\",\"title\":\"Nav Arrows\",\"tab\":\"style\"},{\"id\":\"cat_style_r94csez3\",\"title\":\"Nav Bullets\",\"tab\":\"style\"}]}", "2", "1", NULL, "{\"config\":{\"loop\":\"true\",\"autoplay\":\"true\",\"show_arrows\":\"true\",\"show_bullets\":\"block\",\"number_of_items\":\"3\",\"number_of_items_tablet\":\"2\",\"number_of_items_mobile\":\"1\",\"align_unite_selected_text\":\"Center\",\"align\":\"center\",\"title_spacing\":\"0\",\"title_spacing_tablet\":\"\",\"title_spacing_mobile\":\"\",\"text_spacing\":\"10\",\"button_padding\":{\"top\":\"10\",\"right\":\"20\",\"bottom\":\"10\",\"left\":\"20\",\"unit\":\"px\"},\"button_radius\":\"5\",\"transition_speed\":\"1000\",\"autoplay_interval\":\"3000\",\"button_bg_color\":\"#ffffff\",\"button_background_color_hover\":\"#000000\",\"button_border_width\":\"2\",\"btn_brdr_clr\":\"#000000\",\"btn_brdr_clr_hover\":\"#000000\",\"btn_txt_clr\":\"#000000\",\"btn_txt_clr_hvr\":\"#ffffff\",\"item_shadow\":\"0px 5px 10px rgba(0, 0, 0, 0.1); \",\"item_brdr_clr\":\"#cdcdcd\",\"item_brdr_width\":\"0\",\"direction\":\"ltr\",\"margin_between_slides\":\"30\",\"image_radius\":\"0\",\"image_height\":\"200\",\"image_height_tablet\":\"\",\"image_height_mobile\":\"\",\"image_padding\":{\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"background_color\":\"#ffffff\",\"top_decoration_color\":\"#000000\",\"top_decoration_width\":\"50\",\"top_decoration_width_tablet\":\"\",\"top_decoration_width_mobile\":\"\",\"top_decoration_height\":\"3\",\"top_decoration_height_tablet\":\"\",\"top_decoration_height_mobile\":\"\",\"content_padding\":{\"top\":\"0\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"title_color\":\"#000000\",\"text_color\":\"#8a8a8a\",\"button_spacing\":\"10\",\"button_spacing_tablet\":\"\",\"button_spacing_mobile\":\"\",\"show_button\":\"true\",\"slide_radius\":\"0\",\"slide_radius_tablet\":\"\",\"slide_radius_mobile\":\"\",\"nav_arrow_spacing\":\"20\",\"nav_arrow_position\":\"100\",\"nav_arrow_radius\":\"0\",\"nav_arrow_size\":\"18\",\"nav_arrow_background_size\":\"42\",\"nav_arrow_background_size_tablet\":\"\",\"nav_arrow_background_size_mobile\":\"\",\"nav_arrow_icon_size\":\"24\",\"nav_arrow_icon_size_tablet\":\"\",\"nav_arrow_icon_size_mobile\":\"\",\"nav_arrow_background\":\"#ffffff\",\"nav_arrow_background_hover\":\"#000000\",\"nav_arrow_icon_color\":\"#000000\",\"nav_arrow_icon_color_hover\":\"#ffffff\",\"dot_color\":\"#000000\",\"dot_color_active\":\"#000000\",\"nav_dots_spacing\":\"20\",\"nav_dots_spacing_tablet\":\"\",\"nav_dots_spacing_mobile\":\"\"},\"items\":[{\"title\":\"Item One\",\"content\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"btn_text\":\"Show More\",\"image\":\"[url_assets]\\/placeholder2.jpg\",\"link\":\"#\"},{\"title\":\"Item Two\",\"content\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"btn_text\":\"Show More\",\"image\":\"[url_assets]\\/placeholder1.jpg\",\"link\":\"#\"},{\"title\":\"Item Three\",\"content\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"btn_text\":\"Show More\",\"image\":\"[url_assets]\\/placeholder4.jpg\",\"link\":\"#\"},{\"title\":\"Item Four\",\"content\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"btn_text\":\"Show More\",\"image\":\"[url_assets]\\/placeholder3.jpg\",\"link\":\"#\"}]}", NULL);
INSERT INTO `ethr_addonlibrary_addons` VALUES("3", "Notification", "notification_elementor", "notification", "elementor", "The Notification widget enables you to display a colored alert box and draw attention to important messages on your Elementor website.", "1", "{\"html\":\"<div id=\\\"{{uc_id}}\\\" class=\\\"ue_notification {{uc_filtering_addclass}}\\\" {{uc_filtering_attributes}}>\\n  \\n  {% if show_graphic_element == \\\"true\\\" %}\\n  <div class=\\\"ue_graphic_el\\\">\\n    {% if icon_source == \\\"icon\\\" %}\\n      {{graphic_icon_html|raw}}\\n    {% endif %}\\n    {% if icon_source == \\\"img\\\" %}\\n      <img src=\\\"{{graphic_image}}\\\">\\n    {% endif %}\\n    {% if icon_source == \\\"text\\\" %}\\n      <span>{{graphic_text|raw}}<\\/span>\\n    {% endif %}\\n    {% if icon_source == \\\"template\\\" %}\\n      <span>{{putElementorTemplate(template_templateid)}}<\\/span>\\n    {% endif %}\\n  <\\/div>\\n  {% endif %}\\n  \\n  <div class=\\\"ue_content\\\">\\n    <div class=\\\"ue_text_content\\\">\\n    {% if show_title == \\\"true\\\" %}\\n      <{{title_tag}} class=\\\"ue_title\\\">{{notification_title|raw}}<\\/{{title_tag}}>\\n    {% endif %}\\n    {% if show_text == \\\"true\\\" %}\\n      <{{text_tag}} class=\\\"ue_text\\\">{{text|raw}}<\\/{{text_tag}}>\\n    {% endif %}\\n    <\\/div>\\n    {% if show_button == \\\"true\\\" %}\\n    <div class=\\\"ue_action uc-items-wrapper\\\">\\n      {{put_items()}}\\n    <\\/div>\\n    {% endif %}\\n    \\n  <\\/div>\\n  <div class=\\\"ue_close_notification\\\">\\n    {{close_html|raw}}\\n    {% if show_close_button_text == \\\"true\\\" %}\\n      <span>{{close_text|raw}}<\\/span>\\n    {% endif %}\\n  <\\/div>\\n<\\/div>\",\"html_item\":\"<a class=\\\"ue_nf_btn {{button_hover_animation}} {{item.item_repeater_class}}\\\" href=\\\"{{item.button_link}}\\\" {{item.button_link_html_attributes|raw}}>{{item.title|raw}}<\\/a>\",\"css\":\"#{{uc_id}}\\n{\\n  display: flex;\\n  position:relative;\\n}\\n\\n#{{uc_id}} .ue_content{\\n  display:flex;\\n}\\n#{{uc_id}} .ue_text_content{\\n  display:flex;\\n  flex-direction: column;\\n  \\/* align-items: flex-start; *\\/\\n  justify-content: center;\\n}\\n#{{uc_id}} .ue_action{\\n  display: flex;\\n  flex-wrap: wrap;\\n}\\n#{{uc_id}} .ue_action a{\\n  height: fit-content;\\n  min-width: max-content;\\n}\\n\\n{% if show_graphic_element == \\\"true\\\" %}\\n#{{uc_id}} .ue_graphic_el img{\\n  width:100%;\\n  height:100%;\\n}\\n#{{uc_id}} .ue_graphic_el{\\n  display: flex;\\n  justify-content: center;\\n  align-items: center;\\n  text-align: center;\\n  overflow:hidden;\\n  flex-shrink: 0;\\n}\\n{% endif %}\\n\\n#{{uc_id}} .ue_close_notification\\n{\\n  position:absolute;\\n  {{vertical_position}}:{{vertical_push}};\\n  {{horizontal_position}}:{{horizontal_push}};\\n  cursor:pointer;\\n  display:flex;\\n  align-items: center;\\n  justify-content:center;\\n}\\n\\n{% if enable_cookie == \\\"true\\\" %}\\n #{{uc_id}}{\\n   display:none;\\n }\\n{% endif %}\",\"js\":\"jQuery(document).ready(function(){\\n    \\n    \\/\\/ filter-format cookie name \\n    {% if enable_cookie == \\\"true\\\" %}\\n     var {{uc_id}}_cookieName = \\\"{{cookie_name|raw}}\\\";\\n         {{uc_id}}_cookieName = {{uc_id}}_cookieName.replace(\\/[^!#$%&\'*+\\\\-.^_|~0-9A-Za-z]\\/g, \\\"_\\\");\\n    {% endif %}\\n           \\n    jQuery(\\\"#{{uc_id}} .ue_close_notification\\\").click(function(){\\n        jQuery(\\\"#{{uc_id}}\\\").fadeOut(200);\\n\\n    {% if enable_cookie == \\\"true\\\" %}\\n      {% if cookie_name is not empty %}\\n        var ue_expires = new Date();\\n        ue_expires.setTime(ue_expires.getTime() + ({{cookie_exp_day}} * 24 * 60 * 60 * 1000) + ({{cookie_exp_hour}} * 60 * 60 * 1000) + ({{cookie_exp_minutes}} * 60 * 1000) + ({{cookie_exp_sec}} * 1000));\\n        document.cookie = \\\"ue_notify_{{current_post.id}}_\\\"+ {{uc_id}}_cookieName +\\\"=true; expires=\\\" + ue_expires.toUTCString() + \\\"; path = \'{{current_post.link}}\';\\\";\\n      {% endif %}\\n    {% endif %}\\n\\n      });\\n     \\n     {% if enable_cookie == \\\"true\\\" %}\\n     if (!document.cookie.includes(\\\"ue_notify_{{current_post.id}}_\\\"+ {{uc_id}}_cookieName +\\\"=true\\\")) {\\n          jQuery(\\\"#{{uc_id}}\\\").css({\\n           \\\"display\\\": \\\"flex\\\"\\n          });\\n     }\\n    {% endif %}\\n});\"}", "{\"options\":{\"enable_items\":\"true\",\"items_section_title\":\"Items (Buttons)\",\"items_section_heading\":\"\",\"items_title_field\":\"\",\"path_assets\":\"notification\",\"js_as_module\":false,\"addon_icon\":\"fas fa-info-circle\",\"dynamic_addon\":\"true\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"The Notification widget enables you to display a colored alert box and draw attention to important messages on your Elementor website.\",\"link_resource\":\"https:\\/\\/youtu.be\\/4xVPW5DUWG4\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/notification-widget-for-elementor\",\"show_small_icon\":\"true\",\"preview_size\":\"column\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"special\":\"\",\"special_data\":\"\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_radioboolean\",\"title\":\"Show Title\",\"name\":\"show_title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_textfield\",\"title\":\"Notification Title\",\"name\":\"notification_title\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_title\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"\",\"default_value\":\"Notification Title\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Title Tag\",\"name\":\"title_tag\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_title\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"H1\":\"h1\",\"H2\":\"h2\",\"H3\":\"h3\",\"H4\":\"h4\",\"H5\":\"h5\",\"H6\":\"h6\",\"div\":\"div\",\"span\":\"span\",\"p\":\"p\"},\"default_value\":\"h4\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Description\",\"name\":\"show_text\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_textarea\",\"title\":\"Notification Description\",\"name\":\"text\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_text\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"This is a notification description to inform website visitors about important happenings on the website.\",\"font_editable\":false,\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Text Tag\",\"name\":\"text_tag\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_text\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"H1\":\"h1\",\"H2\":\"h2\",\"H3\":\"h3\",\"H4\":\"h4\",\"H5\":\"h5\",\"H6\":\"h6\",\"div\":\"div\",\"span\":\"span\",\"p\":\"p\"},\"default_value\":\"p\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Layout\",\"name\":\"layout\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Row\":\"row\",\"Row Reverse\":\"row-reverse\",\"Column\":\"column\",\"Column Reverse\":\"column-reverse\"},\"default_value\":\"row\",\"selector\":\".ue_notification\",\"selector_value\":\"flex-direction: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"column\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_dropdown\",\"title\":\"Justify Content\",\"name\":\"justify_content_main\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Start\":\"flex-start\",\"Center\":\"center\",\"End\":\"flex-end\",\"Space Between\":\"space-between\",\"Space Around\":\"space-around\",\"Space Evenly\":\"space-evenly\"},\"default_value\":\"flex-start\",\"selector\":\".ue_notification \",\"selector_value\":\"justify-content: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_dropdown\",\"title\":\"Content Alignment\",\"name\":\"align_content\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Start\":\"flex-start\",\"Center\":\"center\",\"End\":\"flex-end\"},\"default_value\":\"flex-start\",\"selector\":\".ue_notification, .ue_action\",\"selector_value\":\"align-items:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_dropdown\",\"title\":\"Horizontal Position\",\"name\":\"horizontal_position\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"right\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_faa0l673\"},{\"type\":\"uc_dropdown\",\"title\":\"Vertical Position\",\"name\":\"vertical_position\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Bottom\":\"bottom\"},\"default_value\":\"top\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_faa0l673\"},{\"type\":\"uc_slider\",\"title\":\"Horizontal Gap\",\"name\":\"horizontal_push\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_content_faa0l673\"},{\"type\":\"uc_slider\",\"title\":\"Vertical Gap\",\"name\":\"vertical_push\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_content_faa0l673\"},{\"type\":\"uc_padding\",\"title\":\"Padding\",\"name\":\"close_btn_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"6\",\"desktop_right\":\"15\",\"desktop_bottom\":\"6\",\"desktop_left\":\"15\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_close_notification\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Button\",\"name\":\"show_button\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Graphic Element\",\"name\":\"show_graphic_element\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Text Alignment\",\"name\":\"text_alignment\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"start\",\"Center\":\"center\",\"Right\":\"end\"},\"default_value\":\"start\",\"selector\":\".ue_notification\",\"selector_value\":\"text-align:{{VALUE}};\",\"show_more_selectors\":true,\"selector2\":\".ue_text_content\",\"selector2_value\":\"align-items:{{VALUE}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_padding\",\"title\":\"Notification Padding\",\"name\":\"notification_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"30\",\"desktop_right\":\"30\",\"desktop_bottom\":\"30\",\"desktop_left\":\"30\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_notification\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_padding\",\"title\":\"Content Padding\",\"name\":\"notification_content_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_content\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Notification Radius\",\"name\":\"notification_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_notification\",\"add_units\":\"%,em\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_border\",\"title\":\"Notification Border\",\"name\":\"notification_border\",\"description\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue_notification\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color\",\"name\":\"bg\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"#F1E1FF\",\"selector\":\".ue_notification\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_icon_library\",\"title\":\"Close Icon\",\"name\":\"close\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"fas fa-times\",\"enable_svg\":true,\"put_svg_as\":\"svg\",\"__attr_catid__\":\"cat_content_faa0l673\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Close Button Text\",\"name\":\"show_close_button_text\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_faa0l673\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Border Radius\",\"name\":\"close_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_close_notification\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_border\",\"title\":\"Close Button Border\",\"name\":\"close_button_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue_close_notification\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_slider\",\"title\":\"Close Button Icon Size\",\"name\":\"close_button_icon_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"15\",\"min\":\"10\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_close_notification i\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":true,\"selector2\":\".ue_close_notification svg\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_slider\",\"title\":\"Text Gap\",\"name\":\"close_text_gap\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_close_button_text\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"8\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px_percent_em\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_close_notification\",\"selector_value\":\"gap: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_typography\",\"title\":\"Close Text Typography\",\"name\":\"close_text_typography\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_close_button_text\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue_close_notification span\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Title Color\",\"name\":\"title_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".ue_title\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_tdx45oln\"},{\"type\":\"uc_typography\",\"title\":\"Title Typography\",\"name\":\"title_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue_title\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_tdx45oln\"},{\"type\":\"uc_dropdown\",\"title\":\"Graphic Element Source\",\"name\":\"icon_source\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Icon\":\"icon\",\"Image\":\"img\",\"Text\":\"text\",\"Elementor Template\":\"template\"},\"default_value\":\"icon\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_2x63c0vm\"},{\"type\":\"uc_listing\",\"title\":\"Button Source\",\"name\":\"source\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"items\",\"gallery_enable_video\":false,\"enable_pagination\":true,\"enable_ajax\":true,\"multisource_included_attributes\":\"button_link\",\"multisource_attributes_defaults\":\"\",\"remote_type\":\"parent\",\"controller_more_parents\":false,\"__attr_catid__\":\"cat_content_dge5saai\"},{\"type\":\"uc_icon_library\",\"title\":\"Icon\",\"name\":\"graphic_icon\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"icon\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"far fa-bell\",\"enable_svg\":true,\"put_svg_as\":\"svg\",\"__attr_catid__\":\"cat_content_2x63c0vm\"},{\"type\":\"uc_image\",\"title\":\"Image\",\"name\":\"graphic_image\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"img\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"media_type\":\"image\",\"default_value\":\"[url_assets]\\/default_img.png\",\"add_image_sizes\":true,\"default_value_json\":\"\",\"__attr_catid__\":\"cat_content_2x63c0vm\"},{\"type\":\"uc_textfield\",\"title\":\"Text\",\"name\":\"graphic_text\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"text\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"info\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_content_2x63c0vm\"},{\"type\":\"uc_margins\",\"title\":\"Margin\",\"name\":\"graphic_el_margin\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_graphic_el\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_slider\",\"title\":\"Gap\",\"name\":\"graphic_elm_gap\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px_percent_em\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_notification\",\"selector_value\":\"gap: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_slider\",\"title\":\"Wrapper Width\",\"name\":\"graphic_wrp_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"img\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"72\",\"min\":\"1\",\"max\":\"500\",\"step\":\"1\",\"units\":\"px_percent_em\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_graphic_el\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_slider\",\"title\":\"Wrapper Height\",\"name\":\"graphic_wrp_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"img\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"72\",\"min\":\"1\",\"max\":\"500\",\"step\":\"1\",\"units\":\"px_percent_em\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_graphic_el\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_slider\",\"title\":\"Icon Size\",\"name\":\"graphic_icon_size\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"icon\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"24\",\"min\":\"1\",\"max\":\"200\",\"step\":\"1\",\"units\":\"px_percent_em\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_graphic_el i\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":true,\"selector2\":\".ue_graphic_el svg\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_colorpicker\",\"title\":\"Graphic Element Color\",\"name\":\"graphic_elm_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"not_equal\",\"condition_value\":[\"img\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".ue_graphic_el\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":true,\"selector2\":\".ue_graphic_el svg\",\"selector2_value\":\"fill:{{VALUE}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color\",\"name\":\"graphic_bg_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".ue_graphic_el\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Border Radius\",\"name\":\"graphic_el_border_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"50\",\"desktop_right\":\"50\",\"desktop_bottom\":\"50\",\"desktop_left\":\"50\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_graphic_el \",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_border\",\"title\":\"Border\",\"name\":\"graphic_el_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"not_equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue_graphic_el\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_dropdown\",\"title\":\"Image Fit\",\"name\":\"image_fit\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"img\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Cover\":\"cover\",\"Contain\":\"contain\",\"Fill\":\"fill\",\"Scale-Down\":\"scale-down\",\"none\":\"none\"},\"default_value\":\"cover\",\"selector\":\".ue_graphic_el img\",\"selector_value\":\"object-fit:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_dropdown\",\"title\":\"Image Position\",\"name\":\"image_position\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"img\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Center\":\"center\",\"Bottom\":\"bottom\",\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\".ue_graphic_el img\",\"selector_value\":\"object-position:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_boxshadow\",\"title\":\"Box Shadow\",\"name\":\"notification_box_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"selector\":\".ue_notification\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color Hover\",\"name\":\"bg_color_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\".ue_notification:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_boxshadow\",\"title\":\"Box Shadow\",\"name\":\"notification_box_shadow_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"selector\":\".ue_notification:hover\",\"__attr_catid__\":\"cat_style_qv8a3gl1\"},{\"type\":\"uc_colorpicker\",\"title\":\"Description Color\",\"name\":\"text_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".ue_text\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_hvgz6bfj\"},{\"type\":\"uc_typography\",\"title\":\"Description Typography\",\"name\":\"text_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue_text\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_hvgz6bfj\"},{\"type\":\"uc_slider\",\"title\":\"Gap\",\"name\":\"text_gap\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px_percent_em\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_text\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_hvgz6bfj\"},{\"type\":\"uc_typography\",\"title\":\"Graphic Text Typography\",\"name\":\"graphic_text_typography\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"text\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue_graphic_el span\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_skvn3rjm\"},{\"type\":\"uc_dropdown\",\"title\":\"Button Position\",\"name\":\"button_position\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"not_equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Below Text\":\"column\",\"After Text\":\"row\"},\"default_value\":\"column\",\"selector\":\".ue_content\",\"selector_value\":\"flex-direction:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_dropdown\",\"title\":\"Button Alignment\",\"name\":\"button_alignment\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"button_position\",\"condition_operator\":\"equal\",\"condition_value\":[\"column\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"flex-start\",\"Center\":\"center\",\"Right\":\"flex-end\"},\"default_value\":\"flex-start\",\"selector\":\".ue_action\",\"selector_value\":\"justify-content:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_dropdown\",\"title\":\"Button Layout\",\"name\":\"button_layout\",\"description\":\"For Multiple Buttons\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Row\":\"flex-start\",\"Row Reverse\":\"row-reverse\",\"Column\":\"column\",\"Column Reverse\":\"column-reverse\"},\"default_value\":\"flex-start\",\"selector\":\".ue_action\",\"selector_value\":\"flex-direction:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_typography\",\"title\":\"Typography\",\"name\":\"btn_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ue_nf_btn\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_slider\",\"title\":\"Gap\",\"name\":\"btn_gap\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"not_equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px_percent_em\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_content\",\"selector_value\":\"gap: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_slider\",\"title\":\"Gap Between Buttons\",\"name\":\"gap_between_buttons\",\"description\":\"For Multiple Buttons\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"not_equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px_percent_em\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_action\",\"selector_value\":\"gap: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_padding\",\"title\":\"Paddiing\",\"name\":\"btn_paddiing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"10\",\"desktop_right\":\"20\",\"desktop_bottom\":\"10\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_nf_btn\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_border\",\"title\":\"Border\",\"name\":\"border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue_nf_btn\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_colorpicker\",\"title\":\"Label Color\",\"name\":\"btn_label_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"#ffffff\",\"selector\":\".ue_nf_btn\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color \",\"name\":\"background_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"#1f1f1f\",\"selector\":\".ue_nf_btn\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Border Radius\",\"name\":\"button_border_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_nf_btn\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_boxshadow\",\"title\":\"Box Shadow\",\"name\":\"btn_box_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"selector\":\".ue_nf_btn\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_colorpicker\",\"title\":\"Label Color\",\"name\":\"btn_label_color_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\".ue_nf_btn:hover\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color \",\"name\":\"background_color_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\".ue_nf_btn:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Border Radius\",\"name\":\"button_border_radius_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_nf_btn\",\"add_units\":\"\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_boxshadow\",\"title\":\"Box Shadow\",\"name\":\"btn_box_shadow_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"selector\":\".ue_nf_btn\",\"__attr_catid__\":\"cat_style_ysmbzrpr\"},{\"type\":\"uc_textfield\",\"title\":\"Close Text\",\"name\":\"close_text\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_close_button_text\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"Close\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_content_faa0l673\"},{\"type\":\"uc_colorpicker\",\"title\":\"Notification Close BG\",\"name\":\"close_bg\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"#000000\",\"selector\":\".ue_close_notification\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Notification Close Icon Color\",\"name\":\"notification_close_icon_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"#ffffff\",\"selector\":\".ue_close_notification i\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Close Text Color\",\"name\":\"close_text_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_close_button_text\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"#ffffff\",\"selector\":\".ue_close_notification span\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Notification Close BG\",\"name\":\"close_bg_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\".ue_close_notification:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Notification Close Icon Color\",\"name\":\"notification_close_icon_color_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\".ue_close_notification:hover i\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Close Text Color\",\"name\":\"close_text_color_hover\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_close_button_text\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\".ue_close_notification:hover span\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_xpskhji4\"},{\"type\":\"uc_number\",\"title\":\"Hover Transition Duration\",\"name\":\"hover_transition_duration\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"200\",\"unit\":\"ms\",\"unit_custom\":\"\",\"min_value\":\"0\",\"max_value\":\"2000\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_notification, .ue_nf_btn, .ue_close_notification\",\"selector_value\":\"transition: all {{VALUE}}ms;\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_g4o5ohwr\"},{\"type\":\"uc_special\",\"title\":\"Button Entrance Animation\",\"name\":\"entrance_animation\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"attribute_type\":\"entrance_animation\",\"entrance_animation_item_class\":\"ue_nf_btn\",\"schema_title_name\":\"\",\"schema_content_name\":\"\",\"image_size_param_name\":\"\",\"__attr_catid__\":\"cat_content_g4o5ohwr\"},{\"type\":\"uc_hover_animations\",\"title\":\"Button Hover Animation\",\"name\":\"button_hover_animation\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"__attr_catid__\":\"cat_content_g4o5ohwr\"},{\"type\":\"uc_template\",\"title\":\"Template\",\"name\":\"template\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_source\",\"condition_operator\":\"equal\",\"condition_value\":[\"template\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"__attr_catid__\":\"cat_content_2x63c0vm\"},{\"type\":\"uc_dropdown\",\"title\":\"Width\",\"name\":\"text_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Inline Auto\":\"auto\",\"Full Width\":\"100%\"},\"default_value\":\"auto\",\"selector\":\".ue_text_content\",\"selector_value\":\"width:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_tdx45oln\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Cookie\",\"name\":\"enable_cookie\",\"description\":\"When a cookie is set, the notification will not reappear if the notification is closed. The notification will reappear when the cookie expires.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_ev7ht8lv\"},{\"type\":\"uc_textfield\",\"title\":\"Cookie Name\",\"name\":\"cookie_name\",\"description\":\"Please enter a unique cookie name, each cookie name must be unique and cannot be set again within the same page.<br>ex: notification_for_product24\",\"enable_condition\":true,\"condition_attribute\":\"enable_cookie\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"\",\"default_value\":\"\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false,\"__attr_catid__\":\"cat_content_ev7ht8lv\"},{\"type\":\"uc_number\",\"title\":\"Expiration\",\"name\":\"cookie_exp_day\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"enable_cookie\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"unit\":\"other\",\"unit_custom\":\"Days\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_ev7ht8lv\"},{\"type\":\"uc_number\",\"title\":\"Expiration\",\"name\":\"cookie_exp_hour\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"enable_cookie\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"unit\":\"other\",\"unit_custom\":\"Hours\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_ev7ht8lv\"},{\"type\":\"uc_number\",\"title\":\"Expiration\",\"name\":\"cookie_exp_minutes\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"enable_cookie\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"60\",\"unit\":\"other\",\"unit_custom\":\"Minutes\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_ev7ht8lv\"},{\"type\":\"uc_number\",\"title\":\"Expiration\",\"name\":\"cookie_exp_sec\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"enable_cookie\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"60\",\"unit\":\"other\",\"unit_custom\":\"Seconds\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_ev7ht8lv\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Button Label\",\"name\":\"title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"Take Action\",\"font_editable\":false,\"placeholder\":\"\",\"disable_dynamic\":false},{\"type\":\"uc_link\",\"title\":\"Button Link\",\"name\":\"button_link\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Label Color\",\"name\":\"label_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"\",\"selector\":\"{{CURRENT_ITEM}}\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Background Color\",\"name\":\"btn_bg_clr\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"\",\"selector\":\"{{CURRENT_ITEM}}\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Border Color\",\"name\":\"border_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"\",\"selector\":\"{{CURRENT_ITEM}}\",\"selector_value\":\"border-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Label Color\",\"name\":\"label_color_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\"{{CURRENT_ITEM}}:hover\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Background Color\",\"name\":\"btn_bg_clr_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\"{{CURRENT_ITEM}}:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Border Color\",\"name\":\"border_color_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Hover\",\"default_value\":\"\",\"selector\":\"{{CURRENT_ITEM}}:hover\",\"selector_value\":\"border-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"}],\"includes\":{\"js\":[],\"jslib\":[\"jquery\",\"font-awsome\"],\"css\":[]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"enable_condition\":true,\"condition_attribute\":\"show_graphic_element\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_2x63c0vm\",\"title\":\"Graphic Element\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_faa0l673\",\"title\":\"Close Button\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_g4o5ohwr\",\"title\":\"Additional Settings\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_ev7ht8lv\",\"title\":\"Set Cookie\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"show_button\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_dge5saai\",\"title\":\"Button Source\",\"tab\":\"content\"},{\"id\":\"cat_style_qv8a3gl1\",\"title\":\"Style\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"show_title\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_tdx45oln\",\"title\":\"Notification Title\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"show_text\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_hvgz6bfj\",\"title\":\"Description\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"show_graphic_element\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_skvn3rjm\",\"title\":\"Graphic Element\",\"tab\":\"style\"},{\"id\":\"cat_style_xpskhji4\",\"title\":\"Close Button\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"show_button\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_ysmbzrpr\",\"title\":\"Button\",\"tab\":\"style\"}]}", "3", "1", NULL, "{\"config\":{\"show_title\":\"true\",\"notification_title\":\"Notification Title\",\"title_tag_unite_selected_text\":\"H3\",\"title_tag\":\"h3\",\"show_text\":\"true\",\"text\":\"This is a notification description to inform website visitors about important updates or events. This brief description serves as a friendly explanation of the latest happenings on the website.\",\"text_tag_unite_selected_text\":\"p\",\"text_tag\":\"p\",\"layout_unite_selected_text\":\"Row\",\"layout\":\"row\",\"bg\":\"#ebebeb\",\"horizontal_position_unite_selected_text\":\"Right\",\"horizontal_position\":\"right\",\"vertical_position_unite_selected_text\":\"Top\",\"vertical_position\":\"top\",\"horizontal_push\":\"0\",\"vertical_push\":\"0\",\"close_btn_padding\":{\"top\":\"6\",\"right\":\"15\",\"bottom\":\"6\",\"left\":\"15\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"show_button\":\"true\",\"show_graphic_element\":\"true\",\"align_content_unite_selected_text\":\"Start\",\"align_content\":\"flex-start\",\"text_alignment_unite_selected_text\":\"Left\",\"text_alignment\":\"left\",\"button_alignment_unite_selected_text\":\"Left\",\"button_alignment\":\"flex-start\",\"notification_padding\":{\"top\":\"30\",\"right\":\"30\",\"bottom\":\"30\",\"left\":\"30\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"notification_radius\":{\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"close\":\"fas fa-times\",\"show_close_button_text\":\"true\",\"close_radius\":{\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"close_button_icon_size\":\"15\",\"close_button_icon_size_tablet\":\"\",\"close_button_icon_size_mobile\":\"\",\"title_color\":\"#000000\",\"icon_source_unite_selected_text\":\"Icon\",\"icon_source\":\"icon\",\"source_source_unite_selected_text\":\"Items\",\"source_source\":\"items\",\"graphic_icon\":\"far fa-bell\",\"graphic_image\":\"[url_assets]\\/default_img.png\",\"graphic_text\":\"\",\"graphic_elm_gap\":\"20\",\"graphic_elm_gap_tablet\":\"\",\"graphic_elm_gap_mobile\":\"\",\"graphic_el_margin\":{\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"graphic_wrp_width\":\"72\",\"graphic_wrp_width_tablet\":\"\",\"graphic_wrp_width_mobile\":\"\",\"graphic_wrp_height\":\"72\",\"graphic_wrp_height_tablet\":\"\",\"graphic_wrp_height_mobile\":\"\",\"graphic_bg_color\":\"#000000\",\"graphic_el_border_radius\":{\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"graphic_elm_color\":\"#ffffff\",\"graphic_icon_size\":\"24\",\"graphic_icon_size_tablet\":\"\",\"graphic_icon_size_mobile\":\"\",\"image_fit_unite_selected_text\":\"Cover\",\"image_fit\":\"cover\",\"text_color\":\"#000000\",\"text_gap\":\"0\",\"text_gap_tablet\":\"\",\"text_gap_mobile\":\"\",\"btn_margin_top\":\"10\",\"btn_margin_top_tablet\":\"\",\"btn_margin_top_mobile\":\"\",\"btn_gap\":\"10\",\"btn_gap_tablet\":\"\",\"btn_gap_mobile\":\"\",\"btn_paddiing\":{\"top\":\"10\",\"right\":\"20\",\"bottom\":\"10\",\"left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"btn_label_color\":\"#ffffff\",\"background_color\":\"#1f1f1f\",\"button_border_radius\":{\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"btn_label_color_hover\":\"#ffffff\",\"background_color_hover\":\"#3800a0\",\"button_border_radius_hover\":{\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"close_text\":\"Close\",\"close_bg\":\"#000000\",\"notification_close_icon_color\":\"#ffffff\",\"close_bg_hover\":\"#140068\",\"notification_close_icon_color_hover\":\"#ffffff\",\"close_text_gap\":\"8\",\"close_text_gap_tablet\":\"\",\"close_text_gap_mobile\":\"\",\"close_text_color\":\"#ffffff\",\"close_text_color_hover\":\"#ffffff\"},\"items\":[{\"title\":\"Know More\",\"button_link\":\"\",\"label_color\":\"\",\"btn_bg_clr\":\"\"}]}", NULL);

/* INSERT TABLE DATA: ethr_addonlibrary_categories */
INSERT INTO `ethr_addonlibrary_categories` VALUES("1", "WooCommerce", "woocommerce", "1", "", "elementor", NULL);
INSERT INTO `ethr_addonlibrary_categories` VALUES("2", "Carousel Widgets", "carousel_widgets", "2", "", "elementor", NULL);
INSERT INTO `ethr_addonlibrary_categories` VALUES("3", "Tools", "tools", "3", "", "elementor", NULL);

/* INSERT TABLE DATA: ethr_aiowps_audit_log */
INSERT INTO `ethr_aiowps_audit_log` VALUES("15", "1", "1", "salecius", "35.219.54.159", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"salecius\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:495;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:201;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:106;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711114472");
INSERT INTO `ethr_aiowps_audit_log` VALUES("16", "1", "1", "salecius", "3.250.88.126", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"salecius\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:495;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:201;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:106;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711115265");
INSERT INTO `ethr_aiowps_audit_log` VALUES("17", "1", "1", "salecius", "105.163.157.158", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:546;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:582;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:618;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451111");
INSERT INTO `ethr_aiowps_audit_log` VALUES("18", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Akismet Anti-spam: Spam Protection\",\"version\":\"5.3.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:265;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:189;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451228");
INSERT INTO `ethr_aiowps_audit_log` VALUES("19", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"All In One WP Security\",\"version\":\"5.2.9\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:265;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:189;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451236");
INSERT INTO `ethr_aiowps_audit_log` VALUES("20", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"CartFlows\",\"version\":\"2.0.5\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451251");
INSERT INTO `ethr_aiowps_audit_log` VALUES("21", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.20.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451266");
INSERT INTO `ethr_aiowps_audit_log` VALUES("22", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Elementor Header &amp; Footer Builder\",\"version\":\"1.6.26\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451293");
INSERT INTO `ethr_aiowps_audit_log` VALUES("23", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"5.9.13\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451314");
INSERT INTO `ethr_aiowps_audit_log` VALUES("24", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Google Listings and Ads\",\"version\":\"2.6.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451332");
INSERT INTO `ethr_aiowps_audit_log` VALUES("25", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"SpeedyCache\",\"version\":\"1.1.5\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451338");
INSERT INTO `ethr_aiowps_audit_log` VALUES("26", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"SpeedyCache Pro\",\"version\":\"1.1.5\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451345");
INSERT INTO `ethr_aiowps_audit_log` VALUES("27", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Starter Templates\",\"version\":\"4.1.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451354");
INSERT INTO `ethr_aiowps_audit_log` VALUES("28", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Unlimited Elements for Elementor\",\"version\":\"1.5.100\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451361");
INSERT INTO `ethr_aiowps_audit_log` VALUES("29", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooCommerce\",\"version\":\"8.7.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451375");
INSERT INTO `ethr_aiowps_audit_log` VALUES("30", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooCommerce Cart Abandonment Recovery\",\"version\":\"1.2.27\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451386");
INSERT INTO `ethr_aiowps_audit_log` VALUES("31", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooCommerce Shipping &amp; Tax\",\"version\":\"2.5.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451395");
INSERT INTO `ethr_aiowps_audit_log` VALUES("32", "1", "1", "salecius", "105.163.157.158", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooPayments\",\"version\":\"7.3.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711451402");
INSERT INTO `ethr_aiowps_audit_log` VALUES("33", "1", "1", "salecius", "105.163.157.201", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711488837");
INSERT INTO `ethr_aiowps_audit_log` VALUES("34", "1", "1", "salecius", "105.163.157.201", "info", "theme_updated", "{\"theme\":{\"name\":\"Astra\",\"version\":\"4.6.9\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:394;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:327;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"theme_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:80:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:484;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4347;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_ajax_update_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711494437");
INSERT INTO `ethr_aiowps_audit_log` VALUES("35", "1", "1", "salecius", "105.163.0.144", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711572309");
INSERT INTO `ethr_aiowps_audit_log` VALUES("36", "1", "1", "salecius", "35.208.17.77", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"salecius\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:106;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711814757");
INSERT INTO `ethr_aiowps_audit_log` VALUES("37", "1", "1", "salecius", "105.163.157.85", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711968772");
INSERT INTO `ethr_aiowps_audit_log` VALUES("38", "1", "1", "salecius", "105.163.157.85", "info", "plugin_updated", "{\"plugin\":{\"name\":\"CartFlows\",\"version\":\"2.0.6\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711968823");
INSERT INTO `ethr_aiowps_audit_log` VALUES("39", "1", "1", "salecius", "105.163.157.85", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Checkout Plugins - Stripe for WooCommerce\",\"version\":\"1.8.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711968829");
INSERT INTO `ethr_aiowps_audit_log` VALUES("40", "1", "1", "salecius", "105.163.157.85", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"5.9.14\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711968836");
INSERT INTO `ethr_aiowps_audit_log` VALUES("41", "1", "1", "salecius", "105.163.157.85", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Starter Templates\",\"version\":\"4.1.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711968845");
INSERT INTO `ethr_aiowps_audit_log` VALUES("42", "1", "1", "salecius", "105.163.157.85", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Variation Swatches for WooCommerce\",\"version\":\"1.0.8\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711968850");
INSERT INTO `ethr_aiowps_audit_log` VALUES("43", "1", "1", "salecius", "105.163.157.85", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooPayments\",\"version\":\"7.4.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4627;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:188;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1711968859");
INSERT INTO `ethr_aiowps_audit_log` VALUES("44", "1", "1", "", "38.111.114.212", "info", "core_updated", "{\"core_updated\":{\"old_version\":\"6.4.3\",\"new_version\":\"6.5\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:146;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:71:\"/home/estheram/store.estheramunga.com/wp-admin/includes/update-core.php\";s:4:\"line\";i:1505;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:79:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:174;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:86:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:459;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:86:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:550;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/update.php\";s:4:\"line\";i:852;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/update.php\";s:4:\"line\";i:292;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:49:\"/home/estheram/store.estheramunga.com/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712102339");
INSERT INTO `ethr_aiowps_audit_log` VALUES("45", "1", "1", "salecius", "105.163.2.159", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712105657");
INSERT INTO `ethr_aiowps_audit_log` VALUES("46", "1", "1", "salecius", "105.163.2.159", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712239426");
INSERT INTO `ethr_aiowps_audit_log` VALUES("47", "1", "1", "salecius", "105.163.2.159", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Starter Templates\",\"version\":\"4.1.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712239571");
INSERT INTO `ethr_aiowps_audit_log` VALUES("48", "1", "1", "salecius", "105.163.2.159", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Unlimited Elements for Elementor\",\"version\":\"1.5.101\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712239589");
INSERT INTO `ethr_aiowps_audit_log` VALUES("49", "1", "1", "salecius", "105.163.2.159", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"SpeedyCache\",\"version\":\"1.1.5\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:842;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712240556");
INSERT INTO `ethr_aiowps_audit_log` VALUES("50", "1", "1", "salecius", "105.163.2.159", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"SpeedyCache Pro\",\"version\":\"1.1.5\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:842;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:253;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712240557");
INSERT INTO `ethr_aiowps_audit_log` VALUES("51", "1", "1", "", "38.111.114.212", "info", "core_updated", "{\"core_updated\":{\"old_version\":\"6.5\",\"new_version\":\"6.5.2\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:146;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:71:\"/home/estheram/store.estheramunga.com/wp-admin/includes/update-core.php\";s:4:\"line\";i:1505;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:79:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:174;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:86:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:459;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:86:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:550;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/update.php\";s:4:\"line\";i:852;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/update.php\";s:4:\"line\";i:292;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:49:\"/home/estheram/store.estheramunga.com/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712718659");
INSERT INTO `ethr_aiowps_audit_log` VALUES("52", "1", "1", "salecius", "13.234.84.123", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"salecius\",\"known\":true}}", "a:19:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:76:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:297;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:6:{s:4:\"file\";s:76:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:4840;s:8:\"function\";s:5:\"login\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:76:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:709;s:8:\"function\";s:21:\"blogger_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:74:\"/home/estheram/store.estheramunga.com/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:16:\"wp_getUsersBlogs\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:74:\"/home/estheram/store.estheramunga.com/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:207;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:74:\"/home/estheram/store.estheramunga.com/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:109;s:8:\"function\";s:9:\"multiCall\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:74:\"/home/estheram/store.estheramunga.com/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:59;s:8:\"function\";s:4:\"call\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:74:\"/home/estheram/store.estheramunga.com/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:27;s:8:\"function\";s:5:\"serve\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:74:\"/home/estheram/store.estheramunga.com/wp-includes/IXR/class-IXR-server.php\";s:4:\"line\";i:35;s:8:\"function\";s:11:\"__construct\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:76:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-xmlrpc-server.php\";s:4:\"line\";i:246;s:8:\"function\";s:10:\"IXR_Server\";s:5:\"class\";s:10:\"IXR_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:48:\"/home/estheram/store.estheramunga.com/xmlrpc.php\";s:4:\"line\";i:87;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:16:\"wp_xmlrpc_server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712738990");
INSERT INTO `ethr_aiowps_audit_log` VALUES("53", "1", "1", "salecius", "23.97.205.210", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"salecius\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:106;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712813104");
INSERT INTO `ethr_aiowps_audit_log` VALUES("54", "1", "1", "salecius", "35.219.54.159", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"salecius\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:106;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1712894465");
INSERT INTO `ethr_aiowps_audit_log` VALUES("55", "1", "1", "salecius", "105.163.157.73", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713008937");
INSERT INTO `ethr_aiowps_audit_log` VALUES("56", "1", "1", "salecius", "105.163.157.73", "info", "plugin_installed", "{\"plugin\":{\"name\":\"UpdraftPlus - Backup\\/Restore\",\"version\":\"1.24.2\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:165;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:77:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:961;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4489;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713008986");
INSERT INTO `ethr_aiowps_audit_log` VALUES("57", "1", "1", "salecius", "105.163.157.73", "info", "plugin_activated", "{\"plugin\":{\"name\":\"UpdraftPlus - Backup\\/Restore\",\"version\":\"1.24.2\",\"action\":\"activated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4584;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_ajax_activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713008998");
INSERT INTO `ethr_aiowps_audit_log` VALUES("58", "1", "1", "salecius", "105.163.158.69", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713175739");
INSERT INTO `ethr_aiowps_audit_log` VALUES("59", "1", "1", "salecius", "108.208.64.81", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713392832");
INSERT INTO `ethr_aiowps_audit_log` VALUES("60", "1", "1", "salecius", "105.163.1.31", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745259");
INSERT INTO `ethr_aiowps_audit_log` VALUES("61", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.21.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745563");
INSERT INTO `ethr_aiowps_audit_log` VALUES("62", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Elementor Header &amp; Footer Builder\",\"version\":\"1.6.28\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745571");
INSERT INTO `ethr_aiowps_audit_log` VALUES("63", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"5.9.15\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745582");
INSERT INTO `ethr_aiowps_audit_log` VALUES("64", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Google Listings and Ads\",\"version\":\"2.6.7\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745594");
INSERT INTO `ethr_aiowps_audit_log` VALUES("65", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"GoSMTP\",\"version\":\"1.0.6\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745603");
INSERT INTO `ethr_aiowps_audit_log` VALUES("66", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"SpeedyCache\",\"version\":\"1.1.6\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745613");
INSERT INTO `ethr_aiowps_audit_log` VALUES("67", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Starter Templates\",\"version\":\"4.1.6\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745624");
INSERT INTO `ethr_aiowps_audit_log` VALUES("68", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Unlimited Elements for Elementor\",\"version\":\"1.5.103\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745633");
INSERT INTO `ethr_aiowps_audit_log` VALUES("69", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooPayments\",\"version\":\"7.5.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745643");
INSERT INTO `ethr_aiowps_audit_log` VALUES("70", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooCommerce\",\"version\":\"8.8.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713745660");
INSERT INTO `ethr_aiowps_audit_log` VALUES("71", "1", "1", "salecius", "105.163.1.31", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713877494");
INSERT INTO `ethr_aiowps_audit_log` VALUES("72", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooPayments\",\"version\":\"7.5.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713878458");
INSERT INTO `ethr_aiowps_audit_log` VALUES("73", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"5.9.16\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713878525");
INSERT INTO `ethr_aiowps_audit_log` VALUES("74", "1", "1", "salecius", "105.163.1.31", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713878743");
INSERT INTO `ethr_aiowps_audit_log` VALUES("75", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Google Listings and Ads\",\"version\":\"2.6.8\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713879113");
INSERT INTO `ethr_aiowps_audit_log` VALUES("76", "1", "1", "salecius", "105.163.1.31", "info", "theme_updated", "{\"theme\":{\"name\":\"Twenty Twenty-Four\",\"version\":\"1.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:394;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:327;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"theme_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:80:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:520;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4315;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_ajax_update_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713879139");
INSERT INTO `ethr_aiowps_audit_log` VALUES("77", "1", "1", "salecius", "105.163.1.31", "info", "theme_updated", "{\"theme\":{\"name\":\"Astra\",\"version\":\"4.6.12\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:394;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:327;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"theme_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:80:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:520;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4315;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_ajax_update_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713879148");
INSERT INTO `ethr_aiowps_audit_log` VALUES("78", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Starter Templates\",\"version\":\"4.1.7\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713879414");
INSERT INTO `ethr_aiowps_audit_log` VALUES("79", "1", "1", "salecius", "105.163.1.31", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713986624");
INSERT INTO `ethr_aiowps_audit_log` VALUES("80", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"CartFlows\",\"version\":\"2.0.7\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713986663");
INSERT INTO `ethr_aiowps_audit_log` VALUES("81", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.21.2\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713986679");
INSERT INTO `ethr_aiowps_audit_log` VALUES("82", "1", "1", "salecius", "105.163.1.31", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Unlimited Elements for Elementor\",\"version\":\"1.5.104\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713986697");
INSERT INTO `ethr_aiowps_audit_log` VALUES("83", "1", "1", "salecius", "20.101.95.92", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"salecius\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:106;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713991085");
INSERT INTO `ethr_aiowps_audit_log` VALUES("84", "1", "1", "salecius", "34.93.16.66", "warning", "failed_login", "{\"failed_login\":{\"imported\":false,\"username\":\"salecius\",\"known\":true}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:570;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:203;s:8:\"function\";s:18:\"event_failed_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:17:\"post_authenticate\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:0:{}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:205;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:618;s:8:\"function\";s:13:\"apply_filters\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:106;s:8:\"function\";s:15:\"wp_authenticate\";s:4:\"args\";a:0:{}}i:9;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1713999466");
INSERT INTO `ethr_aiowps_audit_log` VALUES("85", "1", "1", "salecius", "105.163.158.3", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714090802");
INSERT INTO `ethr_aiowps_audit_log` VALUES("86", "1", "1", "salecius", "105.163.158.3", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Flexible Shipping\",\"version\":\"4.24.19\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:165;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:77:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:961;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4489;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714091203");
INSERT INTO `ethr_aiowps_audit_log` VALUES("87", "1", "1", "salecius", "105.163.158.3", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Flexible Shipping\",\"version\":\"4.24.19\",\"action\":\"activated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4584;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_ajax_activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714091397");
INSERT INTO `ethr_aiowps_audit_log` VALUES("88", "1", "1", "salecius", "105.163.158.3", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.21.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714093142");
INSERT INTO `ethr_aiowps_audit_log` VALUES("89", "1", "1", "salecius", "105.163.158.3", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"5.9.17\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714093163");
INSERT INTO `ethr_aiowps_audit_log` VALUES("90", "1", "1", "salecius", "105.163.1.204", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714579473");
INSERT INTO `ethr_aiowps_audit_log` VALUES("91", "1", "1", "salecius", "105.163.1.204", "info", "plugin_updated", "{\"plugin\":{\"name\":\"All In One WP Security\",\"version\":\"5.3.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714605876");
INSERT INTO `ethr_aiowps_audit_log` VALUES("92", "1", "1", "salecius", "105.163.1.204", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.21.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714605911");
INSERT INTO `ethr_aiowps_audit_log` VALUES("93", "1", "1", "salecius", "105.163.1.204", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"5.9.18\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714605919");
INSERT INTO `ethr_aiowps_audit_log` VALUES("94", "1", "1", "salecius", "105.163.1.204", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Starter Templates\",\"version\":\"4.2.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714605928");
INSERT INTO `ethr_aiowps_audit_log` VALUES("95", "1", "1", "salecius", "105.163.1.204", "info", "plugin_updated", "{\"plugin\":{\"name\":\"UpdraftPlus - Backup\\/Restore\",\"version\":\"1.24.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714605938");
INSERT INTO `ethr_aiowps_audit_log` VALUES("96", "1", "1", "salecius", "105.163.1.204", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooCommerce\",\"version\":\"8.8.3\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714605956");
INSERT INTO `ethr_aiowps_audit_log` VALUES("97", "1", "1", "salecius", "105.163.1.204", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooCommerce Shipping &amp; Tax\",\"version\":\"2.5.5\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714605965");
INSERT INTO `ethr_aiowps_audit_log` VALUES("98", "1", "1", "salecius", "87.250.179.76", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WooCommerce.com Update Manager\",\"version\":\"1.0.2\",\"action\":\"activated\",\"network\":\"\"}}", "a:28:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:179:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/installation-steps/class-wc-wccom-site-installation-step-activate-product.php\";s:4:\"line\";i:82;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:179:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/installation-steps/class-wc-wccom-site-installation-step-activate-product.php\";s:4:\"line\";i:41;s:8:\"function\";s:15:\"activate_plugin\";s:5:\"class\";s:48:\"WC_WCCOM_Site_Installation_Step_Activate_Product\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:192;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:48:\"WC_WCCOM_Site_Installation_Step_Activate_Product\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:77;s:8:\"function\";s:8:\"run_step\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:8:\"function\";s:9:\"{closure}\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:78;s:8:\"function\";s:10:\"array_walk\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:157:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/rest-api/endpoints/class-wc-rest-wccom-site-installer-controller.php\";s:4:\"line\";i:111;s:8:\"function\";s:16:\"run_installation\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1230;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:39:\"WC_REST_WCCOM_Site_Installer_Controller\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1063;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api.php\";s:4:\"line\";i:428;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:24;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:813;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:25;a:6:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/functions.php\";s:4:\"line\";i:1336;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:26;a:4:{s:4:\"file\";s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:27;a:4:{s:4:\"file\";s:47:\"/home/estheram/store.estheramunga.com/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1714607099");
INSERT INTO `ethr_aiowps_audit_log` VALUES("99", "1", "1", "salecius", "87.250.179.75", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WooCommerce USPS Shipping\",\"version\":\"4.8.3\",\"action\":\"activated\",\"network\":\"\"}}", "a:28:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:179:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/installation-steps/class-wc-wccom-site-installation-step-activate-product.php\";s:4:\"line\";i:82;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:179:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/installation-steps/class-wc-wccom-site-installation-step-activate-product.php\";s:4:\"line\";i:41;s:8:\"function\";s:15:\"activate_plugin\";s:5:\"class\";s:48:\"WC_WCCOM_Site_Installation_Step_Activate_Product\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:192;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:48:\"WC_WCCOM_Site_Installation_Step_Activate_Product\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:77;s:8:\"function\";s:8:\"run_step\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:8:\"function\";s:9:\"{closure}\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:78;s:8:\"function\";s:10:\"array_walk\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:157:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/rest-api/endpoints/class-wc-rest-wccom-site-installer-controller.php\";s:4:\"line\";i:111;s:8:\"function\";s:16:\"run_installation\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1230;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:39:\"WC_REST_WCCOM_Site_Installer_Controller\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1063;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api.php\";s:4:\"line\";i:428;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:24;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:813;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:25;a:6:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/functions.php\";s:4:\"line\";i:1336;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:26;a:4:{s:4:\"file\";s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:27;a:4:{s:4:\"file\";s:47:\"/home/estheram/store.estheramunga.com/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1714607213");
INSERT INTO `ethr_aiowps_audit_log` VALUES("100", "1", "1", "salecius", "12.14.27.114", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714661949");
INSERT INTO `ethr_aiowps_audit_log` VALUES("101", "1", "1", "salecius", "12.14.27.114", "info", "successful_logout", "{\"successful_logout\":{\"username\":\"salecius\",\"force_logout\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:639;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:681;s:8:\"function\";s:23:\"event_successful_logout\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:24:\"wp_logout_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/pluggable.php\";s:4:\"line\";i:671;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:793;s:8:\"function\";s:9:\"wp_logout\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714664199");
INSERT INTO `ethr_aiowps_audit_log` VALUES("102", "1", "1", "salecius", "12.14.27.114", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714666241");
INSERT INTO `ethr_aiowps_audit_log` VALUES("103", "1", "1", "salecius", "12.14.27.114", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714666251");
INSERT INTO `ethr_aiowps_audit_log` VALUES("104", "1", "1", "salecius", "12.14.27.114", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714676878");
INSERT INTO `ethr_aiowps_audit_log` VALUES("105", "1", "1", "salecius", "12.14.27.114", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714677052");
INSERT INTO `ethr_aiowps_audit_log` VALUES("106", "1", "1", "salecius", "105.163.2.201", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714772978");
INSERT INTO `ethr_aiowps_audit_log` VALUES("107", "1", "1", "salecius", "105.163.2.201", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Checkout Plugins - Stripe for WooCommerce\",\"version\":\"1.8.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714774379");
INSERT INTO `ethr_aiowps_audit_log` VALUES("108", "1", "1", "salecius", "105.163.2.201", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Starter Templates\",\"version\":\"4.2.1\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714774401");
INSERT INTO `ethr_aiowps_audit_log` VALUES("109", "1", "1", "salecius", "105.163.2.201", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"WooCommerce Shipping &amp; Tax\",\"version\":\"2.5.5\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:842;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714774842");
INSERT INTO `ethr_aiowps_audit_log` VALUES("110", "1", "1", "salecius", "87.250.179.90", "info", "plugin_activated", "{\"plugin\":{\"name\":\"TaxJar - Sales Tax Automation for WooCommerce\",\"version\":\"4.2.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:28:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:179:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/installation-steps/class-wc-wccom-site-installation-step-activate-product.php\";s:4:\"line\";i:82;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:179:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/installation-steps/class-wc-wccom-site-installation-step-activate-product.php\";s:4:\"line\";i:41;s:8:\"function\";s:15:\"activate_plugin\";s:5:\"class\";s:48:\"WC_WCCOM_Site_Installation_Step_Activate_Product\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:192;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:48:\"WC_WCCOM_Site_Installation_Step_Activate_Product\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:77;s:8:\"function\";s:8:\"run_step\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:8:\"function\";s:9:\"{closure}\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:78;s:8:\"function\";s:10:\"array_walk\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:157:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/rest-api/endpoints/class-wc-rest-wccom-site-installer-controller.php\";s:4:\"line\";i:111;s:8:\"function\";s:16:\"run_installation\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1230;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:39:\"WC_REST_WCCOM_Site_Installer_Controller\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1063;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api.php\";s:4:\"line\";i:428;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:24;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:813;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:25;a:6:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/functions.php\";s:4:\"line\";i:1336;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:26;a:4:{s:4:\"file\";s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:27;a:4:{s:4:\"file\";s:47:\"/home/estheram/store.estheramunga.com/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1714775472");
INSERT INTO `ethr_aiowps_audit_log` VALUES("111", "1", "1", "salecius", "105.163.2.201", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"TaxJar - Sales Tax Automation for WooCommerce\",\"version\":\"4.2.1\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:842;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714779189");
INSERT INTO `ethr_aiowps_audit_log` VALUES("112", "1", "1", "salecius", "105.163.2.201", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WooCommerce Shipping &amp; Tax\",\"version\":\"2.5.5\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1714779303");
INSERT INTO `ethr_aiowps_audit_log` VALUES("113", "1", "1", "salecius", "105.163.158.77", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023141");
INSERT INTO `ethr_aiowps_audit_log` VALUES("114", "1", "1", "salecius", "105.163.158.77", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"5.9.19\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023194");
INSERT INTO `ethr_aiowps_audit_log` VALUES("115", "1", "1", "salecius", "105.163.158.77", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Unlimited Elements for Elementor\",\"version\":\"1.5.105\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023205");
INSERT INTO `ethr_aiowps_audit_log` VALUES("116", "1", "1", "salecius", "105.163.158.77", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooCommerce Shipping &amp; Tax\",\"version\":\"2.5.6\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023214");
INSERT INTO `ethr_aiowps_audit_log` VALUES("117", "1", "1", "salecius", "105.163.158.77", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"WooCommerce USPS Shipping\",\"version\":\"4.8.3\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:842;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023288");
INSERT INTO `ethr_aiowps_audit_log` VALUES("118", "1", "1", "salecius", "105.163.158.77", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WooCommerce USPS Shipping\",\"version\":\"4.8.3\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023315");
INSERT INTO `ethr_aiowps_audit_log` VALUES("119", "1", "1", "salecius", "105.163.158.77", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"WooCommerce USPS Shipping\",\"version\":\"4.8.3\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:842;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023534");
INSERT INTO `ethr_aiowps_audit_log` VALUES("120", "1", "1", "salecius", "105.163.158.77", "warning", "plugin_deleted", "{\"plugin\":{\"name\":\"WooCommerce USPS Shipping\",\"version\":\"4.8.3\",\"action\":\"deleted\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:239;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_deleted\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:1004;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4766;s:8:\"function\";s:14:\"delete_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_delete_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023559");
INSERT INTO `ethr_aiowps_audit_log` VALUES("121", "1", "1", "salecius", "105.163.158.77", "info", "plugin_installed", "{\"plugin\":{\"name\":\"WooCommerce USPS Shipping\",\"version\":\"4.8.3\",\"action\":\"installed\",\"network\":\"\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:165;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:77:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:961;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:57:\"/home/estheram/store.estheramunga.com/wp-admin/update.php\";s:4:\"line\";i:180;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023593");
INSERT INTO `ethr_aiowps_audit_log` VALUES("122", "1", "1", "salecius", "105.163.158.77", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WooCommerce USPS Shipping\",\"version\":\"4.8.3\",\"action\":\"activated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:60;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715023604");
INSERT INTO `ethr_aiowps_audit_log` VALUES("123", "1", "1", "salecius", "105.163.158.77", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"WooCommerce Shipping &amp; Tax\",\"version\":\"2.5.6\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:842;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715024527");
INSERT INTO `ethr_aiowps_audit_log` VALUES("124", "1", "1", "salecius", "105.163.158.77", "warning", "plugin_deactivated", "{\"plugin\":{\"name\":\"Flexible Shipping\",\"version\":\"4.24.19\",\"action\":\"deactivated\",\"network\":\"\"}}", "a:10:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:213;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:18:\"plugin_deactivated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:842;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-admin/plugins.php\";s:4:\"line\";i:211;s:8:\"function\";s:18:\"deactivate_plugins\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715026887");
INSERT INTO `ethr_aiowps_audit_log` VALUES("125", "1", "1", "salecius", "192.0.100.17", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Jetpack\",\"version\":\"13.3.1\",\"action\":\"installed\",\"network\":\"\"}}", "a:23:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:165;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:77:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:961;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:105:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/endpoints/class-wp-rest-plugins-controller.php\";s:4:\"line\";i:313;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1230;s:8:\"function\";s:11:\"create_item\";s:5:\"class\";s:26:\"WP_REST_Plugins_Controller\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1063;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api.php\";s:4:\"line\";i:428;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:813;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:6:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/functions.php\";s:4:\"line\";i:1336;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:4:{s:4:\"file\";s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:4:{s:4:\"file\";s:47:\"/home/estheram/store.estheramunga.com/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1715093756");
INSERT INTO `ethr_aiowps_audit_log` VALUES("126", "1", "1", "salecius", "192.0.101.156", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Jetpack\",\"version\":\"13.3.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:23:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:105:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/endpoints/class-wp-rest-plugins-controller.php\";s:4:\"line\";i:755;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:105:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/endpoints/class-wp-rest-plugins-controller.php\";s:4:\"line\";i:473;s:8:\"function\";s:20:\"handle_plugin_status\";s:5:\"class\";s:26:\"WP_REST_Plugins_Controller\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1230;s:8:\"function\";s:11:\"update_item\";s:5:\"class\";s:26:\"WP_REST_Plugins_Controller\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1063;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api.php\";s:4:\"line\";i:428;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:4:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:813;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:6:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/functions.php\";s:4:\"line\";i:1336;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:4:{s:4:\"file\";s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:4:{s:4:\"file\";s:47:\"/home/estheram/store.estheramunga.com/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1715093790");
INSERT INTO `ethr_aiowps_audit_log` VALUES("127", "1", "1", "salecius", "105.163.1.72", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715105539");
INSERT INTO `ethr_aiowps_audit_log` VALUES("128", "1", "1", "", "38.111.114.212", "info", "core_updated", "{\"core_updated\":{\"old_version\":\"6.5.2\",\"new_version\":\"6.5.3\"}}", "a:20:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:146;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"core_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:4:{s:4:\"file\";s:71:\"/home/estheram/store.estheramunga.com/wp-admin/includes/update-core.php\";s:4:\"line\";i:1505;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:79:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-core-upgrader.php\";s:4:\"line\";i:174;s:8:\"function\";s:11:\"update_core\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:86:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:459;s:8:\"function\";s:7:\"upgrade\";s:5:\"class\";s:13:\"Core_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:86:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-automatic-updater.php\";s:4:\"line\";i:550;s:8:\"function\";s:6:\"update\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/update.php\";s:4:\"line\";i:852;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:20:\"WP_Automatic_Updater\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_maybe_auto_update\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:4:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/update.php\";s:4:\"line\";i:292;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"wp_version_check\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:4:{s:4:\"file\";s:49:\"/home/estheram/store.estheramunga.com/wp-cron.php\";s:4:\"line\";i:191;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715126727");
INSERT INTO `ethr_aiowps_audit_log` VALUES("129", "1", "1", "salecius", "87.250.179.70", "info", "plugin_activated", "{\"plugin\":{\"name\":\"WooCommerce Shipping &amp; Tax\",\"version\":\"2.5.6\",\"action\":\"activated\",\"network\":\"\"}}", "a:28:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:179:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/installation-steps/class-wc-wccom-site-installation-step-activate-product.php\";s:4:\"line\";i:82;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:179:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/installation-steps/class-wc-wccom-site-installation-step-activate-product.php\";s:4:\"line\";i:41;s:8:\"function\";s:15:\"activate_plugin\";s:5:\"class\";s:48:\"WC_WCCOM_Site_Installation_Step_Activate_Product\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:192;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:48:\"WC_WCCOM_Site_Installation_Step_Activate_Product\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:77;s:8:\"function\";s:8:\"run_step\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:8:\"function\";s:9:\"{closure}\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:146:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/installation/class-wc-wccom-site-installation-manager.php\";s:4:\"line\";i:78;s:8:\"function\";s:10:\"array_walk\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:15;a:6:{s:4:\"file\";s:157:\"/home/estheram/store.estheramunga.com/wp-content/plugins/woocommerce/includes/wccom-site/rest-api/endpoints/class-wc-rest-wccom-site-installer-controller.php\";s:4:\"line\";i:111;s:8:\"function\";s:16:\"run_installation\";s:5:\"class\";s:34:\"WC_WCCOM_Site_Installation_Manager\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:16;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1230;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:39:\"WC_REST_WCCOM_Site_Installer_Controller\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:17;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:1063;s:8:\"function\";s:18:\"respond_to_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:18;a:6:{s:4:\"file\";s:83:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api/class-wp-rest-server.php\";s:4:\"line\";i:439;s:8:\"function\";s:8:\"dispatch\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:19;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/rest-api.php\";s:4:\"line\";i:428;s:8:\"function\";s:13:\"serve_request\";s:5:\"class\";s:14:\"WP_REST_Server\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:20;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:15:\"rest_api_loaded\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:21;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:22;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:565;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:23;a:4:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:418;s:8:\"function\";s:19:\"do_action_ref_array\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:24;a:6:{s:4:\"file\";s:62:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp.php\";s:4:\"line\";i:813;s:8:\"function\";s:13:\"parse_request\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:25;a:6:{s:4:\"file\";s:63:\"/home/estheram/store.estheramunga.com/wp-includes/functions.php\";s:4:\"line\";i:1336;s:8:\"function\";s:4:\"main\";s:5:\"class\";s:2:\"WP\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:26;a:4:{s:4:\"file\";s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";s:4:\"line\";i:16;s:8:\"function\";s:2:\"wp\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:27;a:4:{s:4:\"file\";s:47:\"/home/estheram/store.estheramunga.com/index.php\";s:4:\"line\";i:17;s:4:\"args\";a:1:{i:0;s:56:\"/home/estheram/store.estheramunga.com/wp-blog-header.php\";}s:8:\"function\";s:7:\"require\";}}", "1715185160");
INSERT INTO `ethr_aiowps_audit_log` VALUES("130", "1", "1", "salecius", "12.14.27.114", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715185367");
INSERT INTO `ethr_aiowps_audit_log` VALUES("131", "1", "1", "salecius", "105.163.1.72", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715186682");
INSERT INTO `ethr_aiowps_audit_log` VALUES("132", "1", "1", "salecius", "12.14.27.114", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooCommerce USPS Shipping\",\"version\":\"4.8.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715186777");
INSERT INTO `ethr_aiowps_audit_log` VALUES("133", "1", "1", "salecius", "105.163.1.72", "info", "plugin_installed", "{\"plugin\":{\"name\":\"LiteSpeed Cache\",\"version\":\"6.2.0.1\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:165;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:77:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:961;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4489;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715189415");
INSERT INTO `ethr_aiowps_audit_log` VALUES("134", "1", "1", "salecius", "105.163.1.72", "info", "plugin_activated", "{\"plugin\":{\"name\":\"LiteSpeed Cache\",\"version\":\"6.2.0.1\",\"action\":\"activated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4584;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_ajax_activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715189434");
INSERT INTO `ethr_aiowps_audit_log` VALUES("135", "1", "1", "salecius", "105.163.1.72", "info", "theme_updated", "{\"theme\":{\"name\":\"Astra\",\"version\":\"4.6.14\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:394;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:327;s:8:\"function\";s:19:\"event_theme_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:13:\"theme_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:80:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-theme-upgrader.php\";s:4:\"line\";i:520;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4315;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:14:\"Theme_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:20:\"wp_ajax_update_theme\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715189541");
INSERT INTO `ethr_aiowps_audit_log` VALUES("136", "1", "1", "salecius", "105.163.1.72", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Elementor\",\"version\":\"3.21.5\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715189592");
INSERT INTO `ethr_aiowps_audit_log` VALUES("137", "1", "1", "salecius", "105.163.1.72", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Essential Addons for Elementor\",\"version\":\"5.9.20\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715189616");
INSERT INTO `ethr_aiowps_audit_log` VALUES("138", "1", "1", "salecius", "105.163.1.72", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Google Listings and Ads\",\"version\":\"2.6.9\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715189658");
INSERT INTO `ethr_aiowps_audit_log` VALUES("139", "1", "1", "salecius", "105.163.1.72", "info", "plugin_updated", "{\"plugin\":{\"name\":\"Jetpack\",\"version\":\"13.4\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715189688");
INSERT INTO `ethr_aiowps_audit_log` VALUES("140", "1", "1", "salecius", "105.163.1.72", "info", "plugin_updated", "{\"plugin\":{\"name\":\"WooPayments\",\"version\":\"7.6.0\",\"action\":\"updated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:198;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:14:\"plugin_updated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:421;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4645;s:8:\"function\";s:12:\"bulk_upgrade\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:21:\"wp_ajax_update_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715189716");
INSERT INTO `ethr_aiowps_audit_log` VALUES("141", "1", "1", "salecius", "105.163.157.207", "info", "successful_login", "{\"successful_login\":{\"username\":\"salecius\"}}", "a:11:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:621;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:589;s:8:\"function\";s:22:\"event_successful_login\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:127:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-user-login.php\";s:4:\"line\";i:634;s:8:\"function\";s:21:\"update_login_activity\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_login_action_handler\";s:5:\"class\";s:24:\"AIOWPSecurity_User_Login\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:58:\"/home/estheram/store.estheramunga.com/wp-includes/user.php\";s:4:\"line\";i:121;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:50:\"/home/estheram/store.estheramunga.com/wp-login.php\";s:4:\"line\";i:1311;s:8:\"function\";s:9:\"wp_signon\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715329100");
INSERT INTO `ethr_aiowps_audit_log` VALUES("142", "1", "1", "salecius", "105.163.157.207", "info", "plugin_installed", "{\"plugin\":{\"name\":\"Duplicator\",\"version\":\"1.5.9\",\"action\":\"installed\",\"network\":\"\"}}", "a:15:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:165;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_installed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:77:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-wp-upgrader.php\";s:4:\"line\";i:961;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:6:{s:4:\"file\";s:81:\"/home/estheram/store.estheramunga.com/wp-admin/includes/class-plugin-upgrader.php\";s:4:\"line\";i:137;s:8:\"function\";s:3:\"run\";s:5:\"class\";s:11:\"WP_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:6:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4489;s:8:\"function\";s:7:\"install\";s:5:\"class\";s:15:\"Plugin_Upgrader\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:22:\"wp_ajax_install_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:14;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715329284");
INSERT INTO `ethr_aiowps_audit_log` VALUES("143", "1", "1", "salecius", "105.163.157.207", "info", "plugin_activated", "{\"plugin\":{\"name\":\"Duplicator\",\"version\":\"1.5.9\",\"action\":\"activated\",\"network\":\"\"}}", "a:14:{i:0;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:12:\"record_event\";s:5:\"class\";s:33:\"AIOWPSecurity_Audit_Event_Handler\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:1;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:2;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:3;a:4:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:274;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:4;a:6:{s:4:\"file\";s:129:\"/home/estheram/store.estheramunga.com/wp-content/plugins/all-in-one-wp-security-and-firewall/classes/wp-security-audit-events.php\";s:4:\"line\";i:178;s:8:\"function\";s:20:\"event_plugin_changed\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:5;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:16:\"plugin_activated\";s:5:\"class\";s:26:\"AIOWPSecurity_Audit_Events\";s:4:\"type\";s:2:\"::\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:6;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:7;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:8;a:4:{s:4:\"file\";s:66:\"/home/estheram/store.estheramunga.com/wp-admin/includes/plugin.php\";s:4:\"line\";i:732;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:9;a:4:{s:4:\"file\";s:72:\"/home/estheram/store.estheramunga.com/wp-admin/includes/ajax-actions.php\";s:4:\"line\";i:4584;s:8:\"function\";s:15:\"activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:10;a:4:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:324;s:8:\"function\";s:23:\"wp_ajax_activate_plugin\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:11;a:6:{s:4:\"file\";s:67:\"/home/estheram/store.estheramunga.com/wp-includes/class-wp-hook.php\";s:4:\"line\";i:348;s:8:\"function\";s:13:\"apply_filters\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:12;a:6:{s:4:\"file\";s:60:\"/home/estheram/store.estheramunga.com/wp-includes/plugin.php\";s:4:\"line\";i:517;s:8:\"function\";s:9:\"do_action\";s:5:\"class\";s:7:\"WP_Hook\";s:4:\"type\";s:2:\"->\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}i:13;a:4:{s:4:\"file\";s:61:\"/home/estheram/store.estheramunga.com/wp-admin/admin-ajax.php\";s:4:\"line\";i:192;s:8:\"function\";s:9:\"do_action\";s:4:\"args\";a:1:{i:0;s:0:\"\";}}}", "1715329311");

/* INSERT TABLE DATA: ethr_aiowps_logged_in_users */
INSERT INTO `ethr_aiowps_logged_in_users` VALUES("7", "1", "salecius", "105.163.157.207", "1", "1715023141", "1715501898");

/* INSERT TABLE DATA: ethr_cartflows_ca_cart_abandonment */
INSERT INTO `ethr_cartflows_ca_cart_abandonment` VALUES("2", "40", "jenifferoburu@gmail.com", "a:1:{s:32:\"475fbefa9ebfba9233364533aafd02a3\";a:12:{s:3:\"key\";s:32:\"475fbefa9ebfba9233364533aafd02a3\";s:10:\"product_id\";i:4511;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";i:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:1:{i:1;d:1.5;}s:5:\"total\";a:1:{i:1;d:1.5;}}s:13:\"line_subtotal\";d:25;s:17:\"line_subtotal_tax\";d:1.5;s:10:\"line_total\";d:25;s:8:\"line_tax\";d:1.5;s:4:\"data\";O:17:\"WC_Product_Simple\":1:{s:5:\"\0*\0id\";i:4511;}}}", "32.50", "c4ad02d5738ffecae061fccde4453f2b", "a:19:{s:19:\"wcf_billing_company\";s:0:\"\";s:21:\"wcf_billing_address_1\";s:17:\"506 Wicklow place\";s:21:\"wcf_billing_address_2\";s:0:\"\";s:17:\"wcf_billing_state\";s:2:\"GA\";s:20:\"wcf_billing_postcode\";s:5:\"30102\";s:23:\"wcf_shipping_first_name\";s:0:\"\";s:22:\"wcf_shipping_last_name\";s:0:\"\";s:20:\"wcf_shipping_company\";s:0:\"\";s:20:\"wcf_shipping_country\";s:2:\"US\";s:22:\"wcf_shipping_address_1\";s:17:\"506 Wicklow Place\";s:22:\"wcf_shipping_address_2\";s:0:\"\";s:17:\"wcf_shipping_city\";s:7:\"Acworth\";s:18:\"wcf_shipping_state\";s:2:\"GA\";s:21:\"wcf_shipping_postcode\";s:5:\"30102\";s:18:\"wcf_order_comments\";s:0:\"\";s:14:\"wcf_first_name\";s:8:\"Jeniffer\";s:13:\"wcf_last_name\";s:5:\"Oburu\";s:16:\"wcf_phone_number\";s:10:\"4043175526\";s:12:\"wcf_location\";s:11:\"US, Acworth\";}", "abandoned", "0", "", "2024-05-08 14:16:25");

/* INSERT TABLE DATA: ethr_cartflows_ca_email_templates */
INSERT INTO `ethr_cartflows_ca_email_templates` VALUES("1", "Sample Email Template 1", "Purchase issue?", "<p>Hi {{customer.firstname}}!</p><p>We\\\'re having trouble processing your recent purchase. Would you mind completing it?</p><p>Here\\\'s a link to continue where you left off:</p><p><a href=\'{{cart.checkout_url}}\' target=\'_blank\' rel=\'noopener\'> Continue Your Purchase Now </a></p><p>Kindly,<br />{{admin.firstname}}<br />{{admin.company}}</p><p>{{cart.unsubscribe}}</p>", "0", "30", "MINUTE");
INSERT INTO `ethr_cartflows_ca_email_templates` VALUES("2", "Sample Email Template 2", "Need help?", "<p>Hi {{customer.firstname}}!</p><p>I\'m {{admin.firstname}}, and I help handle customer issues at {{admin.company}}.</p><p>I just noticed that you tried to make a purchase, but unfortunately, there was some trouble. Is there anything I can do to help?</p><p>You should be able to complete your checkout in less than a minute:<br /><a href=\'{{cart.checkout_url}}\' target=\'_blank\' rel=\'noopener\'> Click here to continue your purchase </a><p><p>Thanks!<br />{{admin.firstname}}<br />{{admin.company}}</p><p>{{cart.unsubscribe}}</p>", "0", "1", "DAY");
INSERT INTO `ethr_cartflows_ca_email_templates` VALUES("3", "Sample Email Template 3", "Exclusive discount for you. Let\'s get things started!", "<p>Few days back you left {{cart.product.names}} in your cart.</p><p>To help make up your mind, we have added an exclusive 10% discount coupon {{cart.coupon_code}} to your cart.</p><p><a href=\'{{cart.checkout_url}}\' target=\'_blank\' rel=\'noopener\'>Complete Your Purchase Now &gt;&gt;</a></p><p>Hurry! This is a onetime offer and will expire in 24 Hours.</p><p>In case you couldn\\\'t finish your order due to technical difficulties or because you need some help, just reply to this email we will be happy to help.</p><p>Kind Regards,<br />{{admin.firstname}}<br />{{admin.company}}</p><p>{{cart.unsubscribe}}</p>", "0", "3", "DAY");

/* INSERT TABLE DATA: ethr_cartflows_ca_email_templates_meta */
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("1", "1", "override_global_coupon", "");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("2", "1", "discount_type", "percent");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("3", "1", "coupon_amount", "10");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("4", "1", "coupon_expiry_date", "");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("5", "1", "coupon_expiry_unit", "hours");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("6", "1", "use_woo_email_style", "");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("7", "2", "override_global_coupon", "");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("8", "2", "discount_type", "percent");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("9", "2", "coupon_amount", "10");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("10", "2", "coupon_expiry_date", "");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("11", "2", "coupon_expiry_unit", "hours");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("12", "2", "use_woo_email_style", "");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("13", "3", "override_global_coupon", "");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("14", "3", "discount_type", "percent");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("15", "3", "coupon_amount", "10");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("16", "3", "coupon_expiry_date", "");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("17", "3", "coupon_expiry_unit", "hours");
INSERT INTO `ethr_cartflows_ca_email_templates_meta` VALUES("18", "3", "use_woo_email_style", "");

/* INSERT TABLE DATA: ethr_comments */
INSERT INTO `ethr_comments` VALUES("1", "4785", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 14:14:34", "2024-05-08 14:14:34", "Order status changed from Pending payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `ethr_comments` VALUES("2", "4785", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 14:14:49", "2024-05-08 14:14:49", "<strong>Fee details:</strong><div class=\"captured-event-details\" style=\"line-height: 0.8;padding-top: 15px;\">\n<br>Fee (2.61% + $0.27): -$1.12\n<br><span style=\"font-size: 7px;vertical-align: middle;\">&#9679;</span> Base fee: 2.9% + $0.30\n<br><span style=\"font-size: 7px;vertical-align: middle;\">&#9679;</span> Discount\n<br>&nbsp; &nbsp; <span style=\"font-size: 7px;vertical-align: middle;\">&#9675;</span> Variable fee: -0.29%\n<br>&nbsp; &nbsp; <span style=\"font-size: 7px;vertical-align: middle;\">&#9675;</span> Fixed fee: -$0.03\n<br>Net deposit: $31.38 USD\n</div>", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `ethr_comments` VALUES("3", "4786", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 14:15:45", "2024-05-08 14:15:45", "Order status changed from Pending payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `ethr_comments` VALUES("4", "4786", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 14:16:50", "2024-05-08 14:16:50", "<strong>Fee details:</strong><div class=\"captured-event-details\" style=\"line-height: 0.8;padding-top: 15px;\">\n<br>Fee (2.61% + $0.27): -$1.12\n<br><span style=\"font-size: 7px;vertical-align: middle;\">&#9679;</span> Base fee: 2.9% + $0.30\n<br><span style=\"font-size: 7px;vertical-align: middle;\">&#9679;</span> Discount\n<br>&nbsp; &nbsp; <span style=\"font-size: 7px;vertical-align: middle;\">&#9675;</span> Variable fee: -0.29%\n<br>&nbsp; &nbsp; <span style=\"font-size: 7px;vertical-align: middle;\">&#9675;</span> Fixed fee: -$0.03\n<br>Net deposit: $31.38 USD\n</div>", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `ethr_comments` VALUES("5", "4787", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 14:17:52", "2024-05-08 14:17:52", "Order status changed from Pending payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `ethr_comments` VALUES("6", "4787", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 16:07:38", "2024-05-08 16:07:38", "<strong>Fee details:</strong><div class=\"captured-event-details\" style=\"line-height: 0.8;padding-top: 15px;\">\n<br>Fee (2.61% + $0.27): -$1.12\n<br><span style=\"font-size: 7px;vertical-align: middle;\">&#9679;</span> Base fee: 2.9% + $0.30\n<br><span style=\"font-size: 7px;vertical-align: middle;\">&#9679;</span> Discount\n<br>&nbsp; &nbsp; <span style=\"font-size: 7px;vertical-align: middle;\">&#9675;</span> Variable fee: -0.29%\n<br>&nbsp; &nbsp; <span style=\"font-size: 7px;vertical-align: middle;\">&#9675;</span> Fixed fee: -$0.03\n<br>Net deposit: $31.38 USD\n</div>", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `ethr_comments` VALUES("7", "4788", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 16:35:00", "2024-05-08 16:35:00", "A payment of <span class=\"woocommerce-Price-amount amount\"><bdi><span class=\"woocommerce-Price-currencySymbol\">&#36;</span>28.79</bdi></span> was <strong>started</strong> using WooPayments (<code>pi_3PEDSJFvO9wzZIIA1x0rLrir</code>).", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `ethr_comments` VALUES("8", "4788", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 16:35:49", "2024-05-08 16:35:49", "Order status changed from Pending payment to Processing.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `ethr_comments` VALUES("9", "4788", "WooCommerce", "woocommerce@store.estheramunga.com", "", "", "2024-05-08 16:35:52", "2024-05-08 16:35:52", "<strong>Fee details:</strong><div class=\"captured-event-details\" style=\"line-height: 0.8;padding-top: 15px;\">\n<br>Fee (2.61% + $0.27): -$1.02\n<br><span style=\"font-size: 7px;vertical-align: middle;\">&#9679;</span> Base fee: 2.9% + $0.30\n<br><span style=\"font-size: 7px;vertical-align: middle;\">&#9679;</span> Discount\n<br>&nbsp; &nbsp; <span style=\"font-size: 7px;vertical-align: middle;\">&#9675;</span> Variable fee: -0.29%\n<br>&nbsp; &nbsp; <span style=\"font-size: 7px;vertical-align: middle;\">&#9675;</span> Fixed fee: -$0.03\n<br>Net deposit: $27.77 USD\n</div>", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: ethr_duplicator_packages */
INSERT INTO `ethr_duplicator_packages` VALUES("1", "20240510_esstaazshop", "3f02c763b8fe2aae4815_20240510082458", "23", "2024-05-10 08:26:41", "salecius", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-05-10 08:24:58\";s:7:\"Version\";s:5:\"1.5.9\";s:9:\"VersionWP\";s:5:\"6.5.3\";s:9:\"VersionDB\";s:6:\"5.7.44\";s:10:\"VersionPHP\";s:6:\"8.1.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:20:\"20240510_esstaazshop\";s:4:\"Hash\";s:35:\"3f02c763b8fe2aae4815_20240510082458\";s:8:\"NameHash\";s:56:\"20240510_esstaazshop_3f02c763b8fe2aae4815_20240510082458\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20240510_esstaazshop_3f02c763b8fe2aae4815_20240510082458_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.7\";s:6:\"WPUser\";s:8:\"salecius\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20240510_esstaazshop_3f02c763b8fe2aae4815_20240510082458_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:37:\"/home/estheram/store.estheramunga.com\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:4658;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:25888;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-05-10 08:24:58\";s:7:\"Version\";s:5:\"1.5.9\";s:9:\"VersionWP\";s:5:\"6.5.3\";s:9:\"VersionDB\";s:6:\"5.7.44\";s:10:\"VersionPHP\";s:6:\"8.1.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20240510_esstaazshop\";s:4:\"Hash\";s:35:\"3f02c763b8fe2aae4815_20240510082458\";s:8:\"NameHash\";s:56:\"20240510_esstaazshop_3f02c763b8fe2aae4815_20240510082458\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:74:\"20240510_esstaazshop_3f02c763b8fe2aae4815_20240510082458_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/estheram/store.estheramunga.com/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20240510_esstaazshop_3f02c763b8fe2aae4815_20240510082458_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:139:\"/home/estheram/store.estheramunga.com/wp-content/backups-dup-lite/tmp/20240510_esstaazshop_3f02c763b8fe2aae4815_20240510082458_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/estheram/store.estheramunga.com/wp-admin\";i:1;s:49:\"/home/estheram/store.estheramunga.com/wp-includes\";i:2;s:58:\"/home/estheram/store.estheramunga.com/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/estheram/store.estheramunga.com\";i:1;s:37:\"/home/estheram/store.estheramunga.com\";i:2;s:48:\"/home/estheram/store.estheramunga.com/wp-content\";i:3;s:56:\"/home/estheram/store.estheramunga.com/wp-content/uploads\";i:4;s:56:\"/home/estheram/store.estheramunga.com/wp-content/plugins\";i:5;s:59:\"/home/estheram/store.estheramunga.com/wp-content/mu-plugins\";i:6;s:55:\"/home/estheram/store.estheramunga.com/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/estheram/store.estheramunga.com/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: ethr_e_events */
INSERT INTO `ethr_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2024-01-17T03:00:38.064-03:00\"}", "2024-01-17 03:00:38");
INSERT INTO `ethr_e_events` VALUES("2", "{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2024-01-17T03:00:40.315-03:00\"}", "2024-01-17 03:00:40");
INSERT INTO `ethr_e_events` VALUES("3", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"hello\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2024-01-17T03:00:40.334-03:00\"}", "2024-01-17 03:00:40");
INSERT INTO `ethr_e_events` VALUES("4", "{\"event\":\"skip\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"hello\\\"}\",\"ts\":\"2024-01-17T03:00:41.451-03:00\"}", "2024-01-17 03:00:41");
INSERT INTO `ethr_e_events` VALUES("5", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"siteName\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2024-01-17T03:00:41.467-03:00\"}", "2024-01-17 03:00:41");
INSERT INTO `ethr_e_events` VALUES("6", "{\"even